/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver;

import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.ffmpeg.FFProbePacket;
import com.gmail.berndivader.streamserver.ffmpeg.InfoPacket;
import com.gmail.berndivader.streamserver.term.ANSI;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class Helper {
    public static final ExecutorService EXECUTOR;
    public static final ScheduledExecutorService SCHEDULED_EXECUTOR;
    public static final CloseableHttpClient HTTP_CLIENT;
    public static final Gson GSON;
    public static File[] files;
    public static File[] customs;

    public static int getFilePosition(String name) {
        if (!name.isEmpty()) {
            File[] files = (File[])Helper.files.clone();
            for (int i1 = 0; i1 < files.length; ++i1) {
                String file = files[i1].getName().toLowerCase();
                if (!file.equals(name)) continue;
                return i1;
            }
        }
        return -1;
    }

    public static int getCustomFilePosition(String name) {
        if (!name.isEmpty()) {
            File[] files = (File[])customs.clone();
            for (int i1 = 0; i1 < files.length; ++i1) {
                String file = files[i1].getName().toLowerCase();
                if (!file.equals(name)) continue;
                return i1;
            }
        }
        return -1;
    }

    public static ArrayList<String> getFilelistAsList(String regex) {
        String name;
        int i1;
        regex = ((String)regex).contains("*") ? ((String)regex).replaceAll("*", "(.*)") : "(.*)" + (String)regex + "(.*)";
        ArrayList<String> list = new ArrayList<String>();
        File[] files = (File[])Helper.files.clone();
        for (i1 = 0; i1 < files.length; ++i1) {
            name = files[i1].getName().toLowerCase();
            try {
                if (!name.matches((String)regex)) continue;
                list.add(name);
                continue;
            }
            catch (Exception e) {
                ANSI.printErr("getFilelistAsList method failed.", e);
            }
        }
        files = (File[])customs.clone();
        for (i1 = 0; i1 < files.length; ++i1) {
            name = files[i1].getName().toLowerCase();
            try {
                if (!name.matches((String)regex)) continue;
                list.add(name);
                continue;
            }
            catch (Exception e) {
                ANSI.println(e.getMessage());
            }
        }
        return list;
    }

    public static String getFilelistAsString(String regex) {
        String name;
        int i1;
        int count = 0;
        StringBuilder playlist = new StringBuilder();
        regex = ((String)regex).contains("*") ? ((String)regex).replaceAll("*", "(.*)") : "(.*)" + (String)regex + "(.*)";
        File[] files = (File[])Helper.files.clone();
        for (i1 = 0; i1 < files.length; ++i1) {
            name = files[i1].getName().toLowerCase();
            if (name == null || name.isEmpty() || !name.matches((String)regex)) continue;
            playlist.append(name + "\n");
            ++count;
        }
        files = (File[])customs.clone();
        for (i1 = 0; i1 < files.length; ++i1) {
            name = files[i1].getName().toLowerCase();
            if (name == null || name.isEmpty() || !name.matches((String)regex)) continue;
            playlist.append(name + "\n");
            ++count;
        }
        playlist.append("\nThere are " + count + " matches for " + (String)regex);
        return playlist.toString();
    }

    public static void shuffleFilelist(File[] files) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i1 = files.length - 1; i1 > 0; --i1) {
            int index = ((Random)random).nextInt(i1 + 1);
            File a = files[index];
            files[index] = files[i1];
            files[i1] = a;
        }
    }

    public static void refreshFilelist() {
        File file = new File(Config.PLAYLIST_PATH);
        File custom = new File(Config.PLAYLIST_PATH_CUSTOM);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().toLowerCase().endsWith(".mp4");
            }
        };
        files = file.exists() ? (file.isDirectory() ? file.listFiles(filter) : (file.isFile() ? new File[]{file} : new File[0])) : new File[0];
        customs = custom.exists() ? (custom.isDirectory() ? custom.listFiles(filter) : (custom.isFile() ? new File[]{custom} : new File[0])) : new File[0];
    }

    public static String getStringFromStream(InputStream stream, int length) {
        byte[] bytes = new byte[length];
        try {
            int size = stream.read(bytes, 0, length);
            return new String(bytes).substring(0, size - 1);
        }
        catch (IOException e) {
            ANSI.printErr("getStringFromStream method failed.", e);
            return "";
        }
    }

    public static FFProbePacket createDownloadLink(File file) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(new File("./"));
        builder.command("ffprobe", "-v", "quiet", "-print_format", "json", "-show_format", file.getAbsolutePath());
        FFProbePacket packet = new FFProbePacket();
        try {
            Process process = builder.start();
            BufferedReader reader = process.inputReader();
            while (process.isAlive()) {
                if (!reader.ready()) continue;
                packet = GSON.fromJson(process.inputReader().readLine(), FFProbePacket.class);
            }
        }
        catch (Exception e) {
            ANSI.printErr("createDownloadlink method failed.", e);
        }
        return packet;
    }

    public static InfoPacket getDLPinfoPacket(List<String> commands, File directory, String url) {
        ProcessBuilder infoBuilder = new ProcessBuilder(new String[0]);
        infoBuilder.directory(directory);
        infoBuilder.command(commands);
        infoBuilder.command().addAll(Arrays.asList("--quiet", "--no-warnings", "--dump-json", url));
        InfoPacket info = new InfoPacket();
        try {
            Process infoProc = infoBuilder.start();
            BufferedReader reader = infoProc.inputReader();
            while (infoProc.isAlive()) {
                if (!reader.ready()) continue;
                info = GSON.fromJson(infoProc.inputReader().readLine(), InfoPacket.class);
            }
        }
        catch (IOException e) {
            ANSI.printErr("getDLPinfoPacket method failed.", e);
        }
        return info;
    }

    public static Map.Entry<ProcessBuilder, Optional<InfoPacket>> prepareDownloadBuilder(File directory, String args) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(directory);
        boolean downloadable = false;
        if (args.contains("--downloadable")) {
            args = args.replace("--downloadable", "");
            downloadable = true;
        }
        if (args.contains("--no-default")) {
            args = args.replace("--no-default", "");
            builder.command("yt-dlp", "--progress-delta", "2", "--restrict-filenames", "--embed-metadata", "--embed-thumbnail", "--output", "%(title).64s.%(ext)s");
        } else if (args.contains("--auto ")) {
            File dir;
            args = args.replace("--auto", "");
            builder.command("yt-dlp", "--progress-delta", "2", "--restrict-filenames", "--embed-metadata", "--embed-thumbnail", "--output", "%(title).64s.%(ext)s");
            if (Config.YOUTUBE_USE_COOKIES.booleanValue() && Config.YOUTUBE_COOKIES.exists()) {
                builder.command().add("--cookies");
                builder.command().add(Config.YOUTUBE_COOKIES.getAbsolutePath());
            }
            if ((dir = Helper.getOrCreateMediaDir("temp")) != null) {
                builder.directory(dir);
            }
            downloadable = true;
        } else {
            builder.command("yt-dlp", "--progress-delta", "2", "--embed-metadata", "--embed-thumbnail", "--ignore-errors", "--extract-audio", "--format", "bestaudio", "--audio-format", "mp3", "--audio-quality", "160K", "--output", "%(title).64s.%(ext)s", "--restrict-filenames", "--no-playlist");
        }
        String[] temp = args.split("--");
        String url = "";
        block10: for (int i = 0; i < temp.length; ++i) {
            String[] parse;
            if (temp[i].isEmpty() || (parse = temp[i].trim().split(" ", 2)).length <= 0) continue;
            switch (parse[0]) {
                case "url": {
                    if (parse.length != 2) continue block10;
                    url = parse[1];
                    parse[1] = "";
                    continue block10;
                }
                case "dir": {
                    if (parse.length != 2) continue block10;
                    File dir = Helper.getOrCreateMediaDir(parse[1]);
                    parse[1] = "";
                    if (dir != null) {
                        builder.directory(dir);
                        continue block10;
                    }
                    ANSI.printWarn("Warning! Download directory is a file, using default.");
                    continue block10;
                }
                case "cookies": {
                    if (!Config.YOUTUBE_USE_COOKIES.booleanValue() || !Config.YOUTUBE_COOKIES.exists()) continue block10;
                    builder.command().add("--cookies");
                    builder.command().add(Config.YOUTUBE_COOKIES.getAbsolutePath());
                    continue block10;
                }
                default: {
                    if (parse[0].isEmpty()) continue block10;
                    builder.command().add(parse[0]);
                }
            }
        }
        InfoPacket infoPacket = Helper.getDLPinfoPacket(new ArrayList<String>(builder.command()), builder.directory(), url);
        if (!url.isEmpty()) {
            builder.command().add(url);
        }
        infoPacket.downloadable = downloadable;
        return Map.entry(builder, Optional.ofNullable(infoPacket));
    }

    public static File getOrCreateMediaDir(String name) {
        File dir = new File(Config.DL_MUSIC_PATH.concat("/").concat(name));
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (dir.isDirectory()) {
            return dir;
        }
        return null;
    }

    public static void close() {
        ANSI.print("[WHITE]Shutdown task executor...");
        EXECUTOR.shutdown();
        ANSI.println("[GREEN]DONE!");
        ANSI.print("[WHITE]Shutdown scheduled task executor...");
        SCHEDULED_EXECUTOR.shutdown();
        ANSI.println("[GREEN]DONE![/GREEN]");
    }

    static {
        files = new File[0];
        customs = new File[0];
        EXECUTOR = Executors.newFixedThreadPool(10);
        SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(5);
        HTTP_CLIENT = HttpClients.createMinimal();
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }
}

