/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.mysql;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.mysql.DatabaseConnection;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class CleanUpDownloadables
implements Callable<Boolean> {
    private static final String SELECT_SQL = "SELECT path FROM downloadables WHERE timestamp < UNIX_TIMESTAMP(NOW()-INTERVAL " + Config.DL_INTERVAL_VALUE + " " + Config.DL_INTERVAL_FORMAT + ");";
    private static final String DELETE_SQL = "DELETE FROM downloadables WHERE timestamp < UNIX_TIMESTAMP(NOW()-INTERVAL " + Config.DL_INTERVAL_VALUE + " " + Config.DL_INTERVAL_FORMAT + ");";
    public Future<Boolean> future = Helper.EXECUTOR.submit(this);

    @Override
    public Boolean call() {
        try (Connection connection = DatabaseConnection.getNewConnection();){
            try (PreparedStatement statement = connection.prepareStatement(SELECT_SQL, 1004, 1007);){
                ResultSet result = statement.executeQuery();
                int count = 0;
                if (result.first()) {
                    do {
                        File file;
                        if ((file = new File(result.getString("path"))).exists()) {
                            file.delete();
                        }
                        ++count;
                    } while (result.next());
                }
                if (Config.DEBUG.booleanValue()) {
                    ANSI.println(count + " files are deleted from disc.");
                }
            }
            statement = connection.prepareStatement(DELETE_SQL, 1004, 1008);
            try {
                int dels = statement.executeUpdate();
                if (Config.DEBUG.booleanValue()) {
                    ANSI.println(dels + " files are deleted from database.");
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            ANSI.printErr("Failed to cleanup downloadable database and files", e);
            return false;
        }
        return true;
    }
}

