/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.console.command;

import com.gmail.berndivader.streamserver.StreamServer;
import com.gmail.berndivader.streamserver.annotation.ConsoleCommand;
import com.gmail.berndivader.streamserver.console.command.Command;
import com.gmail.berndivader.streamserver.discord.DiscordBot;
import com.gmail.berndivader.streamserver.ffmpeg.BroadcastRunner;
import com.gmail.berndivader.streamserver.mysql.DatabaseConnection;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class Commands {
    public static Commands instance;
    static final String PACKAGE_NAME = "com/gmail/berndivader/streamserver/console/command/commands";
    static String fileName;
    public HashMap<String, Class<Command>> commands;

    public Commands() {
        instance = this;
        this.commands = new HashMap();
        try {
            this.loadCommandClasses();
        }
        catch (IOException | ClassNotFoundException e) {
            ANSI.printErr("Failed to instantiate console commands.", e);
        }
    }

    void loadCommandClasses() throws IOException, ClassNotFoundException {
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(fileName));){
            while (jarStream.available() == 1) {
                Class<?> clazz;
                ConsoleCommand anno;
                String clazzName;
                JarEntry entry = jarStream.getNextJarEntry();
                if (entry == null || !(clazzName = entry.getName()).endsWith(".class") || !clazzName.startsWith(PACKAGE_NAME) || (anno = (clazz = Class.forName(clazzName = clazzName.substring(0, clazzName.length() - 6).replace("/", "."))).getAnnotation(ConsoleCommand.class)) == null) continue;
                boolean add = true;
                block11: for (int i = 0; i < anno.requireds().length; ++i) {
                    switch (anno.requireds()[i]) {
                        case BROADCASTRUNNER: {
                            add &= BroadcastRunner.instance != null;
                            continue block11;
                        }
                        case DISCORDBOT: {
                            add &= DiscordBot.instance != null;
                            continue block11;
                        }
                        case DATABASE: {
                            add &= DatabaseConnection.INIT;
                            continue block11;
                        }
                        default: {
                            add = true;
                        }
                    }
                }
                if (!add) continue;
                this.commands.put(anno.name(), clazz);
            }
        }
    }

    public Command getCommand(String name) {
        Class<Command> clazz = this.commands.get(name);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            ANSI.printErr("Error getting console command class.", e);
            return null;
        }
    }

    static {
        try {
            fileName = URLDecoder.decode(StreamServer.class.getProtectionDomain().getCodeSource().getLocation().getPath(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            try {
                fileName = URLDecoder.decode(StreamServer.class.getProtectionDomain().getCodeSource().getLocation().getPath(), StandardCharsets.ISO_8859_1.toString());
            }
            catch (UnsupportedEncodingException e1) {
                ANSI.printErr("Error, there is no UTF-8 nor a ISO-8859 encoding avaible.", e1);
            }
        }
    }
}

