/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.Invite;
import discord4j.core.spec.AuditSpec;
import discord4j.discordjson.json.ImmutableInviteCreateRequest;
import discord4j.discordjson.json.InviteCreateRequest;
import reactor.util.annotation.Nullable;

public class InviteCreateSpec
implements AuditSpec<InviteCreateRequest> {
    private final ImmutableInviteCreateRequest.Builder requestBuilder = InviteCreateRequest.builder();
    @Nullable
    private String reason;

    public InviteCreateSpec setMaxAge(int maxAge) {
        this.requestBuilder.maxAge(maxAge);
        return this;
    }

    public InviteCreateSpec setMaxUses(int maxUses) {
        this.requestBuilder.maxUses(maxUses);
        return this;
    }

    public InviteCreateSpec setTemporary(boolean temporary) {
        this.requestBuilder.temporary(temporary);
        return this;
    }

    public InviteCreateSpec setUnique(boolean unique) {
        this.requestBuilder.unique(unique);
        return this;
    }

    public InviteCreateSpec setTargetType(Invite.Type targetType) {
        this.requestBuilder.targetType(targetType.getValue());
        return this;
    }

    public InviteCreateSpec setTargetUserId(Snowflake targetUserId) {
        this.requestBuilder.targetUserId(targetUserId.asString());
        return this;
    }

    public InviteCreateSpec setTargetApplicationId(Snowflake targetApplicationId) {
        this.requestBuilder.targetApplicationId(targetApplicationId.asString());
        return this;
    }

    public InviteCreateSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public InviteCreateRequest asRequest() {
        return this.requestBuilder.build();
    }
}

