/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.spec.AuditSpec;
import discord4j.discordjson.json.GuildMemberModifyRequest;
import discord4j.discordjson.json.ImmutableGuildMemberModifyRequest;
import discord4j.discordjson.possible.Possible;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class GuildMemberEditSpec
implements AuditSpec<GuildMemberModifyRequest> {
    private final ImmutableGuildMemberModifyRequest.Builder builder = GuildMemberModifyRequest.builder();
    @Nullable
    private String reason;

    public GuildMemberEditSpec setNewVoiceChannel(@Nullable Snowflake channel) {
        this.builder.channelId(Possible.of(Optional.ofNullable(channel).map(Snowflake::asString)));
        return this;
    }

    public GuildMemberEditSpec setMute(boolean mute) {
        this.builder.mute(mute);
        return this;
    }

    public GuildMemberEditSpec setDeafen(boolean deaf) {
        this.builder.deaf(deaf);
        return this;
    }

    public GuildMemberEditSpec setNickname(@Nullable String nickname) {
        if (nickname != null) {
            this.builder.nick(nickname);
        } else {
            this.builder.nick(Possible.absent());
        }
        return this;
    }

    public GuildMemberEditSpec setRoles(Set<Snowflake> roles) {
        this.builder.roles(roles.stream().map(Snowflake::asString).collect(Collectors.toList()));
        return this;
    }

    public GuildMemberEditSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public GuildMemberModifyRequest asRequest() {
        return this.builder.build();
    }
}

