/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import discord4j.rest.util.ApplicationCommandOptionType;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Experimental
public class ApplicationCommandInteractionOptionValue
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    @Nullable
    private final Long guildId;
    private final int type;
    private final String value;

    public ApplicationCommandInteractionOptionValue(GatewayDiscordClient gateway, @Nullable Long guildId, int type, String value) {
        this.gateway = gateway;
        this.guildId = guildId;
        this.value = value;
        this.type = type;
    }

    public String getRaw() {
        return this.value;
    }

    public String asString() {
        if (this.type != ApplicationCommandOptionType.STRING.getValue()) {
            throw new IllegalArgumentException("Option value cannot be converted as string");
        }
        return this.value;
    }

    public boolean asBoolean() {
        if (this.type != ApplicationCommandOptionType.BOOLEAN.getValue()) {
            throw new IllegalArgumentException("Option value cannot be converted as boolean");
        }
        return Boolean.parseBoolean(this.value);
    }

    public long asLong() {
        if (this.type != ApplicationCommandOptionType.INTEGER.getValue()) {
            throw new IllegalArgumentException("Option value cannot be converted as long");
        }
        return Long.parseLong(this.value);
    }

    public Snowflake asSnowflake() {
        if (this.type != ApplicationCommandOptionType.USER.getValue() && this.type != ApplicationCommandOptionType.ROLE.getValue() && this.type != ApplicationCommandOptionType.CHANNEL.getValue()) {
            throw new IllegalArgumentException("Option value cannot be converted as snowflake");
        }
        return Snowflake.of(this.value);
    }

    public Mono<User> asUser() {
        if (this.type != ApplicationCommandOptionType.USER.getValue()) {
            return Mono.error(new IllegalArgumentException("Option value cannot be converted as user"));
        }
        return this.getClient().getUserById(this.asSnowflake());
    }

    public Mono<Role> asRole() {
        if (this.type != ApplicationCommandOptionType.ROLE.getValue()) {
            return Mono.error(new IllegalArgumentException("Option value cannot be converted as role"));
        }
        return this.getClient().getRoleById(Snowflake.of(this.guildId), this.asSnowflake());
    }

    public Mono<Channel> asChannel() {
        if (this.type != ApplicationCommandOptionType.CHANNEL.getValue()) {
            return Mono.error(new IllegalArgumentException("Option value cannot be converted as channel"));
        }
        return this.getClient().getChannelById(this.asSnowflake());
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }
}

