/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.GuildMessageChannel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.WebhookEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.WebhookData;
import discord4j.discordjson.json.WebhookPartialChannelData;
import discord4j.discordjson.json.WebhookPartialGuildData;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class Webhook
implements Entity {
    private final GatewayDiscordClient gateway;
    private final WebhookData data;

    public Webhook(GatewayDiscordClient gateway, WebhookData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    public WebhookData getData() {
        return this.data;
    }

    public Type getType() {
        return Type.of(this.data.type());
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.data.guildId().get().get());
    }

    public Mono<Guild> getGuild() {
        return this.gateway.getGuildById(this.getGuildId());
    }

    public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getGuildById(this.getGuildId());
    }

    public Snowflake getChannelId() {
        return Snowflake.of(this.data.channelId().get());
    }

    public Mono<GuildMessageChannel> getChannel() {
        return this.gateway.getChannelById(this.getChannelId()).cast(GuildMessageChannel.class);
    }

    public Mono<GuildMessageChannel> getChannel(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById(this.getChannelId()).cast(GuildMessageChannel.class);
    }

    public Snowflake getCreatorId() {
        return Snowflake.of(this.data.user().get().id());
    }

    public Mono<User> getCreator() {
        return this.gateway.getUserById(this.getCreatorId());
    }

    public Mono<User> getCreator(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getUserById(this.getCreatorId());
    }

    public Optional<String> getName() {
        return this.data.name();
    }

    public Optional<String> getAvatar() {
        return this.data.avatar();
    }

    public String getToken() {
        return this.data.token().get();
    }

    public Optional<Snowflake> getApplicationId() {
        return this.data.applicationId().map(Snowflake::of);
    }

    public Optional<Snowflake> getSourceGuildId() {
        return this.data.sourceGuild().toOptional().map(WebhookPartialGuildData::id).map(Snowflake::of);
    }

    public Optional<String> getSourceGuildName() {
        return this.data.sourceGuild().toOptional().map(WebhookPartialGuildData::name);
    }

    public Optional<Snowflake> getSourceChannelId() {
        return this.data.sourceChannel().toOptional().map(WebhookPartialChannelData::id).map(Snowflake::of);
    }

    public Optional<String> getSourceChannelName() {
        return this.data.sourceChannel().toOptional().map(WebhookPartialChannelData::name);
    }

    public Mono<Void> delete() {
        return this.delete(null);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.gateway.getRestClient().getWebhookService().deleteWebhook(this.getId().asLong(), reason);
    }

    public Mono<Webhook> edit(Consumer<? super WebhookEditSpec> spec) {
        return Mono.defer(() -> {
            WebhookEditSpec mutatedSpec = new WebhookEditSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getWebhookService().modifyWebhook(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> new Webhook(this.gateway, (WebhookData)data));
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "Webhook{data=" + this.data + '}';
    }

    public static enum Type {
        UNKNOWN(-1),
        INCOMING(1),
        CHANNEL_FOLLOWER(2);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 1: {
                    return INCOMING;
                }
                case 2: {
                    return CHANNEL_FOLLOWER;
                }
            }
            return UNKNOWN;
        }
    }
}

