/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.interaction;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.Event;
import discord4j.core.object.command.Interaction;
import discord4j.core.object.entity.Message;
import discord4j.core.spec.InteractionApplicationCommandCallbackSpec;
import discord4j.discordjson.json.FollowupMessageRequest;
import discord4j.discordjson.json.ImmutableFollowupMessageRequest;
import discord4j.discordjson.json.ImmutableInteractionApplicationCommandCallbackData;
import discord4j.discordjson.json.ImmutableInteractionResponseData;
import discord4j.discordjson.json.InteractionApplicationCommandCallbackData;
import discord4j.discordjson.json.InteractionData;
import discord4j.discordjson.json.InteractionResponseData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.WebhookMessageEditRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.gateway.ShardInfo;
import discord4j.rest.RestClient;
import discord4j.rest.interaction.InteractionResponse;
import discord4j.rest.util.InteractionResponseType;
import discord4j.rest.util.WebhookMultipartRequest;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Experimental
public class InteractionCreateEvent
extends Event {
    private final Interaction interaction;
    private final EventInteractionResponse response;

    public InteractionCreateEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, Interaction interaction) {
        super(gateway, shardInfo);
        this.interaction = interaction;
        this.response = new EventInteractionResponse(this.getClient().rest(), interaction.getData());
    }

    public Interaction getInteraction() {
        return this.interaction;
    }

    protected Mono<Void> createInteractionResponse(InteractionResponseType responseType, @Nullable InteractionApplicationCommandCallbackData data) {
        ImmutableInteractionResponseData responseData = InteractionResponseData.builder().type(responseType.getValue()).data(data == null ? Possible.absent() : Possible.of(data)).build();
        long id = this.interaction.getId().asLong();
        String token = this.interaction.getToken();
        return this.getClient().rest().getInteractionService().createInteractionResponse(id, token, responseData);
    }

    public Mono<Void> acknowledge() {
        return this.createInteractionResponse(InteractionResponseType.DEFERRED_CHANNEL_MESSAGE_WITH_SOURCE, null);
    }

    public Mono<Void> acknowledgeEphemeral() {
        ImmutableInteractionApplicationCommandCallbackData data = InteractionApplicationCommandCallbackData.builder().flags(Message.Flag.EPHEMERAL.getFlag()).build();
        return this.createInteractionResponse(InteractionResponseType.DEFERRED_CHANNEL_MESSAGE_WITH_SOURCE, data);
    }

    public Mono<Void> reply(String content) {
        return this.reply((? super InteractionApplicationCommandCallbackSpec spec) -> spec.setContent(content));
    }

    public Mono<Void> replyEphemeral(String content) {
        return this.reply((? super InteractionApplicationCommandCallbackSpec spec) -> spec.setContent(content).setEphemeral(true));
    }

    public Mono<Void> reply(Consumer<? super InteractionApplicationCommandCallbackSpec> spec) {
        return Mono.defer(() -> {
            InteractionApplicationCommandCallbackSpec mutatedSpec = new InteractionApplicationCommandCallbackSpec();
            this.getClient().getRestClient().getRestResources().getAllowedMentions().ifPresent(mutatedSpec::setAllowedMentions);
            spec.accept(mutatedSpec);
            return this.createInteractionResponse(InteractionResponseType.CHANNEL_MESSAGE_WITH_SOURCE, mutatedSpec.asRequest());
        });
    }

    public InteractionResponse getInteractionResponse() {
        return this.response;
    }

    static class EventInteractionResponse
    implements InteractionResponse {
        private final RestClient restClient;
        private final InteractionData interactionData;
        private final long applicationId;

        EventInteractionResponse(RestClient restClient, InteractionData interactionData) {
            this.restClient = restClient;
            this.interactionData = interactionData;
            this.applicationId = Snowflake.asLong(interactionData.applicationId());
        }

        @Override
        public Mono<MessageData> editInitialResponse(WebhookMessageEditRequest request) {
            return this.restClient.getWebhookService().modifyWebhookMessage(this.applicationId, this.interactionData.token(), "@original", request);
        }

        @Override
        public Mono<Void> deleteInitialResponse() {
            return this.restClient.getWebhookService().deleteWebhookMessage(this.applicationId, this.interactionData.token(), "@original");
        }

        @Override
        public Mono<MessageData> createFollowupMessage(String content) {
            ImmutableFollowupMessageRequest body = FollowupMessageRequest.builder().content(content).build();
            WebhookMultipartRequest request = new WebhookMultipartRequest(body);
            return this.restClient.getWebhookService().executeWebhook(this.applicationId, this.interactionData.token(), true, request);
        }

        @Override
        public Mono<MessageData> createFollowupMessage(WebhookMultipartRequest request) {
            return this.restClient.getWebhookService().executeWebhook(this.applicationId, this.interactionData.token(), true, request);
        }

        @Override
        public Mono<MessageData> createFollowupMessageEphemeral(String content) {
            ImmutableFollowupMessageRequest body = FollowupMessageRequest.builder().content(content).flags(Message.Flag.EPHEMERAL.getFlag()).build();
            WebhookMultipartRequest request = new WebhookMultipartRequest(body);
            return this.restClient.getWebhookService().executeWebhook(this.applicationId, this.interactionData.token(), true, request);
        }

        @Override
        public Mono<MessageData> createFollowupMessageEphemeral(WebhookMultipartRequest request) {
            ImmutableFollowupMessageRequest newBody = FollowupMessageRequest.builder().from(request.getExecuteRequest()).flags(Message.Flag.EPHEMERAL.getFlag()).build();
            WebhookMultipartRequest newRequest = new WebhookMultipartRequest(newBody, request.getFiles());
            return this.restClient.getWebhookService().executeWebhook(this.applicationId, this.interactionData.token(), true, newRequest);
        }

        @Override
        public Mono<MessageData> editFollowupMessage(long messageId, WebhookMessageEditRequest request, boolean wait) {
            return this.restClient.getWebhookService().modifyWebhookMessage(this.applicationId, this.interactionData.token(), String.valueOf(messageId), request);
        }

        @Override
        public Mono<Void> deleteFollowupMessage(long messageId) {
            return this.restClient.getWebhookService().deleteWebhookMessage(this.applicationId, this.interactionData.token(), String.valueOf(messageId));
        }
    }
}

