/*
 * Decompiled with CFR 0.152.
 */
package discord4j.store.api.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class LongLongTuple2
implements Iterable<Long>,
Comparable<LongLongTuple2> {
    private static final long serialVersionUID = 6977984978741213834L;
    final long t1;
    final long t2;

    public static LongLongTuple2 of(long t1, long t2) {
        return new LongLongTuple2(t1, t2);
    }

    public static LongLongTuple2 from(Tuple2<Long, Long> tuple2) {
        return LongLongTuple2.of(tuple2.getT1(), tuple2.getT2());
    }

    public static Tuple2<Long, Long> convert(LongLongTuple2 tuple) {
        return Tuples.of(tuple.getT1(), tuple.getT2());
    }

    @JsonCreator
    LongLongTuple2(@JsonProperty(value="t1") long t1, @JsonProperty(value="t2") long t2) {
        this.t1 = t1;
        this.t2 = t2;
    }

    public long getT1() {
        return this.t1;
    }

    public long getT2() {
        return this.t2;
    }

    public long get(int index) {
        switch (index) {
            case 0: {
                return this.t1;
            }
            case 1: {
                return this.t2;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public List<Long> toList() {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(this.t1);
        list.add(this.t2);
        return list;
    }

    public long[] toArray() {
        return new long[]{this.t1, this.t2};
    }

    @Override
    public Iterator<Long> iterator() {
        return Collections.unmodifiableList(this.toList()).iterator();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() && !o.getClass().equals(Tuple2.class)) {
            return false;
        }
        if (o.getClass().equals(Tuple2.class)) {
            Tuple2 tuple2 = (Tuple2)o;
            return tuple2.getT1().equals(this.t1) && tuple2.getT2().equals(this.t2);
        }
        LongLongTuple2 tuple2 = (LongLongTuple2)o;
        return tuple2.t1 == this.t1 && tuple2.t2 == this.t2;
    }

    public int hashCode() {
        int result = this.size();
        result = 31 * result + Long.hashCode(this.t1);
        result = 31 * result + Long.hashCode(this.t2);
        return result;
    }

    public int size() {
        return 2;
    }

    public final String toString() {
        return LongLongTuple2.tupleStringRepresentation(this.t1, this.t2).insert(0, '[').append(']').toString();
    }

    static StringBuilder tupleStringRepresentation(Object ... values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            Object t = values[i];
            if (i != 0) {
                sb.append(',');
            }
            if (t == null) continue;
            sb.append(t);
        }
        return sb;
    }

    @Override
    public int compareTo(LongLongTuple2 o) {
        if (o.t1 == this.t1 && o.t2 == this.t2) {
            return 0;
        }
        if (o.t1 != this.t1) {
            return this.t1 < o.t1 ? -1 : 1;
        }
        return this.t2 < o.t2 ? -1 : 1;
    }
}

