/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.discord.command.commands;

import com.gmail.berndivader.streamserver.annotation.DiscordCommand;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.discord.command.Command;
import com.gmail.berndivader.streamserver.term.ANSI;
import com.gmail.berndivader.streamserver.youtube.Youtube;
import com.gmail.berndivader.streamserver.youtube.packets.EmptyPacket;
import com.gmail.berndivader.streamserver.youtube.packets.LiveStreamPacket;
import com.gmail.berndivader.streamserver.youtube.packets.Packet;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.rest.util.Color;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

@DiscordCommand(name="info", usage="Show stream status.")
public class LivestreamInfo
extends Command<Message> {
    private Packet packet;

    @Override
    public Mono<Message> execute(String string, MessageChannel channel) {
        this.packet = new EmptyPacket();
        Future<Packet> future = Youtube.livestreamsByChannelId(Config.YOUTUBE_CHANNEL_ID);
        try {
            this.packet = future.get(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            ANSI.printErr(e.getMessage(), e);
        }
        return channel.createEmbed((Consumer<? super EmbedCreateSpec>)new Consumer<EmbedCreateSpec>(){

            @Override
            public void accept(EmbedCreateSpec embed) {
                if (LivestreamInfo.this.packet instanceof LiveStreamPacket) {
                    LiveStreamPacket p = (LiveStreamPacket)LivestreamInfo.this.packet;
                    embed.setColor(Color.CINNABAR);
                    embed.setAuthor(p.snippet.channelTitle, "https://www.youtube.com/channel/" + p.snippet.channelId, p.snippet.thumbnails.low.url);
                    embed.setImage(p.snippet.thumbnails.medium.url);
                    embed.setUrl("https://www.youtube.com/watch?v=" + p.id.videoId);
                    embed.setDescription(p.snippet.description);
                    embed.setFooter("Broadcastcontent: " + p.snippet.liveBroadcastContent, p.snippet.thumbnails.low.url);
                    embed.setThumbnail(p.snippet.thumbnails.low.url);
                    embed.setTitle(p.snippet.title);
                } else {
                    embed.setTitle("Error");
                    embed.setColor(Color.RED);
                    embed.setDescription("Unable to get livestream status from YT.");
                }
            }
        });
    }
}

