/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.console.command.commands;

import com.gmail.berndivader.streamserver.annotation.ConsoleCommand;
import com.gmail.berndivader.streamserver.annotation.Requireds;
import com.gmail.berndivader.streamserver.console.command.Command;
import com.gmail.berndivader.streamserver.ffmpeg.BroadcastRunner;
import com.gmail.berndivader.streamserver.term.ANSI;

@ConsoleCommand(name="f", usage="[title|artist|date|comment|playtime|file|bitrate|format] -> Show ffmpegprobe gathered info.", requireds={Requireds.BROADCASTRUNNER})
public class StreamInfo
extends Command {
    @Override
    public boolean execute(String[] args) {
        if (BroadcastRunner.isStreaming()) {
            if (BroadcastRunner.format != null) {
                float duration = BroadcastRunner.format.getDuration().floatValue();
                ANSI.println("===Current playing===");
                block22: for (int i1 = 0; i1 < args.length; ++i1) {
                    switch (args[i1]) {
                        case "title": {
                            ANSI.println("Title: " + BroadcastRunner.format.getTag("title"));
                            continue block22;
                        }
                        case "artist": {
                            ANSI.println("Artist:" + BroadcastRunner.format.getTag("artist"));
                            continue block22;
                        }
                        case "date": {
                            ANSI.println("Date:" + BroadcastRunner.format.getTag("date"));
                            continue block22;
                        }
                        case "comment": {
                            ANSI.println("Comment:" + BroadcastRunner.format.getTag("comment"));
                            continue block22;
                        }
                        case "playtime": 
                        case "time": {
                            ANSI.println("Playtime:" + (long)(duration / 60.0f) + ":" + (long)(duration % 60.0f));
                            continue block22;
                        }
                        case "file": {
                            ANSI.println("File:" + BroadcastRunner.format.getFilename());
                            continue block22;
                        }
                        case "bitrate": 
                        case "bits": {
                            ANSI.println("Bitrate:" + BroadcastRunner.format.getBitRate());
                            continue block22;
                        }
                        case "format": {
                            ANSI.println("Format:" + BroadcastRunner.format.getFormatName());
                            continue block22;
                        }
                        default: {
                            ANSI.println("Title: " + BroadcastRunner.format.getTag("title"));
                            ANSI.println("Artist:" + BroadcastRunner.format.getTag("artist"));
                            ANSI.println("Date:" + BroadcastRunner.format.getTag("date"));
                            ANSI.println("Comment:" + BroadcastRunner.format.getTag("comment"));
                            ANSI.println("Playtime:" + (long)(duration / 60.0f) + ":" + (long)(duration % 60.0f));
                            ANSI.println("File:" + BroadcastRunner.format.getFilename());
                            ANSI.println("Bitrate:" + BroadcastRunner.format.getBitRate());
                            ANSI.println("Format:" + BroadcastRunner.format.getFormatName());
                        }
                    }
                }
            } else {
                ANSI.println("No information about stream available.");
            }
        } else {
            ANSI.println("Currently no stream is running.");
        }
        return true;
    }
}

