/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.ffmpeg;

import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffmpeg.FFmpeg;
import com.github.kokorin.jaffree.ffmpeg.FFmpegProgress;
import com.github.kokorin.jaffree.ffmpeg.FFmpegResult;
import com.github.kokorin.jaffree.ffmpeg.FFmpegResultFuture;
import com.github.kokorin.jaffree.ffmpeg.Input;
import com.github.kokorin.jaffree.ffmpeg.Output;
import com.github.kokorin.jaffree.ffmpeg.OutputListener;
import com.github.kokorin.jaffree.ffmpeg.ProgressListener;
import com.github.kokorin.jaffree.ffmpeg.UrlInput;
import com.github.kokorin.jaffree.ffmpeg.UrlOutput;
import com.github.kokorin.jaffree.ffprobe.FFprobe;
import com.github.kokorin.jaffree.ffprobe.FFprobeResult;
import com.github.kokorin.jaffree.ffprobe.Format;
import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.discord.DiscordBot;
import com.gmail.berndivader.streamserver.mysql.GetNextScheduled;
import com.gmail.berndivader.streamserver.mysql.UpdateCurrent;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

public final class BroadcastRunner
extends TimerTask {
    boolean stop;
    public static FFmpegProgress progress;
    public static Format format;
    public static String message;
    public static File playing;
    private static FFmpegResultFuture ffmpeg;
    public static int index;
    private static File[] files;
    private static File[] customs;
    public static BroadcastRunner instance;

    public BroadcastRunner() {
        ANSI.print("[YELLOW]Starting BroadcastRunner...");
        this.stop = false;
        BroadcastRunner.refreshFilelist();
        BroadcastRunner.shuffleFilelist();
        index = 0;
        this.startStream();
        Helper.SCHEDULED_EXECUTOR.scheduleAtFixedRate(this, 0L, 1L, TimeUnit.SECONDS);
        ANSI.println("[GREEN]DONE![RESET]");
    }

    public void stop() throws InterruptedException {
        ANSI.print("[YELLOW]Stopping BroadcastRunner...");
        this.stop = true;
        if (!(ffmpeg == null || ffmpeg.isCancelled() && ffmpeg.isDone())) {
            ANSI.print("[YELLOW][Stop broadcasting...");
            FFmpegResult result = BroadcastRunner.stopStream();
            if (result != null) {
                ANSI.print("[GREEN]DONE!]...[RESET]");
            } else {
                ANSI.printWarn("Problem occured while stopping the BroadcastRunner.");
            }
        }
        ANSI.println("[GREEN]DONE![RESET]");
    }

    @Override
    public void run() {
        if (!this.stop && (ffmpeg == null || ffmpeg.isCancelled() || ffmpeg.isDone())) {
            this.startStream();
        }
    }

    private void startStream() {
        GetNextScheduled scheduled = new GetNextScheduled();
        try {
            String name = scheduled.future.get(20L, TimeUnit.SECONDS);
            if (name != null) {
                BroadcastRunner.getFileByName(name.toLowerCase()).ifPresent(file -> BroadcastRunner.createStream(file));
                return;
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            ANSI.printErr("Get next scheduled file failed.", e);
        }
        BroadcastRunner.createStream(BroadcastRunner.getFiles()[index]);
        index = (index + 1) % BroadcastRunner.getFiles().length;
    }

    private static void createStream(File file) {
        String path = file.getAbsolutePath();
        FFprobeResult probeResult = FFprobe.atPath().setShowFormat(true).setInput(path).setShowStreams(true).execute();
        format = probeResult.getFormat();
        String title = file.getName();
        if (title.toLowerCase().endsWith(".mp4")) {
            title = title.substring(0, title.length() - 4);
        }
        String info = format.getTag("artist") + ":" + format.getTag("date") + ":" + format.getTag("comment");
        new UpdateCurrent(title, info);
        if (Config.DISCORD_BOT_START.booleanValue() && DiscordBot.instance != null) {
            DiscordBot.instance.updateStatus(title);
        }
        ANSI.println("[BLUE]Now playing: " + format.getTag("title") + ":" + format.getTag("artist") + ":" + format.getTag("date") + ":" + format.getTag("comment") + "[RESET]");
        ANSI.prompt();
        ffmpeg = FFmpeg.atPath().addInput((Input)UrlInput.fromUrl(path).addArgument("-re")).addOutput((Output)((UrlOutput)((UrlOutput)((UrlOutput)((UrlOutput)((UrlOutput)((UrlOutput)((UrlOutput)UrlOutput.toUrl(Config.STREAM_URL + "/" + Config.STREAM_KEY).setCodec(StreamType.VIDEO, "copy")).addArguments("-b:v", "2M")).setCodec(StreamType.AUDIO, "copy")).addArguments("-strict", "-2")).addArguments("-flags", "+global_header")).addArguments("-bsf:a", "aac_adtstoasc")).addArguments("-bufsize", "2100k")).setFormat("flv")).setOutputListener(new OutputListener(){

            @Override
            public void onOutput(String message) {
                BroadcastRunner.message = message;
            }
        }).setProgressListener(new ProgressListener(){

            @Override
            public void onProgress(FFmpegProgress progress) {
                BroadcastRunner.progress = progress;
            }
        }).setOverwriteOutput(true).executeAsync();
        if (ffmpeg != null && !ffmpeg.isDone() && !ffmpeg.isCancelled()) {
            playing = file;
        }
    }

    public static boolean isStreaming() {
        return ffmpeg != null && !ffmpeg.isCancelled() && !ffmpeg.isDone();
    }

    public static void playFile(File file) {
        if (BroadcastRunner.isStreaming()) {
            BroadcastRunner.stopStream();
            BroadcastRunner.createStream(file);
        }
    }

    public static void playPosition(int idx) {
        index = idx;
        if (BroadcastRunner.isStreaming()) {
            BroadcastRunner.stopStream();
        }
    }

    public static void restart() {
        if (BroadcastRunner.isStreaming()) {
            BroadcastRunner.stopStream();
        }
        BroadcastRunner.createStream(playing);
    }

    public static void next() {
        if (BroadcastRunner.isStreaming()) {
            BroadcastRunner.stopStream();
        }
    }

    public static void previous() {
        if (BroadcastRunner.isStreaming()) {
            index = (index - 2 + BroadcastRunner.getFiles().length) % BroadcastRunner.getFiles().length;
            BroadcastRunner.stopStream();
        }
    }

    private static FFmpegResult stopStream() {
        ffmpeg.graceStop();
        try {
            return ffmpeg.get(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            ANSI.printErr("Failed to stop broadcast task.", e);
            return null;
        }
    }

    public static File[] getFiles() {
        return files;
    }

    public static Optional<File> getFileByName(String name) {
        File file = null;
        int pos = BroadcastRunner.getFilePosition(name);
        if (pos != -1) {
            file = files[pos];
        } else {
            pos = BroadcastRunner.getCustomFilePosition(name);
            if (pos != -1) {
                file = customs[pos];
            }
        }
        if (file != null && file.exists() && file.isFile() && file.canRead()) {
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public static int getFilePosition(String name) {
        if (!name.isEmpty()) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().equalsIgnoreCase(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getCustomFilePosition(String name) {
        if (!name.isEmpty()) {
            for (int i = 0; i < customs.length; ++i) {
                if (!customs[i].getName().equalsIgnoreCase(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public static List<String> getFilesAsList(String r) {
        String regex = r.contains("*") ? r.replaceAll("\\*", "(.*)") : "(.*)" + r + "(.*)";
        ArrayList<String> list = new ArrayList<String>();
        Stream.of(files, customs).flatMap(Arrays::stream).map(File::getName).filter(name -> {
            try {
                return name.toLowerCase().matches(regex);
            }
            catch (Exception e) {
                if (Config.DEBUG.booleanValue()) {
                    ANSI.printErr("getFilelistAsString method failed.", e);
                }
                return false;
            }
        }).forEach(list::add);
        return list;
    }

    public static String getFilesAsString(String r) {
        AtomicInteger count = new AtomicInteger(0);
        StringBuilder playlist = new StringBuilder();
        String regex = r.contains("*") ? r.replaceAll("\\*", "(.*)") : "(.*)" + r + "(.*)";
        Stream.of(files, customs).flatMap(Arrays::stream).map(File::getName).filter(name -> {
            try {
                return name.toLowerCase().matches(regex);
            }
            catch (Exception e) {
                if (Config.DEBUG.booleanValue()) {
                    ANSI.printErr("getFilelistAsString method failed.", e);
                }
                return false;
            }
        }).forEach(name -> {
            playlist.append(name + "\n");
            count.incrementAndGet();
        });
        playlist.append("\nThere are ").append(count).append(" matches for ").append(regex);
        return playlist.toString();
    }

    public static void shuffleFilelist() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i1 = files.length - 1; i1 > 0; --i1) {
            int index = ((Random)random).nextInt(i1 + 1);
            File a = files[index];
            BroadcastRunner.files[index] = files[i1];
            BroadcastRunner.files[i1] = a;
        }
    }

    private static File[] getFiles(File file, FileFilter filter) {
        if (file.exists()) {
            if (file.isDirectory()) {
                return file.listFiles(filter);
            }
            if (file.isFile()) {
                return new File[]{file};
            }
        }
        return new File[0];
    }

    public static void refreshFilelist() {
        File file = new File(Config.PLAYLIST_PATH);
        File custom = new File(Config.PLAYLIST_PATH_CUSTOM);
        FileFilter filter = pathName -> pathName.getAbsolutePath().toLowerCase().endsWith(".mp4");
        files = BroadcastRunner.getFiles(file, filter);
        customs = BroadcastRunner.getFiles(custom, filter);
    }

    static {
        files = new File[0];
        customs = new File[0];
    }
}

