/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.mysql;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.mysql.DatabaseConnection;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class UpdateCurrent
implements Callable<Boolean> {
    String sql = "INSERT INTO `current` (`title`, `info`) VALUES(?, ?);";
    String title;
    String info;
    public Future<Boolean> future;

    public UpdateCurrent(String title, String info) {
        this.title = title;
        this.info = info;
        this.future = Helper.EXECUTOR.submit(this);
    }

    @Override
    public Boolean call() {
        try (Connection connection = DatabaseConnection.getNewConnection();){
            try (PreparedStatement statement = connection.prepareStatement(this.sql, 1004, 1007);){
                if (Config.DEBUG.booleanValue()) {
                    ANSI.println("[BEGIN MYSQL CURRENT UPDATE]");
                }
                statement.addBatch("START TRANSACTION;");
                statement.addBatch("DELETE FROM `current`;");
                statement.setString(1, this.title);
                statement.setString(2, this.info);
                statement.addBatch();
                statement.addBatch("COMMIT;");
                statement.executeBatch();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
        }
        catch (SQLException e) {
            ANSI.printErr("Update now playing entry failed.", e);
            return false;
        }
        if (Config.DEBUG.booleanValue()) {
            ANSI.println("\n[SUCSESSFUL MYSQL CURRENT UPDATE]");
        }
        return true;
    }
}

