/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.command.ApplicationCommandPermission;
import discord4j.discordjson.json.ApplicationCommandPermissionsData;
import discord4j.discordjson.json.GuildApplicationCommandPermissionsData;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ApplicationCommandGuildPermissions
implements DiscordObject {
    public static final int MAX_PERMISSION_ENTRIES = 100;
    private final GatewayDiscordClient gateway;
    private final GuildApplicationCommandPermissionsData data;

    public ApplicationCommandGuildPermissions(GatewayDiscordClient gateway, GuildApplicationCommandPermissionsData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.data.guildId());
    }

    public Snowflake getApplicationId() {
        return Snowflake.of(this.data.applicationId());
    }

    public List<ApplicationCommandPermission> getPermissions() {
        return this.data.permissions().stream().map(data -> new ApplicationCommandPermission(this.gateway, this.getGuildId(), (ApplicationCommandPermissionsData)data)).collect(Collectors.toList());
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public String toString() {
        return "ApplicationCommandGuildPermissions{data=" + this.data + '}';
    }
}

