/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.shard;

import discord4j.core.shard.DefaultShardingStrategy;
import discord4j.core.shard.GatewayClientGroupManager;
import discord4j.core.shard.ShardingGatewayClientGroup;
import discord4j.core.shard.SingleGatewayClientGroup;
import discord4j.discordjson.json.GatewayData;
import discord4j.discordjson.json.SessionStartLimitData;
import discord4j.discordjson.possible.Possible;
import discord4j.gateway.ShardInfo;
import discord4j.rest.RestClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ShardingStrategy {
    public Mono<Integer> getShardCount(RestClient var1);

    default public Flux<ShardInfo> getShards(int shardCount) {
        return Flux.range(0, shardCount).map(index -> ShardInfo.create(index, shardCount));
    }

    public GatewayClientGroupManager getGroupManager(int var1);

    @Deprecated
    public int getMaxConcurrency();

    default public Mono<Integer> getMaxConcurrency(RestClient restClient) {
        return Mono.just(this.getMaxConcurrency());
    }

    public static ShardingStrategy recommended() {
        return new ShardingStrategy(){

            @Override
            public Mono<Integer> getShardCount(RestClient restClient) {
                return restClient.getGatewayService().getGatewayBot().map(GatewayData::shards).map(Possible::get);
            }

            @Override
            public GatewayClientGroupManager getGroupManager(int shardCount) {
                return new ShardingGatewayClientGroup(shardCount);
            }

            @Override
            public int getMaxConcurrency() {
                return 1;
            }

            @Override
            public Mono<Integer> getMaxConcurrency(RestClient restClient) {
                return restClient.getGatewayService().getGatewayBot().map(GatewayData::sessionStartLimit).map(sessionStartLimit -> sessionStartLimit.toOptional().map(SessionStartLimitData::maxConcurrency).flatMap(Possible::toOptional).orElseGet(this::getMaxConcurrency));
            }
        };
    }

    public static ShardingStrategy fixed(final int count) {
        return new ShardingStrategy(){

            @Override
            public Mono<Integer> getShardCount(RestClient restClient) {
                return Mono.just(count);
            }

            @Override
            public GatewayClientGroupManager getGroupManager(int shardCount) {
                return new ShardingGatewayClientGroup(shardCount);
            }

            @Override
            public int getMaxConcurrency() {
                return 1;
            }
        };
    }

    public static ShardingStrategy single() {
        return new ShardingStrategy(){

            @Override
            public Mono<Integer> getShardCount(RestClient restClient) {
                return Mono.just(1);
            }

            @Override
            public GatewayClientGroupManager getGroupManager(int shardCount) {
                return new SingleGatewayClientGroup();
            }

            @Override
            public int getMaxConcurrency() {
                return 1;
            }
        };
    }

    public static DefaultShardingStrategy.Builder builder() {
        return new DefaultShardingStrategy.Builder();
    }
}

