/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.format;

import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkDecoder;
import com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkEncoder;
import com.sedmelluq.discord.lavaplayer.format.transcoder.OpusChunkDecoder;
import com.sedmelluq.discord.lavaplayer.format.transcoder.OpusChunkEncoder;
import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;

public class OpusAudioDataFormat
extends AudioDataFormat {
    public static final String CODEC_NAME = "OPUS";
    private static final byte[] SILENT_OPUS_FRAME = new byte[]{-4, -1, -2};
    private final int maximumChunkSize;
    private final int expectedChunkSize;

    public OpusAudioDataFormat(int channelCount, int sampleRate, int chunkSampleCount) {
        super(channelCount, sampleRate, chunkSampleCount);
        this.maximumChunkSize = 32 + 1536 * chunkSampleCount / 960;
        this.expectedChunkSize = 32 + 512 * chunkSampleCount / 960;
    }

    @Override
    public String codecName() {
        return CODEC_NAME;
    }

    @Override
    public byte[] silenceBytes() {
        return SILENT_OPUS_FRAME;
    }

    @Override
    public int expectedChunkSize() {
        return this.expectedChunkSize;
    }

    @Override
    public int maximumChunkSize() {
        return this.maximumChunkSize;
    }

    @Override
    public AudioChunkDecoder createDecoder() {
        return new OpusChunkDecoder(this);
    }

    @Override
    public AudioChunkEncoder createEncoder(AudioConfiguration configuration) {
        return new OpusChunkEncoder(configuration, this);
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

