/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver;

import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.ffmpeg.FFProbePacket;
import com.gmail.berndivader.streamserver.ffmpeg.InfoPacket;
import com.gmail.berndivader.streamserver.term.ANSI;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public final class Helper {
    public static final ExecutorService EXECUTOR;
    public static final ScheduledExecutorService SCHEDULED_EXECUTOR;
    public static final Gson LGSON;
    public static final Gson GSON;
    static final Pattern EXTRACT_URL;

    private Helper() {
    }

    /*
     * Exception decompiling
     */
    private static String startAndWaitForProcess(ProcessBuilder builder, long timeout) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static FFProbePacket createProbePacket(File file) {
        FFProbePacket packet = null;
        if (file.exists()) {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.directory(new File("./"));
            builder.command("ffprobe", "-v", "quiet", "-print_format", "json", "-show_format", file.getAbsolutePath());
            try {
                JsonObject o;
                String out = Helper.startAndWaitForProcess(builder, 10L);
                if (!out.isEmpty() && (o = JsonParser.parseString(out.toString()).getAsJsonObject()).has("format")) {
                    packet = LGSON.fromJson(o.get("format"), FFProbePacket.class);
                }
            }
            catch (Exception e) {
                ANSI.printErr("getProbePacket method failed.", e);
            }
        }
        return packet == null ? new FFProbePacket() : packet;
    }

    public static InfoPacket createInfoPacket(String url) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(new File("./"));
        builder.command("yt-dlp", "--quiet", "--no-warnings", "--dump-json", "--no-playlist");
        if (Config.YOUTUBE_USE_COOKIES.booleanValue() && Config.YOUTUBE_COOKIES.exists()) {
            builder.command().add("--cookies");
            builder.command().add(Config.YOUTUBE_COOKIES.getAbsolutePath());
        }
        builder.command().add(url);
        InfoPacket info = null;
        try {
            String out = Helper.startAndWaitForProcess(builder, 20L);
            if (!out.isEmpty()) {
                int index = out.indexOf(123);
                if (index != -1) {
                    out = out.substring(index);
                }
                info = LGSON.fromJson(out, InfoPacket.class);
            }
        }
        catch (Exception e) {
            ANSI.printErr("getinfoPacket method failed.", e);
        }
        if (info == null) {
            info = new InfoPacket();
            info.webpage_url = url;
        }
        return info;
    }

    public static Map.Entry<ProcessBuilder, InfoPacket> createDownloadBuilder(File defaultDirectory, String args) {
        String[] commands;
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        Helper.getOrCreateMediaDir(Config.DL_MEDIA_PATH).ifPresentOrElse(dir -> builder.directory((File)dir), () -> builder.directory(new File("./")));
        boolean downloadable = false;
        boolean temp = false;
        builder.command("yt-dlp", "--progress-delta", "2", "--restrict-filenames", "--embed-metadata", "--embed-thumbnail", "--no-playlist", "--output", "%(title).64s.%(ext)s");
        if (Config.YOUTUBE_USE_COOKIES.booleanValue() && Config.YOUTUBE_COOKIES.exists()) {
            builder.command().add("--cookies");
            builder.command().add(Config.YOUTUBE_COOKIES.getAbsolutePath());
        }
        String url = "";
        Matcher matcher = EXTRACT_URL.matcher(args);
        if (matcher.find()) {
            url = matcher.group();
            args = matcher.replaceAll("");
        }
        block14: for (String command : commands = args.split("--")) {
            String[] parse;
            if (command.isEmpty() || (parse = command.trim().split(" ", 2)).length <= 0) continue;
            switch (parse[0]) {
                case "temp": {
                    Helper.getOrCreateMediaDir(Config.DL_TEMP_PATH).ifPresent(dir -> builder.directory((File)dir));
                    temp = true;
                    downloadable = true;
                    continue block14;
                }
                case "music": {
                    builder.command().addAll(Arrays.asList("--ignore-errors", "--extract-audio", "--format", "bestaudio", "--audio-format", "mp3", "--audio-quality", "160K", "--output", "%(title).64s.%(ext)s"));
                    Helper.getOrCreateMediaDir(Config.DL_MUSIC_PATH).ifPresent(dir -> builder.directory((File)dir));
                    continue block14;
                }
                case "link": {
                    downloadable = true;
                    temp = false;
                    continue block14;
                }
                case "url": {
                    if (parse.length != 2 || parse[1].isBlank()) continue block14;
                    url = parse[1];
                    continue block14;
                }
                case "cookies": {
                    if (Config.YOUTUBE_USE_COOKIES.booleanValue() || !Config.YOUTUBE_COOKIES.exists()) continue block14;
                    builder.command().add("--cookies");
                    builder.command().add(Config.YOUTUBE_COOKIES.getAbsolutePath());
                    continue block14;
                }
                default: {
                    if (!parse[0].isEmpty()) {
                        builder.command().add("--" + parse[0]);
                    }
                    if (parse.length != 2 || parse[1].isEmpty()) continue block14;
                    builder.command().add(parse[1]);
                }
            }
        }
        InfoPacket infoPacket = Helper.createInfoPacket(url);
        if (!url.isEmpty()) {
            builder.command().add(url);
        }
        infoPacket.downloadable = downloadable;
        infoPacket.temp = temp;
        return Map.entry(builder, infoPacket);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] extractImageFromMedia(File media, File dest) {
        ProcessBuilder builder = new ProcessBuilder("ffmpeg", "-v", "quiet", "-i", media.getAbsolutePath(), "-map", "0:v:0", "-c:v", "mjpeg", "-f", "mjpeg", "-");
        Process process = null;
        try {
            process = builder.start();
            try (InputStream in = process.getInputStream();
                 ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int h2;
                int w;
                BufferedImage bimage = ImageIO.read(in);
                if (bimage.getWidth() > bimage.getHeight()) {
                    ratio = (double)bimage.getHeight() / (double)bimage.getWidth();
                    w = 640;
                    h2 = (int)((double)w * ratio);
                } else {
                    ratio = (double)bimage.getWidth() / (double)bimage.getHeight();
                    h2 = 460;
                    w = (int)((double)h2 * ratio);
                }
                int type = bimage.getType();
                Image temp = bimage.getScaledInstance(w, h2, 4);
                bimage = new BufferedImage(w, h2, type);
                Graphics2D g2d = bimage.createGraphics();
                g2d.drawImage(temp, 0, 0, null);
                g2d.dispose();
                if (dest == null) {
                    if (ImageIO.write((RenderedImage)bimage, "jpg", out)) {
                        byte[] byArray = out.toByteArray();
                        return byArray;
                    }
                } else {
                    ImageIO.write((RenderedImage)bimage, "jpg", dest);
                }
            }
        }
        catch (Exception e) {
            ANSI.printErr(e.getMessage(), e);
        }
        if (process == null) return new byte[0];
        if (!process.isAlive()) return new byte[0];
        process.destroy();
        return new byte[0];
    }

    public static Optional<File> getOrCreateMediaDir(String name) {
        File dir = new File(name);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (dir.isDirectory()) {
            return Optional.of(dir);
        }
        if (Config.DEBUG.booleanValue()) {
            ANSI.printWarn("Failed to create directory: " + name);
        }
        return Optional.empty();
    }

    public static String stringFloatToTime(String time) {
        float duration = 0.0f;
        try {
            duration = Float.parseFloat(time);
        }
        catch (Exception e) {
            ANSI.printErr(e.getMessage(), e);
        }
        int h2 = (int)(duration / 3600.0f);
        int m3 = (int)(duration % 3600.0f / 60.0f);
        int s2 = (int)(duration % 60.0f);
        return String.format("%02d:%02d:%02d", h2, m3, s2);
    }

    public static void close() {
        ANSI.print("[WHITE]Shutdown task executor...");
        EXECUTOR.shutdown();
        ANSI.println("[GREEN]DONE!");
        ANSI.print("[WHITE]Shutdown scheduled task executor...");
        SCHEDULED_EXECUTOR.shutdown();
        ANSI.println("[GREEN]DONE![/GREEN]");
    }

    static {
        EXTRACT_URL = Pattern.compile("\\b(https?)://[-A-Z0-9+&@#/%?=~_|!:,.;]*[-A-Z0-9+&@#/%=~_|]", 2);
        EXECUTOR = Executors.newCachedThreadPool();
        SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(1);
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        LGSON = new GsonBuilder().setPrettyPrinting().setFieldNamingStrategy(s2 -> s2.getName().toLowerCase()).disableHtmlEscaping().create();
    }
}

