/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.spec.CategoryCreateSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="CategoryCreateSpecGenerator", generator="Immutables")
public final class CategoryCreateSpec
implements CategoryCreateSpecGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final Integer position_value;
    private final boolean position_absent;
    private final List<PermissionOverwrite> permissionOverwrites_value;
    private final boolean permissionOverwrites_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private CategoryCreateSpec(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.reason = null;
        Possible position$impl = Possible.absent();
        Possible permissionOverwrites$impl = Possible.absent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.initShim = null;
    }

    private CategoryCreateSpec(@Nullable String reason, String name, Possible<Integer> position, Possible<List<PermissionOverwrite>> permissionOverwrites) {
        this.reason = reason;
        this.name = name;
        Possible<Integer> position$impl = position;
        Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<Integer> position() {
        return this.position_absent ? Possible.absent() : Possible.of(this.position_value);
    }

    @Override
    public Possible<List<PermissionOverwrite>> permissionOverwrites() {
        return this.permissionOverwrites_absent ? Possible.absent() : Possible.of(this.permissionOverwrites_value);
    }

    public final CategoryCreateSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new CategoryCreateSpec(value, this.name, this.position(), this.permissionOverwrites());
    }

    public final CategoryCreateSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new CategoryCreateSpec(this.reason, newValue, this.position(), this.permissionOverwrites());
    }

    public CategoryCreateSpec withPosition(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new CategoryCreateSpec(this.reason, this.name, newValue, this.permissionOverwrites());
    }

    public CategoryCreateSpec withPosition(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new CategoryCreateSpec(this.reason, this.name, newValue, this.permissionOverwrites());
    }

    public CategoryCreateSpec withPermissionOverwrites(Possible<? extends List<? extends PermissionOverwrite>> possible) {
        Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
        return new CategoryCreateSpec(this.reason, this.name, this.position(), newValue);
    }

    public CategoryCreateSpec withPermissionOverwrites(Iterable<? extends PermissionOverwrite> elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new CategoryCreateSpec(this.reason, this.name, this.position(), newValue);
    }

    @SafeVarargs
    public final CategoryCreateSpec withPermissionOverwrites(PermissionOverwrite ... elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
        return new CategoryCreateSpec(this.reason, this.name, this.position(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CategoryCreateSpec && this.equalTo(0, (CategoryCreateSpec)another);
    }

    private boolean equalTo(int synthetic, CategoryCreateSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.position().equals(another.position()) && Objects.equals(this.permissionOverwrites_value, another.permissionOverwrites_value);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.position().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.permissionOverwrites_value);
        return h2;
    }

    public String toString() {
        return "CategoryCreateSpec{reason=" + this.reason + ", name=" + this.name + ", position=" + this.position().toString() + ", permissionOverwrites=" + Objects.toString(this.permissionOverwrites_value) + "}";
    }

    public static CategoryCreateSpec of(String name) {
        return new CategoryCreateSpec(name);
    }

    static CategoryCreateSpec copyOf(CategoryCreateSpecGenerator instance) {
        if (instance instanceof CategoryCreateSpec) {
            return (CategoryCreateSpec)instance;
        }
        return CategoryCreateSpec.builder().from(instance).build();
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public boolean isPermissionOverwritesPresent() {
        return !this.permissionOverwrites_absent;
    }

    public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
        return !this.permissionOverwrites_absent ? this.permissionOverwrites_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CategoryCreateSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build CategoryCreateSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="CategoryCreateSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Possible<Integer> position_possible = Possible.absent();
        private List<PermissionOverwrite> permissionOverwrites_list = null;
        private String reason;
        private String name;

        private Builder() {
        }

        public final Builder from(CategoryCreateSpec instance) {
            return this.from((CategoryCreateSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(CategoryCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.position(instance.position());
            this.permissionOverwrites(instance.permissionOverwrites());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder position(Possible<Integer> value) {
            this.position_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder position(Integer value) {
            this.position_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPermissionOverwrite(PermissionOverwrite element) {
            this.permissionOverwrites_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllPermissionOverwrites(Collection<? extends PermissionOverwrite> elements) {
            this.permissionOverwrites_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(Possible<? extends Collection<? extends PermissionOverwrite>> elements) {
            this.permissionOverwrites_list = null;
            elements.toOptional().ifPresent(e -> this.permissionOverwrites_getOrCreate().addAll((Collection<PermissionOverwrite>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(Iterable<? extends PermissionOverwrite> elements) {
            this.permissionOverwrites_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder permissionOverwrites(PermissionOverwrite ... elements) {
            this.permissionOverwrites_list = Arrays.asList(elements);
            return this;
        }

        public CategoryCreateSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CategoryCreateSpec(this.reason, this.name, this.position_build(), this.permissionOverwrites_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CategoryCreateSpec, some of required attributes are not set " + attributes;
        }

        private Possible<Integer> position_build() {
            return this.position_possible;
        }

        private Possible<List<PermissionOverwrite>> permissionOverwrites_build() {
            return this.permissionOverwrites_list == null ? Possible.absent() : Possible.of(this.permissionOverwrites_list);
        }

        private List<PermissionOverwrite> permissionOverwrites_getOrCreate() {
            if (this.permissionOverwrites_list == null) {
                this.permissionOverwrites_list = new ArrayList<PermissionOverwrite>();
            }
            return this.permissionOverwrites_list;
        }
    }
}

