/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.store.action.read.ReadActions;
import discord4j.common.util.Snowflake;
import discord4j.core.object.Region;
import discord4j.core.object.VoiceState;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.channel.CategorizableChannel;
import discord4j.core.spec.AudioChannelJoinMono;
import discord4j.core.spec.AudioChannelJoinSpec;
import discord4j.core.spec.legacy.LegacyVoiceChannelJoinSpec;
import discord4j.discordjson.json.VoiceStateData;
import discord4j.discordjson.json.gateway.VoiceStateUpdate;
import discord4j.discordjson.possible.Possible;
import discord4j.gateway.GatewayClientGroup;
import discord4j.gateway.json.ShardGatewayPayload;
import discord4j.voice.VoiceConnection;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface AudioChannel
extends CategorizableChannel {
    default public int getBitrate() {
        return this.getData().bitrate().toOptional().orElseThrow(IllegalStateException::new);
    }

    default public Region.Id getRtcRegion() {
        return Possible.flatOpt(this.getData().rtcRegion()).map(Region.Id::of).orElse(Region.Id.AUTOMATIC);
    }

    default public Flux<VoiceState> getVoiceStates() {
        return Flux.from(this.getClient().getGatewayResources().getStore().execute(ReadActions.getVoiceStatesInChannel(this.getGuildId().asLong(), this.getId().asLong()))).map(data -> new VoiceState(this.getClient(), (VoiceStateData)data));
    }

    @Deprecated
    default public Mono<VoiceConnection> join(Consumer<? super LegacyVoiceChannelJoinSpec> spec) {
        return Mono.defer(() -> {
            LegacyVoiceChannelJoinSpec mutatedSpec = new LegacyVoiceChannelJoinSpec(this.getClient(), this);
            spec.accept(mutatedSpec);
            return mutatedSpec.asRequest();
        });
    }

    default public AudioChannelJoinMono join() {
        return AudioChannelJoinMono.of(this);
    }

    default public Mono<VoiceConnection> join(AudioChannelJoinSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> (Mono)spec.asRequest().apply(this));
    }

    default public Mono<Void> sendConnectVoiceState(boolean selfMute, boolean selfDeaf) {
        GatewayClientGroup clientGroup = this.getClient().getGatewayClientGroup();
        int shardId = clientGroup.computeShardIndex(this.getGuildId());
        return clientGroup.unicast(ShardGatewayPayload.voiceStateUpdate(VoiceStateUpdate.builder().guildId(this.getGuildId().asString()).channelId(this.getId().asString()).selfMute(selfMute).selfDeaf(selfDeaf).build(), shardId));
    }

    default public Mono<Void> sendDisconnectVoiceState() {
        GatewayClientGroup clientGroup = this.getClient().getGatewayClientGroup();
        int shardId = clientGroup.computeShardIndex(this.getGuildId());
        return clientGroup.unicast(ShardGatewayPayload.voiceStateUpdate(VoiceStateUpdate.builder().guildId(this.getGuildId().asString()).selfMute(false).selfDeaf(false).build(), shardId));
    }

    default public Mono<Boolean> isMemberConnected(Snowflake memberId) {
        return this.getVoiceStates().map(VoiceState::getUserId).any(memberId::equals);
    }

    default public Mono<VoiceConnection> getVoiceConnection() {
        return this.getGuild().flatMap(Guild::getVoiceConnection).filterWhen(voiceConnection -> voiceConnection.getChannelId().map(channelId -> channelId.equals(this.getId())));
    }
}

