/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.channel.VoiceChannel;
import discord4j.core.spec.VoiceChannelEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="VoiceChannelEditSpecGenerator", generator="Immutables")
public final class VoiceChannelEditSpec
implements VoiceChannelEditSpecGenerator {
    @Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final Integer bitrate_value;
    private final boolean bitrate_absent;
    private final Integer userLimit_value;
    private final boolean userLimit_absent;
    private final Integer position_value;
    private final boolean position_absent;
    private final Integer rateLimitPerUser_value;
    private final boolean rateLimitPerUser_absent;
    private final List<PermissionOverwrite> permissionOverwrites_value;
    private final boolean permissionOverwrites_absent;
    private final Snowflake parentId_value;
    private final boolean parentId_absent;
    private final String rtcRegion_value;
    private final boolean rtcRegion_absent;
    private final VoiceChannel.Mode videoQualityMode_value;
    private final boolean videoQualityMode_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final VoiceChannelEditSpec INSTANCE = VoiceChannelEditSpec.validate(new VoiceChannelEditSpec());

    private VoiceChannelEditSpec() {
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible bitrate$impl = Possible.absent();
        Possible userLimit$impl = Possible.absent();
        Possible position$impl = Possible.absent();
        Possible rateLimitPerUser$impl = Possible.absent();
        Possible permissionOverwrites$impl = Possible.absent();
        Possible parentId$impl = Possible.absent();
        Possible rtcRegion$impl = Possible.absent();
        Possible videoQualityMode$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.bitrate_value = bitrate$impl.toOptional().orElse(null);
        this.bitrate_absent = bitrate$impl.isAbsent();
        this.userLimit_value = userLimit$impl.toOptional().orElse(null);
        this.userLimit_absent = userLimit$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.rtcRegion_value = Possible.flatOpt(rtcRegion$impl).orElse(null);
        this.rtcRegion_absent = rtcRegion$impl.isAbsent();
        this.videoQualityMode_value = Possible.flatOpt(videoQualityMode$impl).orElse(null);
        this.videoQualityMode_absent = videoQualityMode$impl.isAbsent();
        this.initShim = null;
    }

    private VoiceChannelEditSpec(@Nullable String reason, Possible<String> name, Possible<Integer> bitrate, Possible<Integer> userLimit, Possible<Integer> position, Possible<Integer> rateLimitPerUser, Possible<List<PermissionOverwrite>> permissionOverwrites, Possible<Optional<Snowflake>> parentId, Possible<Optional<String>> rtcRegion, Possible<Optional<VoiceChannel.Mode>> videoQualityMode) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<Integer> bitrate$impl = bitrate;
        Possible<Integer> userLimit$impl = userLimit;
        Possible<Integer> position$impl = position;
        Possible<Integer> rateLimitPerUser$impl = rateLimitPerUser;
        Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
        Possible parentId$impl = parentId;
        Possible rtcRegion$impl = rtcRegion;
        Possible videoQualityMode$impl = videoQualityMode;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.bitrate_value = bitrate$impl.toOptional().orElse(null);
        this.bitrate_absent = bitrate$impl.isAbsent();
        this.userLimit_value = userLimit$impl.toOptional().orElse(null);
        this.userLimit_absent = userLimit$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.rtcRegion_value = Possible.flatOpt(rtcRegion$impl).orElse(null);
        this.rtcRegion_absent = rtcRegion$impl.isAbsent();
        this.videoQualityMode_value = Possible.flatOpt(videoQualityMode$impl).orElse(null);
        this.videoQualityMode_absent = videoQualityMode$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of(this.name_value);
    }

    @Override
    public Possible<Integer> bitrate() {
        return this.bitrate_absent ? Possible.absent() : Possible.of(this.bitrate_value);
    }

    @Override
    public Possible<Integer> userLimit() {
        return this.userLimit_absent ? Possible.absent() : Possible.of(this.userLimit_value);
    }

    @Override
    public Possible<Integer> position() {
        return this.position_absent ? Possible.absent() : Possible.of(this.position_value);
    }

    @Override
    public Possible<Integer> rateLimitPerUser() {
        return this.rateLimitPerUser_absent ? Possible.absent() : Possible.of(this.rateLimitPerUser_value);
    }

    @Override
    public Possible<List<PermissionOverwrite>> permissionOverwrites() {
        return this.permissionOverwrites_absent ? Possible.absent() : Possible.of(this.permissionOverwrites_value);
    }

    @Override
    public Possible<Optional<Snowflake>> parentId() {
        return this.parentId_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.parentId_value));
    }

    @Override
    public Possible<Optional<String>> rtcRegion() {
        return this.rtcRegion_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.rtcRegion_value));
    }

    @Override
    public Possible<Optional<VoiceChannel.Mode>> videoQualityMode() {
        return this.videoQualityMode_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.videoQualityMode_value));
    }

    public final VoiceChannelEditSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(value, this.name(), this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, newValue, this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withName(String value) {
        Possible<String> newValue = Possible.of(value);
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, newValue, this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withBitrate(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), newValue, this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withBitrate(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), newValue, this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withUserLimit(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), newValue, this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withUserLimit(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), newValue, this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withPosition(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), newValue, this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withPosition(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), newValue, this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withRateLimitPerUser(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), this.position(), newValue, this.permissionOverwrites(), this.parentId(), this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withRateLimitPerUser(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), this.position(), newValue, this.permissionOverwrites(), this.parentId(), this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withPermissionOverwrites(Possible<? extends List<? extends PermissionOverwrite>> possible) {
        Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), newValue, this.parentId(), this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withPermissionOverwrites(Iterable<? extends PermissionOverwrite> elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), newValue, this.parentId(), this.rtcRegion(), this.videoQualityMode()));
    }

    @SafeVarargs
    public final VoiceChannelEditSpec withPermissionOverwrites(PermissionOverwrite ... elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), newValue, this.parentId(), this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withParentId(Possible<Optional<Snowflake>> value) {
        Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), newValue, this.rtcRegion(), this.videoQualityMode()));
    }

    @Deprecated
    public VoiceChannelEditSpec withParentId(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), newValue, this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withParentIdOrNull(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), newValue, this.rtcRegion(), this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withRtcRegion(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), newValue, this.videoQualityMode()));
    }

    @Deprecated
    public VoiceChannelEditSpec withRtcRegion(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), newValue, this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withRtcRegionOrNull(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), newValue, this.videoQualityMode()));
    }

    public VoiceChannelEditSpec withVideoQualityMode(Possible<Optional<VoiceChannel.Mode>> value) {
        Possible<Optional<VoiceChannel.Mode>> newValue = Objects.requireNonNull(value);
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.rtcRegion(), newValue));
    }

    @Deprecated
    public VoiceChannelEditSpec withVideoQualityMode(@Nullable VoiceChannel.Mode value) {
        Possible<Optional<VoiceChannel.Mode>> newValue = Possible.of(Optional.ofNullable(value));
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.rtcRegion(), newValue));
    }

    public VoiceChannelEditSpec withVideoQualityModeOrNull(@Nullable VoiceChannel.Mode value) {
        Possible<Optional<VoiceChannel.Mode>> newValue = Possible.of(Optional.ofNullable(value));
        return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name(), this.bitrate(), this.userLimit(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId(), this.rtcRegion(), newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof VoiceChannelEditSpec && this.equalTo(0, (VoiceChannelEditSpec)another);
    }

    private boolean equalTo(int synthetic, VoiceChannelEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.bitrate().equals(another.bitrate()) && this.userLimit().equals(another.userLimit()) && this.position().equals(another.position()) && this.rateLimitPerUser().equals(another.rateLimitPerUser()) && Objects.equals(this.permissionOverwrites_value, another.permissionOverwrites_value) && this.parentId().equals(another.parentId()) && this.rtcRegion().equals(another.rtcRegion()) && this.videoQualityMode().equals(another.videoQualityMode());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name().hashCode();
        h2 += (h2 << 5) + this.bitrate().hashCode();
        h2 += (h2 << 5) + this.userLimit().hashCode();
        h2 += (h2 << 5) + this.position().hashCode();
        h2 += (h2 << 5) + this.rateLimitPerUser().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.permissionOverwrites_value);
        h2 += (h2 << 5) + this.parentId().hashCode();
        h2 += (h2 << 5) + this.rtcRegion().hashCode();
        h2 += (h2 << 5) + this.videoQualityMode().hashCode();
        return h2;
    }

    public String toString() {
        return "VoiceChannelEditSpec{reason=" + this.reason + ", name=" + this.name().toString() + ", bitrate=" + this.bitrate().toString() + ", userLimit=" + this.userLimit().toString() + ", position=" + this.position().toString() + ", rateLimitPerUser=" + this.rateLimitPerUser().toString() + ", permissionOverwrites=" + Objects.toString(this.permissionOverwrites_value) + ", parentId=" + this.parentId().toString() + ", rtcRegion=" + this.rtcRegion().toString() + ", videoQualityMode=" + this.videoQualityMode().toString() + "}";
    }

    public static VoiceChannelEditSpec create() {
        return INSTANCE;
    }

    private static VoiceChannelEditSpec validate(VoiceChannelEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static VoiceChannelEditSpec copyOf(VoiceChannelEditSpecGenerator instance) {
        if (instance instanceof VoiceChannelEditSpec) {
            return (VoiceChannelEditSpec)instance;
        }
        return VoiceChannelEditSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isBitratePresent() {
        return !this.bitrate_absent;
    }

    public Integer bitrateOrElse(Integer defaultValue) {
        return !this.bitrate_absent ? this.bitrate_value : defaultValue;
    }

    public boolean isUserLimitPresent() {
        return !this.userLimit_absent;
    }

    public Integer userLimitOrElse(Integer defaultValue) {
        return !this.userLimit_absent ? this.userLimit_value : defaultValue;
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public boolean isRateLimitPerUserPresent() {
        return !this.rateLimitPerUser_absent;
    }

    public Integer rateLimitPerUserOrElse(Integer defaultValue) {
        return !this.rateLimitPerUser_absent ? this.rateLimitPerUser_value : defaultValue;
    }

    public boolean isPermissionOverwritesPresent() {
        return !this.permissionOverwrites_absent;
    }

    public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
        return !this.permissionOverwrites_absent ? this.permissionOverwrites_value : defaultValue;
    }

    public boolean isParentIdPresent() {
        return !this.parentId_absent;
    }

    public Snowflake parentIdOrElse(Snowflake defaultValue) {
        return !this.parentId_absent ? this.parentId_value : defaultValue;
    }

    public boolean isRtcRegionPresent() {
        return !this.rtcRegion_absent;
    }

    public String rtcRegionOrElse(String defaultValue) {
        return !this.rtcRegion_absent ? this.rtcRegion_value : defaultValue;
    }

    public boolean isVideoQualityModePresent() {
        return !this.videoQualityMode_absent;
    }

    public VoiceChannel.Mode videoQualityModeOrElse(VoiceChannel.Mode defaultValue) {
        return !this.videoQualityMode_absent ? this.videoQualityMode_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="VoiceChannelEditSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build VoiceChannelEditSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="VoiceChannelEditSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<Integer> bitrate_possible = Possible.absent();
        private Possible<Integer> userLimit_possible = Possible.absent();
        private Possible<Integer> position_possible = Possible.absent();
        private Possible<Integer> rateLimitPerUser_possible = Possible.absent();
        private List<PermissionOverwrite> permissionOverwrites_list = null;
        private Possible<Optional<Snowflake>> parentId_possible = Possible.absent();
        private Possible<Optional<String>> rtcRegion_possible = Possible.absent();
        private Possible<Optional<VoiceChannel.Mode>> videoQualityMode_possible = Possible.absent();
        private String reason;

        private Builder() {
        }

        public final Builder from(VoiceChannelEditSpec instance) {
            return this.from((VoiceChannelEditSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(VoiceChannelEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.bitrate(instance.bitrate());
            this.userLimit(instance.userLimit());
            this.position(instance.position());
            this.rateLimitPerUser(instance.rateLimitPerUser());
            this.permissionOverwrites(instance.permissionOverwrites());
            this.parentId(instance.parentId());
            this.rtcRegion(instance.rtcRegion());
            this.videoQualityMode(instance.videoQualityMode());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(String value) {
            this.name_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder bitrate(Possible<Integer> value) {
            this.bitrate_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder bitrate(Integer value) {
            this.bitrate_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder userLimit(Possible<Integer> value) {
            this.userLimit_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder userLimit(Integer value) {
            this.userLimit_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder position(Possible<Integer> value) {
            this.position_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder position(Integer value) {
            this.position_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rateLimitPerUser(Possible<Integer> value) {
            this.rateLimitPerUser_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rateLimitPerUser(Integer value) {
            this.rateLimitPerUser_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPermissionOverwrite(PermissionOverwrite element) {
            this.permissionOverwrites_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllPermissionOverwrites(Collection<? extends PermissionOverwrite> elements) {
            this.permissionOverwrites_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(Possible<? extends Collection<? extends PermissionOverwrite>> elements) {
            this.permissionOverwrites_list = null;
            elements.toOptional().ifPresent(e -> this.permissionOverwrites_getOrCreate().addAll((Collection<PermissionOverwrite>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(Iterable<? extends PermissionOverwrite> elements) {
            this.permissionOverwrites_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder permissionOverwrites(PermissionOverwrite ... elements) {
            this.permissionOverwrites_list = Arrays.asList(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder parentId(Possible<Optional<Snowflake>> value) {
            this.parentId_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder parentId(@Nullable Snowflake value) {
            this.parentId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder parentIdOrNull(@Nullable Snowflake value) {
            this.parentId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rtcRegion(Possible<Optional<String>> value) {
            this.rtcRegion_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder rtcRegion(@Nullable String value) {
            this.rtcRegion_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rtcRegionOrNull(@Nullable String value) {
            this.rtcRegion_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder videoQualityMode(Possible<Optional<VoiceChannel.Mode>> value) {
            this.videoQualityMode_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder videoQualityMode(@Nullable VoiceChannel.Mode value) {
            this.videoQualityMode_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder videoQualityModeOrNull(@Nullable VoiceChannel.Mode value) {
            this.videoQualityMode_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public VoiceChannelEditSpec build() {
            return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(this.reason, this.name_build(), this.bitrate_build(), this.userLimit_build(), this.position_build(), this.rateLimitPerUser_build(), this.permissionOverwrites_build(), this.parentId_build(), this.rtcRegion_build(), this.videoQualityMode_build()));
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<Integer> bitrate_build() {
            return this.bitrate_possible;
        }

        private Possible<Integer> userLimit_build() {
            return this.userLimit_possible;
        }

        private Possible<Integer> position_build() {
            return this.position_possible;
        }

        private Possible<Integer> rateLimitPerUser_build() {
            return this.rateLimitPerUser_possible;
        }

        private Possible<List<PermissionOverwrite>> permissionOverwrites_build() {
            return this.permissionOverwrites_list == null ? Possible.absent() : Possible.of(this.permissionOverwrites_list);
        }

        private List<PermissionOverwrite> permissionOverwrites_getOrCreate() {
            if (this.permissionOverwrites_list == null) {
                this.permissionOverwrites_list = new ArrayList<PermissionOverwrite>();
            }
            return this.permissionOverwrites_list;
        }

        private Possible<Optional<Snowflake>> parentId_build() {
            return this.parentId_possible;
        }

        private Possible<Optional<String>> rtcRegion_build() {
            return this.rtcRegion_possible;
        }

        private Possible<Optional<VoiceChannel.Mode>> videoQualityMode_build() {
            return this.videoQualityMode_possible;
        }
    }
}

