/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.RoleTags;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.Guild;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.RoleEditMono;
import discord4j.core.spec.RoleEditSpec;
import discord4j.core.spec.legacy.LegacyRoleEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.core.util.ImageUtil;
import discord4j.core.util.MentionUtil;
import discord4j.core.util.OrderUtil;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.RoleTagsData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestRole;
import discord4j.rest.util.Color;
import discord4j.rest.util.Image;
import discord4j.rest.util.PermissionSet;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class Role
implements Entity {
    public static final Color DEFAULT_COLOR = Color.of(0);
    private static final String ICON_IMAGE_PATH = "role-icons/%s/%s";
    private final GatewayDiscordClient gateway;
    private final RoleData data;
    private final RestRole rest;
    private final long guildId;

    public Role(GatewayDiscordClient gateway, RoleData data, long guildId) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
        this.rest = RestRole.create((RestClient)gateway.rest(), Snowflake.of(guildId), Snowflake.of(data.id()));
        this.guildId = guildId;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public RoleData getData() {
        return this.data;
    }

    public int getRawPosition() {
        return this.data.position();
    }

    public Mono<Integer> getPosition() {
        return this.getGuild().flatMapMany(Guild::getRoles).transform(OrderUtil::orderRoles).collectList().map(roles -> roles.indexOf(this));
    }

    public Mono<Integer> getPosition(EntityRetrievalStrategy retrievalStrategy) {
        return this.getGuild(retrievalStrategy).flatMapMany(guild -> guild.getRoles(retrievalStrategy)).transform(OrderUtil::orderRoles).collectList().map(roles -> roles.indexOf(this));
    }

    public Optional<String> getIconUrl(Image.Format format) {
        return Possible.flatOpt(this.data.icon()).map(icon -> ImageUtil.getUrl(String.format(ICON_IMAGE_PATH, this.getId().asString(), icon), format));
    }

    public Optional<String> getUnicodeEmoji() {
        return Possible.flatOpt(this.data.unicodeEmoji());
    }

    public String getName() {
        return this.data.name();
    }

    public Color getColor() {
        return Color.of(this.data.color());
    }

    public boolean isHoisted() {
        return this.data.hoist();
    }

    public PermissionSet getPermissions() {
        return PermissionSet.of(this.data.permissions());
    }

    public boolean isManaged() {
        return this.data.managed();
    }

    public boolean isMentionable() {
        return this.data.mentionable();
    }

    public boolean isEveryone() {
        return this.getId().equals(this.getGuildId());
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.gateway.getGuildById(this.getGuildId());
    }

    public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getGuildById(this.getGuildId());
    }

    public String getMention() {
        if (this.isEveryone()) {
            return "@everyone";
        }
        return MentionUtil.forRole(this.getId());
    }

    public Optional<RoleTags> getTags() {
        return this.data.tags().toOptional().map(data -> new RoleTags(this.gateway, (RoleTagsData)data));
    }

    public EnumSet<Flag> getFlags() {
        int flags = this.data.flags();
        if (flags != 0) {
            return Flag.of(flags);
        }
        return EnumSet.noneOf(Flag.class);
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    @Deprecated
    public Mono<Role> edit(Consumer<? super LegacyRoleEditSpec> spec) {
        return Mono.defer(() -> {
            LegacyRoleEditSpec mutatedSpec = new LegacyRoleEditSpec();
            spec.accept(mutatedSpec);
            return this.rest.edit(mutatedSpec.asRequest(), mutatedSpec.getReason()).map(bean -> new Role(this.gateway, (RoleData)bean, this.getGuildId().asLong()));
        });
    }

    public RoleEditMono edit() {
        return RoleEditMono.of(this);
    }

    public Mono<Role> edit(RoleEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.rest.edit(spec.asRequest(), spec.reason()).map(bean -> new Role(this.gateway, (RoleData)bean, this.getGuildId().asLong())));
    }

    public Mono<Void> delete() {
        return this.delete(null);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.rest.delete(reason);
    }

    public Flux<Role> changePosition(int position) {
        return this.rest.changePosition(position).map(data -> new Role(this.gateway, (RoleData)data, this.getGuildId().asLong()));
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "Role{data=" + this.data + ", guildId=" + this.guildId + '}';
    }

    public static enum Flag {
        IN_PROMPT(0);

        private final int value;
        private final int flag;

        private Flag(int value) {
            this.value = value;
            this.flag = 1 << value;
        }

        public int getValue() {
            return this.value;
        }

        public int getFlag() {
            return this.flag;
        }

        public static EnumSet<Flag> of(int value) {
            EnumSet<Flag> flagSet = EnumSet.noneOf(Flag.class);
            for (Flag flag : Flag.values()) {
                long flagValue = flag.getFlag();
                if ((flagValue & (long)value) != flagValue) continue;
                flagSet.add(flag);
            }
            return flagSet;
        }
    }
}

