/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.object.ExtendedPermissionOverwrite;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.util.OrderUtil;
import discord4j.discordjson.json.ImmutablePermissionsEditRequest;
import discord4j.discordjson.json.OverwriteData;
import discord4j.discordjson.json.PermissionsEditRequest;
import discord4j.rest.util.PermissionSet;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public interface TopLevelGuildChannel
extends GuildChannel {
    default public Set<ExtendedPermissionOverwrite> getPermissionOverwrites() {
        return this.getData().permissionOverwrites().toOptional().map(permissionOverwrites -> {
            long guildId = this.getGuildId().asLong();
            long channelId = this.getId().asLong();
            return permissionOverwrites.stream().map(overwriteData -> new ExtendedPermissionOverwrite(this.getClient(), (OverwriteData)overwriteData, guildId, channelId)).collect(Collectors.toSet());
        }).orElse(Collections.emptySet());
    }

    default public Optional<ExtendedPermissionOverwrite> getOverwriteForMember(Snowflake memberId) {
        return this.getPermissionOverwrites().stream().filter(overwrite -> overwrite.getMemberId().map(memberId::equals).orElse(false)).findFirst();
    }

    default public Optional<ExtendedPermissionOverwrite> getOverwriteForRole(Snowflake roleId) {
        return this.getPermissionOverwrites().stream().filter(overwrite -> overwrite.getRoleId().map(roleId::equals).orElse(false)).findFirst();
    }

    default public Mono<Void> addMemberOverwrite(Snowflake memberId, PermissionOverwrite overwrite) {
        return this.addMemberOverwrite(memberId, overwrite, null);
    }

    default public Mono<Void> addMemberOverwrite(Snowflake memberId, PermissionOverwrite overwrite, @Nullable String reason) {
        PermissionSet allow = overwrite.getAllowed();
        PermissionSet deny = overwrite.getDenied();
        ImmutablePermissionsEditRequest request = PermissionsEditRequest.builder().allow(allow.getRawValue()).deny(deny.getRawValue()).type(PermissionOverwrite.Type.MEMBER.getValue()).build();
        return this.getClient().getRestClient().getChannelService().editChannelPermissions(this.getId().asLong(), memberId.asLong(), request, reason);
    }

    default public Mono<Void> addRoleOverwrite(Snowflake roleId, PermissionOverwrite overwrite) {
        return this.addRoleOverwrite(roleId, overwrite, null);
    }

    default public Mono<Void> addRoleOverwrite(Snowflake roleId, PermissionOverwrite overwrite, @Nullable String reason) {
        PermissionSet allow = overwrite.getAllowed();
        PermissionSet deny = overwrite.getDenied();
        ImmutablePermissionsEditRequest request = PermissionsEditRequest.builder().allow(allow.getRawValue()).deny(deny.getRawValue()).type(PermissionOverwrite.Type.ROLE.getValue()).build();
        return this.getClient().getRestClient().getChannelService().editChannelPermissions(this.getId().asLong(), roleId.asLong(), request, reason);
    }

    default public int getRawPosition() {
        return this.getData().position().toOptional().orElseThrow(IllegalStateException::new);
    }

    default public Mono<Integer> getPosition() {
        return this.getGuild().flatMapMany(Guild::getChannels).transform(OrderUtil::orderGuildChannels).collectList().map(channels -> channels.indexOf(this));
    }
}

