/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.spec.StageChannelCreateSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="StageChannelCreateSpecGenerator", generator="Immutables")
public final class StageChannelCreateSpec
implements StageChannelCreateSpecGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final Integer bitrate_value;
    private final boolean bitrate_absent;
    private final Integer position_value;
    private final boolean position_absent;
    private final Integer rateLimitPerUser_value;
    private final boolean rateLimitPerUser_absent;
    private final List<PermissionOverwrite> permissionOverwrites_value;
    private final boolean permissionOverwrites_absent;
    private final Snowflake parentId_value;
    private final boolean parentId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private StageChannelCreateSpec(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.reason = null;
        Possible bitrate$impl = Possible.absent();
        Possible position$impl = Possible.absent();
        Possible rateLimitPerUser$impl = Possible.absent();
        Possible permissionOverwrites$impl = Possible.absent();
        Possible parentId$impl = Possible.absent();
        this.bitrate_value = bitrate$impl.toOptional().orElse(null);
        this.bitrate_absent = bitrate$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = parentId$impl.toOptional().orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.initShim = null;
    }

    private StageChannelCreateSpec(@Nullable String reason, String name, Possible<Integer> bitrate, Possible<Integer> position, Possible<Integer> rateLimitPerUser, Possible<List<PermissionOverwrite>> permissionOverwrites, Possible<Snowflake> parentId) {
        this.reason = reason;
        this.name = name;
        Possible<Integer> bitrate$impl = bitrate;
        Possible<Integer> position$impl = position;
        Possible<Integer> rateLimitPerUser$impl = rateLimitPerUser;
        Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
        Possible<Snowflake> parentId$impl = parentId;
        this.bitrate_value = bitrate$impl.toOptional().orElse(null);
        this.bitrate_absent = bitrate$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = parentId$impl.toOptional().orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<Integer> bitrate() {
        return this.bitrate_absent ? Possible.absent() : Possible.of(this.bitrate_value);
    }

    @Override
    public Possible<Integer> position() {
        return this.position_absent ? Possible.absent() : Possible.of(this.position_value);
    }

    @Override
    public Possible<Integer> rateLimitPerUser() {
        return this.rateLimitPerUser_absent ? Possible.absent() : Possible.of(this.rateLimitPerUser_value);
    }

    @Override
    public Possible<List<PermissionOverwrite>> permissionOverwrites() {
        return this.permissionOverwrites_absent ? Possible.absent() : Possible.of(this.permissionOverwrites_value);
    }

    @Override
    public Possible<Snowflake> parentId() {
        return this.parentId_absent ? Possible.absent() : Possible.of(this.parentId_value);
    }

    public final StageChannelCreateSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new StageChannelCreateSpec(value, this.name, this.bitrate(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId());
    }

    public final StageChannelCreateSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new StageChannelCreateSpec(this.reason, newValue, this.bitrate(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId());
    }

    public StageChannelCreateSpec withBitrate(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new StageChannelCreateSpec(this.reason, this.name, newValue, this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId());
    }

    public StageChannelCreateSpec withBitrate(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new StageChannelCreateSpec(this.reason, this.name, newValue, this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId());
    }

    public StageChannelCreateSpec withPosition(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new StageChannelCreateSpec(this.reason, this.name, this.bitrate(), newValue, this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId());
    }

    public StageChannelCreateSpec withPosition(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new StageChannelCreateSpec(this.reason, this.name, this.bitrate(), newValue, this.rateLimitPerUser(), this.permissionOverwrites(), this.parentId());
    }

    public StageChannelCreateSpec withRateLimitPerUser(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new StageChannelCreateSpec(this.reason, this.name, this.bitrate(), this.position(), newValue, this.permissionOverwrites(), this.parentId());
    }

    public StageChannelCreateSpec withRateLimitPerUser(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new StageChannelCreateSpec(this.reason, this.name, this.bitrate(), this.position(), newValue, this.permissionOverwrites(), this.parentId());
    }

    public StageChannelCreateSpec withPermissionOverwrites(Possible<? extends List<? extends PermissionOverwrite>> possible) {
        Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
        return new StageChannelCreateSpec(this.reason, this.name, this.bitrate(), this.position(), this.rateLimitPerUser(), newValue, this.parentId());
    }

    public StageChannelCreateSpec withPermissionOverwrites(Iterable<? extends PermissionOverwrite> elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new StageChannelCreateSpec(this.reason, this.name, this.bitrate(), this.position(), this.rateLimitPerUser(), newValue, this.parentId());
    }

    @SafeVarargs
    public final StageChannelCreateSpec withPermissionOverwrites(PermissionOverwrite ... elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
        return new StageChannelCreateSpec(this.reason, this.name, this.bitrate(), this.position(), this.rateLimitPerUser(), newValue, this.parentId());
    }

    public StageChannelCreateSpec withParentId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new StageChannelCreateSpec(this.reason, this.name, this.bitrate(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), newValue);
    }

    public StageChannelCreateSpec withParentId(Snowflake value) {
        Possible<Snowflake> newValue = Possible.of(value);
        return new StageChannelCreateSpec(this.reason, this.name, this.bitrate(), this.position(), this.rateLimitPerUser(), this.permissionOverwrites(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StageChannelCreateSpec && this.equalTo(0, (StageChannelCreateSpec)another);
    }

    private boolean equalTo(int synthetic, StageChannelCreateSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.bitrate().equals(another.bitrate()) && this.position().equals(another.position()) && this.rateLimitPerUser().equals(another.rateLimitPerUser()) && Objects.equals(this.permissionOverwrites_value, another.permissionOverwrites_value) && this.parentId().equals(another.parentId());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.bitrate().hashCode();
        h2 += (h2 << 5) + this.position().hashCode();
        h2 += (h2 << 5) + this.rateLimitPerUser().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.permissionOverwrites_value);
        h2 += (h2 << 5) + this.parentId().hashCode();
        return h2;
    }

    public String toString() {
        return "StageChannelCreateSpec{reason=" + this.reason + ", name=" + this.name + ", bitrate=" + this.bitrate().toString() + ", position=" + this.position().toString() + ", rateLimitPerUser=" + this.rateLimitPerUser().toString() + ", permissionOverwrites=" + Objects.toString(this.permissionOverwrites_value) + ", parentId=" + this.parentId().toString() + "}";
    }

    public static StageChannelCreateSpec of(String name) {
        return new StageChannelCreateSpec(name);
    }

    static StageChannelCreateSpec copyOf(StageChannelCreateSpecGenerator instance) {
        if (instance instanceof StageChannelCreateSpec) {
            return (StageChannelCreateSpec)instance;
        }
        return StageChannelCreateSpec.builder().from(instance).build();
    }

    public boolean isBitratePresent() {
        return !this.bitrate_absent;
    }

    public Integer bitrateOrElse(Integer defaultValue) {
        return !this.bitrate_absent ? this.bitrate_value : defaultValue;
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public boolean isRateLimitPerUserPresent() {
        return !this.rateLimitPerUser_absent;
    }

    public Integer rateLimitPerUserOrElse(Integer defaultValue) {
        return !this.rateLimitPerUser_absent ? this.rateLimitPerUser_value : defaultValue;
    }

    public boolean isPermissionOverwritesPresent() {
        return !this.permissionOverwrites_absent;
    }

    public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
        return !this.permissionOverwrites_absent ? this.permissionOverwrites_value : defaultValue;
    }

    public boolean isParentIdPresent() {
        return !this.parentId_absent;
    }

    public Snowflake parentIdOrElse(Snowflake defaultValue) {
        return !this.parentId_absent ? this.parentId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StageChannelCreateSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build StageChannelCreateSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="StageChannelCreateSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Possible<Integer> bitrate_possible = Possible.absent();
        private Possible<Integer> position_possible = Possible.absent();
        private Possible<Integer> rateLimitPerUser_possible = Possible.absent();
        private List<PermissionOverwrite> permissionOverwrites_list = null;
        private Possible<Snowflake> parentId_possible = Possible.absent();
        private String reason;
        private String name;

        private Builder() {
        }

        public final Builder from(StageChannelCreateSpec instance) {
            return this.from((StageChannelCreateSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(StageChannelCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.bitrate(instance.bitrate());
            this.position(instance.position());
            this.rateLimitPerUser(instance.rateLimitPerUser());
            this.permissionOverwrites(instance.permissionOverwrites());
            this.parentId(instance.parentId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder bitrate(Possible<Integer> value) {
            this.bitrate_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder bitrate(Integer value) {
            this.bitrate_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder position(Possible<Integer> value) {
            this.position_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder position(Integer value) {
            this.position_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rateLimitPerUser(Possible<Integer> value) {
            this.rateLimitPerUser_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rateLimitPerUser(Integer value) {
            this.rateLimitPerUser_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPermissionOverwrite(PermissionOverwrite element) {
            this.permissionOverwrites_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllPermissionOverwrites(Collection<? extends PermissionOverwrite> elements) {
            this.permissionOverwrites_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(Possible<? extends Collection<? extends PermissionOverwrite>> elements) {
            this.permissionOverwrites_list = null;
            elements.toOptional().ifPresent(e -> this.permissionOverwrites_getOrCreate().addAll((Collection<PermissionOverwrite>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(Iterable<? extends PermissionOverwrite> elements) {
            this.permissionOverwrites_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder permissionOverwrites(PermissionOverwrite ... elements) {
            this.permissionOverwrites_list = Arrays.asList(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder parentId(Possible<Snowflake> value) {
            this.parentId_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder parentId(Snowflake value) {
            this.parentId_possible = Possible.of(value);
            return this;
        }

        public StageChannelCreateSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new StageChannelCreateSpec(this.reason, this.name, this.bitrate_build(), this.position_build(), this.rateLimitPerUser_build(), this.permissionOverwrites_build(), this.parentId_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build StageChannelCreateSpec, some of required attributes are not set " + attributes;
        }

        private Possible<Integer> bitrate_build() {
            return this.bitrate_possible;
        }

        private Possible<Integer> position_build() {
            return this.position_possible;
        }

        private Possible<Integer> rateLimitPerUser_build() {
            return this.rateLimitPerUser_possible;
        }

        private Possible<List<PermissionOverwrite>> permissionOverwrites_build() {
            return this.permissionOverwrites_list == null ? Possible.absent() : Possible.of(this.permissionOverwrites_list);
        }

        private List<PermissionOverwrite> permissionOverwrites_getOrCreate() {
            if (this.permissionOverwrites_list == null) {
                this.permissionOverwrites_list = new ArrayList<PermissionOverwrite>();
            }
            return this.permissionOverwrites_list;
        }

        private Possible<Snowflake> parentId_build() {
            return this.parentId_possible;
        }
    }
}

