/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.entity.channel.TopLevelGuildMessageChannel;
import discord4j.core.spec.WebhookCreateMonoGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="WebhookCreateMonoGenerator", generator="Immutables")
public final class WebhookCreateMono
extends WebhookCreateMonoGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final Image avatar_value;
    private final boolean avatar_absent;
    private final TopLevelGuildMessageChannel channel;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private WebhookCreateMono(String name, TopLevelGuildMessageChannel channel) {
        this.name = Objects.requireNonNull(name, "name");
        this.channel = Objects.requireNonNull(channel, "channel");
        this.reason = null;
        Possible avatar$impl = Possible.absent();
        this.avatar_value = Possible.flatOpt(avatar$impl).orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.initShim = null;
    }

    private WebhookCreateMono(@Nullable String reason, String name, Possible<Optional<Image>> avatar, TopLevelGuildMessageChannel channel) {
        this.reason = reason;
        this.name = name;
        Possible avatar$impl = avatar;
        this.channel = channel;
        this.avatar_value = Possible.flatOpt(avatar$impl).orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<Optional<Image>> avatar() {
        return this.avatar_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.avatar_value));
    }

    @Override
    public TopLevelGuildMessageChannel channel() {
        return this.channel;
    }

    public final WebhookCreateMono withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new WebhookCreateMono(value, this.name, this.avatar(), this.channel);
    }

    public final WebhookCreateMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new WebhookCreateMono(this.reason, newValue, this.avatar(), this.channel);
    }

    public WebhookCreateMono withAvatar(Possible<Optional<Image>> value) {
        Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
        return new WebhookCreateMono(this.reason, this.name, newValue, this.channel);
    }

    @Deprecated
    public WebhookCreateMono withAvatar(@Nullable Image value) {
        Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
        return new WebhookCreateMono(this.reason, this.name, newValue, this.channel);
    }

    public WebhookCreateMono withAvatarOrNull(@Nullable Image value) {
        Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
        return new WebhookCreateMono(this.reason, this.name, newValue, this.channel);
    }

    public final WebhookCreateMono withChannel(TopLevelGuildMessageChannel value) {
        if (this.channel == value) {
            return this;
        }
        TopLevelGuildMessageChannel newValue = Objects.requireNonNull(value, "channel");
        return new WebhookCreateMono(this.reason, this.name, this.avatar(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WebhookCreateMono && this.equalTo(0, (WebhookCreateMono)another);
    }

    private boolean equalTo(int synthetic, WebhookCreateMono another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.avatar().equals(another.avatar()) && this.channel.equals(another.channel);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.avatar().hashCode();
        h2 += (h2 << 5) + this.channel.hashCode();
        return h2;
    }

    @Override
    public String toString() {
        return "WebhookCreateMono{reason=" + this.reason + ", name=" + this.name + ", avatar=" + this.avatar().toString() + ", channel=" + this.channel + "}";
    }

    public static WebhookCreateMono of(String name, TopLevelGuildMessageChannel channel) {
        return new WebhookCreateMono(name, channel);
    }

    static WebhookCreateMono copyOf(WebhookCreateMonoGenerator instance) {
        if (instance instanceof WebhookCreateMono) {
            return (WebhookCreateMono)instance;
        }
        return WebhookCreateMono.of(instance.name(), instance.channel()).withReason(instance.reason()).withAvatar(instance.avatar());
    }

    public boolean isAvatarPresent() {
        return !this.avatar_absent;
    }

    public Image avatarOrElse(Image defaultValue) {
        return !this.avatar_absent ? this.avatar_value : defaultValue;
    }

    @Generated(from="WebhookCreateMonoGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build WebhookCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

