/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.channel.AudioChannel;
import discord4j.core.object.entity.channel.BaseTopLevelGuildChannel;
import discord4j.core.object.entity.channel.TopLevelGuildMessageChannel;
import discord4j.core.spec.VoiceChannelEditMono;
import discord4j.core.spec.VoiceChannelEditSpec;
import discord4j.core.spec.legacy.LegacyVoiceChannelEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.ChannelData;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

public final class VoiceChannel
extends BaseTopLevelGuildChannel
implements AudioChannel,
TopLevelGuildMessageChannel {
    public VoiceChannel(GatewayDiscordClient gateway, ChannelData data) {
        super(gateway, data);
    }

    public int getUserLimit() {
        return this.getData().userLimit().toOptional().orElseThrow(IllegalStateException::new);
    }

    public Mode getVideoQualityMode() {
        return this.getData().videoQualityMode().toOptional().map(Mode::of).orElse(Mode.AUTO);
    }

    @Deprecated
    public Mono<VoiceChannel> edit(Consumer<? super LegacyVoiceChannelEditSpec> spec) {
        return Mono.defer(() -> {
            LegacyVoiceChannelEditSpec mutatedSpec = new LegacyVoiceChannelEditSpec();
            spec.accept(mutatedSpec);
            return this.getClient().getRestClient().getChannelService().modifyChannel(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> EntityUtil.getChannel(this.getClient(), data)).cast(VoiceChannel.class);
    }

    public VoiceChannelEditMono edit() {
        return VoiceChannelEditMono.of(this);
    }

    public Mono<VoiceChannel> edit(VoiceChannelEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getClient().getRestClient().getChannelService().modifyChannel(this.getId().asLong(), spec.asRequest(), spec.reason())).map(data -> EntityUtil.getChannel(this.getClient(), data)).cast(VoiceChannel.class);
    }

    @Override
    public String toString() {
        return "VoiceChannel{} " + super.toString();
    }

    public static enum Mode {
        UNKNOWN(-1),
        AUTO(1),
        FULL(2);

        private final int value;

        private Mode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Mode of(int value) {
            switch (value) {
                case 1: {
                    return AUTO;
                }
                case 2: {
                    return FULL;
                }
            }
            return UNKNOWN;
        }
    }
}

