/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.object.entity.channel.ThreadChannel;
import discord4j.core.spec.StartThreadSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="StartThreadSpecGenerator", generator="Immutables")
public final class StartThreadSpec
implements StartThreadSpecGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final ThreadChannel.AutoArchiveDuration autoArchiveDuration_value;
    private final boolean autoArchiveDuration_absent;
    private final Integer rateLimitPerUser_value;
    private final boolean rateLimitPerUser_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private StartThreadSpec(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.reason = null;
        Possible autoArchiveDuration$impl = Possible.absent();
        Possible rateLimitPerUser$impl = Possible.absent();
        this.autoArchiveDuration_value = autoArchiveDuration$impl.toOptional().orElse(null);
        this.autoArchiveDuration_absent = autoArchiveDuration$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.initShim = null;
    }

    private StartThreadSpec(@Nullable String reason, String name, Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration, Possible<Integer> rateLimitPerUser) {
        this.reason = reason;
        this.name = name;
        Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration$impl = autoArchiveDuration;
        Possible<Integer> rateLimitPerUser$impl = rateLimitPerUser;
        this.autoArchiveDuration_value = autoArchiveDuration$impl.toOptional().orElse(null);
        this.autoArchiveDuration_absent = autoArchiveDuration$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration() {
        return this.autoArchiveDuration_absent ? Possible.absent() : Possible.of(this.autoArchiveDuration_value);
    }

    @Override
    public Possible<Integer> rateLimitPerUser() {
        return this.rateLimitPerUser_absent ? Possible.absent() : Possible.of(this.rateLimitPerUser_value);
    }

    public final StartThreadSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new StartThreadSpec(value, this.name, this.autoArchiveDuration(), this.rateLimitPerUser());
    }

    public final StartThreadSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new StartThreadSpec(this.reason, newValue, this.autoArchiveDuration(), this.rateLimitPerUser());
    }

    public StartThreadSpec withAutoArchiveDuration(Possible<ThreadChannel.AutoArchiveDuration> value) {
        Possible<ThreadChannel.AutoArchiveDuration> newValue = Objects.requireNonNull(value);
        return new StartThreadSpec(this.reason, this.name, newValue, this.rateLimitPerUser());
    }

    public StartThreadSpec withAutoArchiveDuration(ThreadChannel.AutoArchiveDuration value) {
        Possible<ThreadChannel.AutoArchiveDuration> newValue = Possible.of(value);
        return new StartThreadSpec(this.reason, this.name, newValue, this.rateLimitPerUser());
    }

    public StartThreadSpec withRateLimitPerUser(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new StartThreadSpec(this.reason, this.name, this.autoArchiveDuration(), newValue);
    }

    public StartThreadSpec withRateLimitPerUser(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return new StartThreadSpec(this.reason, this.name, this.autoArchiveDuration(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StartThreadSpec && this.equalTo(0, (StartThreadSpec)another);
    }

    private boolean equalTo(int synthetic, StartThreadSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.autoArchiveDuration().equals(another.autoArchiveDuration()) && this.rateLimitPerUser().equals(another.rateLimitPerUser());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.autoArchiveDuration().hashCode();
        h2 += (h2 << 5) + this.rateLimitPerUser().hashCode();
        return h2;
    }

    public String toString() {
        return "StartThreadSpec{reason=" + this.reason + ", name=" + this.name + ", autoArchiveDuration=" + this.autoArchiveDuration().toString() + ", rateLimitPerUser=" + this.rateLimitPerUser().toString() + "}";
    }

    public static StartThreadSpec of(String name) {
        return new StartThreadSpec(name);
    }

    public static StartThreadSpec copyOf(StartThreadSpecGenerator instance) {
        if (instance instanceof StartThreadSpec) {
            return (StartThreadSpec)instance;
        }
        return StartThreadSpec.builder().from(instance).build();
    }

    public boolean isAutoArchiveDurationPresent() {
        return !this.autoArchiveDuration_absent;
    }

    public ThreadChannel.AutoArchiveDuration autoArchiveDurationOrElse(ThreadChannel.AutoArchiveDuration defaultValue) {
        return !this.autoArchiveDuration_absent ? this.autoArchiveDuration_value : defaultValue;
    }

    public boolean isRateLimitPerUserPresent() {
        return !this.rateLimitPerUser_absent;
    }

    public Integer rateLimitPerUserOrElse(Integer defaultValue) {
        return !this.rateLimitPerUser_absent ? this.rateLimitPerUser_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StartThreadSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build StartThreadSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="StartThreadSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration_possible = Possible.absent();
        private Possible<Integer> rateLimitPerUser_possible = Possible.absent();
        private String reason;
        private String name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StartThreadSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.autoArchiveDuration(instance.autoArchiveDuration());
            this.rateLimitPerUser(instance.rateLimitPerUser());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder autoArchiveDuration(Possible<ThreadChannel.AutoArchiveDuration> value) {
            this.autoArchiveDuration_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder autoArchiveDuration(ThreadChannel.AutoArchiveDuration value) {
            this.autoArchiveDuration_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rateLimitPerUser(Possible<Integer> value) {
            this.rateLimitPerUser_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rateLimitPerUser(Integer value) {
            this.rateLimitPerUser_possible = Possible.of(value);
            return this;
        }

        public StartThreadSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new StartThreadSpec(this.reason, this.name, this.autoArchiveDuration_build(), this.rateLimitPerUser_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build StartThreadSpec, some of required attributes are not set " + attributes;
        }

        private Possible<ThreadChannel.AutoArchiveDuration> autoArchiveDuration_build() {
            return this.autoArchiveDuration_possible;
        }

        private Possible<Integer> rateLimitPerUser_build() {
            return this.rateLimitPerUser_possible;
        }
    }
}

