/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.Ban;
import discord4j.core.object.ExtendedInvite;
import discord4j.core.object.GuildTemplate;
import discord4j.core.object.Region;
import discord4j.core.object.VoiceState;
import discord4j.core.object.audit.AuditLogEntry;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.GuildEmoji;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.Webhook;
import discord4j.core.object.entity.channel.Category;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.object.entity.channel.NewsChannel;
import discord4j.core.object.entity.channel.TextChannel;
import discord4j.core.object.entity.channel.VoiceChannel;
import discord4j.core.object.presence.Presence;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.AuditLogQuerySpec;
import discord4j.core.spec.BanQuerySpec;
import discord4j.core.spec.CategoryCreateSpec;
import discord4j.core.spec.GuildEditSpec;
import discord4j.core.spec.GuildEmojiCreateSpec;
import discord4j.core.spec.GuildPruneCountSpec;
import discord4j.core.spec.GuildPruneSpec;
import discord4j.core.spec.GuildTemplateCreateSpec;
import discord4j.core.spec.NewsChannelCreateSpec;
import discord4j.core.spec.RoleCreateSpec;
import discord4j.core.spec.TextChannelCreateSpec;
import discord4j.core.spec.VoiceChannelCreateSpec;
import discord4j.core.util.EntityUtil;
import discord4j.core.util.ImageUtil;
import discord4j.discordjson.json.AuditLogData;
import discord4j.discordjson.json.AuditLogEntryData;
import discord4j.discordjson.json.BanData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.GuildUpdateFields;
import discord4j.discordjson.json.InviteData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.NicknameModifyData;
import discord4j.discordjson.json.RegionData;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.TemplateData;
import discord4j.discordjson.json.VoiceStateData;
import discord4j.discordjson.json.WebhookData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import discord4j.rest.util.Multimap;
import discord4j.rest.util.PaginationUtil;
import discord4j.store.api.util.LongLongTuple2;
import discord4j.voice.VoiceConnection;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class Guild
implements Entity {
    private static final int DEFAULT_MAX_PRESENCES = 25000;
    private static final String ICON_IMAGE_PATH = "icons/%s/%s";
    private static final String SPLASH_IMAGE_PATH = "splashes/%s/%s";
    private static final String DISCOVERY_SPLASH_IMAGE_PATH = "discovery-splashes/%s/%s";
    private static final String BANNER_IMAGE_PATH = "banners/%s/%s";
    private final GatewayDiscordClient gateway;
    private final GuildData data;

    public Guild(GatewayDiscordClient gateway, GuildData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    public GuildData getData() {
        return this.data;
    }

    public String getName() {
        return this.data.name();
    }

    public Optional<String> getIconUrl(Image.Format format) {
        return this.data.icon().map(icon -> ImageUtil.getUrl(String.format(ICON_IMAGE_PATH, this.getId().asString(), icon), format));
    }

    public Mono<Image> getIcon(Image.Format format) {
        return Mono.justOrEmpty(this.getIconUrl(format)).flatMap(Image::ofUrl);
    }

    public Optional<String> getSplashUrl(Image.Format format) {
        return this.data.splash().map(splash -> ImageUtil.getUrl(String.format(SPLASH_IMAGE_PATH, this.getId().asString(), splash), format));
    }

    public Mono<Image> getSplash(Image.Format format) {
        return Mono.justOrEmpty(this.getSplashUrl(format)).flatMap(Image::ofUrl);
    }

    public Optional<String> getDiscoverySplashUrl(Image.Format format) {
        return this.data.discoverySplash().map(splash -> ImageUtil.getUrl(String.format(DISCOVERY_SPLASH_IMAGE_PATH, this.getId().asString(), splash), format));
    }

    public Mono<Image> getDiscoverySplash(Image.Format format) {
        return Mono.justOrEmpty(this.getDiscoverySplashUrl(format)).flatMap(Image::ofUrl);
    }

    public Optional<String> getBannerUrl(Image.Format format) {
        return this.data.banner().map(splash -> ImageUtil.getUrl(String.format(BANNER_IMAGE_PATH, this.getId().asString(), splash), format));
    }

    public Mono<Image> getBanner(Image.Format format) {
        return Mono.justOrEmpty(this.getBannerUrl(format)).flatMap(Image::ofUrl);
    }

    public Snowflake getOwnerId() {
        return Snowflake.of(this.data.ownerId());
    }

    public Mono<Member> getOwner() {
        return this.gateway.getMemberById(this.getId(), this.getOwnerId());
    }

    @Deprecated
    public Region.Id getRegionId() {
        return Region.Id.of(this.data.region());
    }

    @Deprecated
    public Mono<Region> getRegion() {
        return this.getRegions().filter(response -> response.getId().equals(this.getRegionId().getValue())).single();
    }

    public Flux<Region> getRegions() {
        return this.gateway.getRestClient().getGuildService().getGuildVoiceRegions(this.getId().asLong()).map(data -> new Region(this.gateway, (RegionData)data));
    }

    public Optional<Snowflake> getAfkChannelId() {
        return this.data.afkChannelId().map(Snowflake::of);
    }

    public Mono<VoiceChannel> getAfkChannel() {
        return Mono.justOrEmpty(this.getAfkChannelId()).flatMap(this.gateway::getChannelById).cast(VoiceChannel.class);
    }

    public Mono<VoiceChannel> getAfkChannel(EntityRetrievalStrategy retrievalStrategy) {
        return Mono.justOrEmpty(this.getAfkChannelId()).flatMap(id -> this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById((Snowflake)id)).cast(VoiceChannel.class);
    }

    public int getAfkTimeout() {
        return this.data.afkTimeout();
    }

    @Deprecated
    public Optional<Snowflake> getEmbedChannelId() {
        return this.getWidgetChannelId();
    }

    public Mono<GuildChannel> getEmbedChannel() {
        return Mono.justOrEmpty(this.getEmbedChannelId()).flatMap(this.gateway::getChannelById).cast(GuildChannel.class);
    }

    public Mono<GuildChannel> getEmbedChannel(EntityRetrievalStrategy retrievalStrategy) {
        return Mono.justOrEmpty(this.getEmbedChannelId()).flatMap(id -> this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById((Snowflake)id)).cast(GuildChannel.class);
    }

    public PremiumTier getPremiumTier() {
        return PremiumTier.of(this.data.premiumTier());
    }

    public OptionalInt getPremiumSubscriptionCount() {
        return this.data.premiumSubscriptionCount().toOptional().map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    public Locale getPreferredLocale() {
        return new Locale.Builder().setLanguageTag(this.data.preferredLocale()).build();
    }

    public VerificationLevel getVerificationLevel() {
        return VerificationLevel.of(this.data.verificationLevel());
    }

    public NotificationLevel getNotificationLevel() {
        return NotificationLevel.of(this.data.defaultMessageNotifications());
    }

    public ContentFilterLevel getContentFilterLevel() {
        return ContentFilterLevel.of(this.data.explicitContentFilter());
    }

    public Set<Snowflake> getRoleIds() {
        return this.data.roles().stream().map(Snowflake::of).collect(Collectors.toSet());
    }

    public Flux<Role> getRoles() {
        return this.gateway.getGuildRoles(this.getId());
    }

    public Flux<Role> getRoles(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getGuildRoles(this.getId());
    }

    public Mono<Role> getRoleById(Snowflake id) {
        return this.gateway.getRoleById(this.getId(), id);
    }

    public Mono<Role> getRoleById(Snowflake id, EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getRoleById(this.getId(), id);
    }

    public Mono<Role> getEveryoneRole() {
        return this.gateway.getRoleById(this.getId(), this.getId());
    }

    public Mono<Role> getEveryoneRole(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getRoleById(this.getId(), this.getId());
    }

    public Set<Snowflake> getEmojiIds() {
        return this.data.emojis().stream().map(Snowflake::of).collect(Collectors.toSet());
    }

    public Flux<GuildEmoji> getEmojis() {
        return this.gateway.getGuildEmojis(this.getId());
    }

    public Flux<GuildEmoji> getEmojis(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getGuildEmojis(this.getId());
    }

    public Mono<GuildEmoji> getGuildEmojiById(Snowflake id) {
        return this.gateway.getGuildEmojiById(this.getId(), id);
    }

    public Mono<GuildEmoji> getGuildEmojiById(Snowflake id, EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getGuildEmojiById(this.getId(), id);
    }

    public Set<String> getFeatures() {
        return new HashSet<String>(this.data.features());
    }

    public MfaLevel getMfaLevel() {
        return MfaLevel.of(this.data.mfaLevel());
    }

    public Optional<Snowflake> getApplicationId() {
        return this.data.applicationId().map(Snowflake::of);
    }

    public boolean isWidgetEnabled() {
        return this.data.widgetEnabled().toOptional().orElse(false);
    }

    public Optional<Snowflake> getWidgetChannelId() {
        return Possible.flatOpt(this.data.widgetChannelId()).map(Snowflake::of);
    }

    public Mono<GuildChannel> getWidgetChannel() {
        return Mono.justOrEmpty(this.getWidgetChannelId()).flatMap(this.gateway::getChannelById).cast(GuildChannel.class);
    }

    public Mono<GuildChannel> getWidgetChannel(EntityRetrievalStrategy retrievalStrategy) {
        return Mono.justOrEmpty(this.getWidgetChannelId()).flatMap(id -> this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById((Snowflake)id)).cast(GuildChannel.class);
    }

    public Optional<Snowflake> getSystemChannelId() {
        return this.data.systemChannelId().map(Snowflake::of);
    }

    public Mono<TextChannel> getSystemChannel() {
        return Mono.justOrEmpty(this.getSystemChannelId()).flatMap(this.gateway::getChannelById).cast(TextChannel.class);
    }

    public Mono<TextChannel> getSystemChannel(EntityRetrievalStrategy retrievalStrategy) {
        return Mono.justOrEmpty(this.getSystemChannelId()).flatMap(id -> this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById((Snowflake)id)).cast(TextChannel.class);
    }

    public EnumSet<SystemChannelFlag> getSystemChannelFlags() {
        return SystemChannelFlag.of(this.data.systemChannelFlags().orElse(0));
    }

    public Optional<Snowflake> getRulesChannelId() {
        return this.data.rulesChannelId().map(Snowflake::of);
    }

    public Mono<TextChannel> getRulesChannel() {
        return Mono.justOrEmpty(this.getRulesChannelId()).flatMap(this.gateway::getChannelById).cast(TextChannel.class);
    }

    public Mono<TextChannel> getRulesChannel(EntityRetrievalStrategy retrievalStrategy) {
        return Mono.justOrEmpty(this.getRulesChannelId()).flatMap(id -> this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById((Snowflake)id)).cast(TextChannel.class);
    }

    public Optional<Snowflake> getPublicUpdatesChannelId() {
        return this.data.publicUpdatesChannelId().map(Snowflake::of);
    }

    public Mono<TextChannel> getPublicUpdatesChannel() {
        return Mono.justOrEmpty(this.getPublicUpdatesChannelId()).flatMap(this.gateway::getChannelById).cast(TextChannel.class);
    }

    public Mono<TextChannel> getPublicUpdatesChannel(EntityRetrievalStrategy retrievalStrategy) {
        return Mono.justOrEmpty(this.getPublicUpdatesChannelId()).flatMap(id -> this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById((Snowflake)id)).cast(TextChannel.class);
    }

    public Optional<Integer> getMaxVideoChannelUsers() {
        return this.data.maxVideoChannelUsers().toOptional();
    }

    public Instant getJoinTime() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)this.data.joinedAt(), Instant::from);
    }

    public boolean isLarge() {
        return this.data.large();
    }

    public boolean isUnavailable() {
        return this.data.unavailable().toOptional().orElse(false);
    }

    @Deprecated
    public boolean isEmbedEnabled() {
        return this.isWidgetEnabled();
    }

    public int getMemberCount() {
        return this.data.memberCount();
    }

    @Deprecated
    public boolean isNsfw() {
        return this.data.nsfw().toOptional().orElse(false);
    }

    public NsfwLevel getNsfwLevel() {
        return NsfwLevel.of(this.data.nsfwLevel());
    }

    public Flux<VoiceState> getVoiceStates() {
        return this.gateway.getGatewayResources().getStateView().getVoiceStateStore().findInRange(LongLongTuple2.of(this.getId().asLong(), Long.MIN_VALUE), LongLongTuple2.of(this.getId().asLong(), Long.MAX_VALUE)).map(data -> new VoiceState(this.gateway, (VoiceStateData)data));
    }

    public Flux<Member> getMembers() {
        return this.gateway.getGuildMembers(this.getId());
    }

    public Flux<Member> getMembers(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getGuildMembers(this.getId());
    }

    public Flux<Member> requestMembers() {
        return this.gateway.requestMembers(this.getId());
    }

    public Flux<Member> requestMembers(Set<Snowflake> userIds) {
        return this.gateway.requestMembers(this.getId(), userIds);
    }

    public Flux<Member> searchMembers(String username, int limit) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>(2);
        queryParams.put("query", username);
        queryParams.put("limit", limit);
        return this.gateway.getRestClient().getGuildService().searchGuildMembers(this.data.id().asLong(), queryParams).map(memberData -> new Member(this.gateway, (MemberData)memberData, this.data.id().asLong()));
    }

    public Mono<Member> getMemberById(Snowflake id) {
        return this.gateway.getMemberById(this.getId(), id);
    }

    public Mono<Member> getMemberById(Snowflake id, EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getMemberById(this.getId(), id);
    }

    public Mono<Member> getSelfMember() {
        return this.getMemberById(this.gateway.getSelfId());
    }

    public Flux<GuildChannel> getChannels() {
        return this.gateway.getGuildChannels(this.getId());
    }

    public Flux<GuildChannel> getChannels(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getGuildChannels(this.getId());
    }

    public Mono<GuildChannel> getChannelById(Snowflake id) {
        return this.gateway.getChannelById(id).cast(GuildChannel.class).filter(channel -> channel.getGuildId().equals(this.getId()));
    }

    public Mono<GuildChannel> getChannelById(Snowflake id, EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById(id).cast(GuildChannel.class).filter(channel -> channel.getGuildId().equals(this.getId()));
    }

    public Flux<Presence> getPresences() {
        return this.gateway.getGatewayResources().getStateView().getPresenceStore().findInRange(LongLongTuple2.of(this.getId().asLong(), Long.MIN_VALUE), LongLongTuple2.of(this.getId().asLong(), Long.MAX_VALUE)).map(Presence::new);
    }

    public Optional<String> getVanityUrlCode() {
        return this.data.vanityUrlCode();
    }

    public Optional<String> getDescription() {
        return this.data.description();
    }

    public int getMaxPresences() {
        return Possible.flatOpt(this.data.maxPresences()).orElse(25000);
    }

    public OptionalInt getMaxMembers() {
        return this.data.maxMembers().toOptional().map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public Mono<Guild> edit(Consumer<? super GuildEditSpec> spec) {
        return Mono.defer(() -> {
            GuildEditSpec mutatedSpec = new GuildEditSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getGuildService().modifyGuild(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> new Guild(this.gateway, GuildData.builder().from(this.data).from((GuildUpdateFields)data).build()));
    }

    public Mono<GuildEmoji> createEmoji(Consumer<? super GuildEmojiCreateSpec> spec) {
        return Mono.defer(() -> {
            GuildEmojiCreateSpec mutatedSpec = new GuildEmojiCreateSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getEmojiService().createGuildEmoji(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> new GuildEmoji(this.gateway, (EmojiData)data, this.getId().asLong()));
    }

    public Mono<GuildTemplate> createTemplate(Consumer<? super GuildTemplateCreateSpec> spec) {
        return Mono.defer(() -> {
            GuildTemplateCreateSpec mutatedSpec = new GuildTemplateCreateSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getTemplateService().createTemplate(this.getId().asLong(), mutatedSpec.asRequest());
        }).map(data -> new GuildTemplate(this.gateway, (TemplateData)data));
    }

    public Mono<Role> createRole(Consumer<? super RoleCreateSpec> spec) {
        return Mono.defer(() -> {
            RoleCreateSpec mutatedSpec = new RoleCreateSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getGuildService().createGuildRole(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> new Role(this.gateway, (RoleData)data, this.getId().asLong()));
    }

    public Mono<NewsChannel> createNewsChannel(Consumer<? super NewsChannelCreateSpec> spec) {
        return Mono.defer(() -> {
            NewsChannelCreateSpec mutatedSpec = new NewsChannelCreateSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getGuildService().createGuildChannel(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> EntityUtil.getChannel(this.gateway, data)).cast(NewsChannel.class);
    }

    public Mono<Category> createCategory(Consumer<? super CategoryCreateSpec> spec) {
        return Mono.defer(() -> {
            CategoryCreateSpec mutatedSpec = new CategoryCreateSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getGuildService().createGuildChannel(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> EntityUtil.getChannel(this.gateway, data)).cast(Category.class);
    }

    public Mono<TextChannel> createTextChannel(Consumer<? super TextChannelCreateSpec> spec) {
        return Mono.defer(() -> {
            TextChannelCreateSpec mutatedSpec = new TextChannelCreateSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getGuildService().createGuildChannel(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> EntityUtil.getChannel(this.gateway, data)).cast(TextChannel.class);
    }

    public Mono<VoiceChannel> createVoiceChannel(Consumer<? super VoiceChannelCreateSpec> spec) {
        return Mono.defer(() -> {
            VoiceChannelCreateSpec mutatedSpec = new VoiceChannelCreateSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getGuildService().createGuildChannel(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> EntityUtil.getChannel(this.gateway, data)).cast(VoiceChannel.class);
    }

    public Mono<Void> delete() {
        return this.gateway.getRestClient().getGuildService().deleteGuild(this.getId().asLong());
    }

    public Mono<Void> kick(Snowflake userId) {
        return this.kick(userId, null);
    }

    public Mono<Void> kick(Snowflake userId, @Nullable String reason) {
        return this.gateway.getRestClient().getGuildService().removeGuildMember(this.getId().asLong(), userId.asLong(), reason);
    }

    public Flux<Ban> getBans() {
        return this.gateway.getRestClient().getGuildService().getGuildBans(this.getId().asLong()).map(data -> new Ban(this.gateway, (BanData)data));
    }

    public Mono<Ban> getBan(Snowflake userId) {
        return this.gateway.getRestClient().getGuildService().getGuildBan(this.getId().asLong(), userId.asLong()).map(data -> new Ban(this.gateway, (BanData)data));
    }

    public Mono<Void> ban(Snowflake userId, Consumer<? super BanQuerySpec> spec) {
        return Mono.defer(() -> {
            BanQuerySpec mutatedSpec = new BanQuerySpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getGuildService().createGuildBan(this.getId().asLong(), userId.asLong(), (Map<String, Object>)mutatedSpec.asRequest(), mutatedSpec.getReason());
        });
    }

    public Mono<Void> unban(Snowflake userId) {
        return this.unban(userId, null);
    }

    public Mono<Void> unban(Snowflake userId, @Nullable String reason) {
        return this.gateway.getRestClient().getGuildService().removeGuildBan(this.getId().asLong(), userId.asLong(), reason);
    }

    public Mono<Integer> getPruneCount(int days) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>(1);
        queryParams.put("days", days);
        return this.gateway.getRestClient().getGuildService().getGuildPruneCount(this.getId().asLong(), queryParams).flatMap(data -> Mono.justOrEmpty(data.pruned()));
    }

    public Mono<Integer> getPruneCount(Consumer<? super GuildPruneCountSpec> spec) {
        return Mono.defer(() -> {
            GuildPruneCountSpec mutatedSpec = new GuildPruneCountSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getGuildService().getGuildPruneCount(this.getId().asLong(), (Multimap<String, Object>)mutatedSpec.asRequest()).flatMap(data -> Mono.justOrEmpty(data.pruned()));
        });
    }

    public Mono<Integer> prune(int days) {
        return this.prune(days, null);
    }

    public Mono<Integer> prune(int days, @Nullable String reason) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>(1);
        queryParams.put("days", days);
        return this.gateway.getRestClient().getGuildService().beginGuildPrune(this.getId().asLong(), queryParams, reason).flatMap(data -> Mono.justOrEmpty(data.pruned()));
    }

    public Mono<Integer> prune(Consumer<? super GuildPruneSpec> spec) {
        return Mono.defer(() -> {
            GuildPruneSpec mutatedSpec = new GuildPruneSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getGuildService().beginGuildPrune(this.getId().asLong(), (Multimap<String, Object>)mutatedSpec.asRequest(), mutatedSpec.getReason()).flatMap(data -> Mono.justOrEmpty(data.pruned()));
        });
    }

    public Mono<Void> leave() {
        return this.gateway.getRestClient().getUserService().leaveGuild(this.getId().asLong());
    }

    public Flux<AuditLogEntry> getAuditLog() {
        return this.getAuditLog(ignored -> {});
    }

    public Flux<AuditLogEntry> getAuditLog(Consumer<? super AuditLogQuerySpec> spec) {
        Function makeRequest = params -> {
            AuditLogQuerySpec mutatedSpec = new AuditLogQuerySpec();
            spec.accept(mutatedSpec);
            params.putAll(mutatedSpec.asRequest());
            return this.gateway.getRestClient().getAuditLogService().getAuditLog(this.getId().asLong(), (Map<String, Object>)params).flux();
        };
        ToLongFunction<AuditLogData> getLastEntryId = response -> {
            List<AuditLogEntryData> entries = response.auditLogEntries();
            return entries.isEmpty() ? Long.MAX_VALUE : Snowflake.asLong(entries.get(entries.size() - 1).id());
        };
        return PaginationUtil.paginateBefore(makeRequest, getLastEntryId, Long.MAX_VALUE, 100).flatMap(log -> Flux.fromIterable(log.auditLogEntries()).map(data -> new AuditLogEntry(this.gateway, (AuditLogEntryData)data)));
    }

    public Flux<Webhook> getWebhooks() {
        return this.gateway.getRestClient().getWebhookService().getGuildWebhooks(this.getId().asLong()).map(data -> new Webhook(this.gateway, (WebhookData)data));
    }

    public Flux<ExtendedInvite> getInvites() {
        return this.gateway.getRestClient().getGuildService().getGuildInvites(this.getId().asLong()).map(data -> new ExtendedInvite(this.gateway, (InviteData)data));
    }

    public Flux<GuildTemplate> getTemplates() {
        return this.gateway.getRestClient().getTemplateService().getTemplates(this.getId().asLong()).map(data -> new GuildTemplate(this.gateway, (TemplateData)data));
    }

    public Mono<String> changeSelfNickname(@Nullable String nickname) {
        return this.gateway.getRestClient().getGuildService().modifyOwnNickname(this.getId().asLong(), NicknameModifyData.builder().nick(Optional.ofNullable(nickname)).build()).handle((data, sink) -> {
            String nick = data.nick().orElse(null);
            if (nick != null) {
                sink.next(nick);
            } else {
                sink.complete();
            }
        });
    }

    public Mono<VoiceConnection> getVoiceConnection() {
        return this.gateway.getVoiceConnectionRegistry().getVoiceConnection(this.getId());
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "Guild{data=" + this.data + '}';
    }

    public static enum NsfwLevel {
        UNKNOWN(-1),
        DEFAULT(0),
        EXPLICIT(1),
        SAFE(2),
        AGE_RESTRICTED(3);

        private final int value;

        private NsfwLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static NsfwLevel of(int value) {
            switch (value) {
                case 0: {
                    return DEFAULT;
                }
                case 1: {
                    return EXPLICIT;
                }
                case 2: {
                    return SAFE;
                }
                case 3: {
                    return AGE_RESTRICTED;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum SystemChannelFlag {
        SUPPRESS_JOIN_NOTIFICATIONS(0),
        SUPPRESS_PREMIUM_SUBSCRIPTIONS(1),
        SUPPRESS_GUILD_REMINDER_NOTIFICATIONS(2);

        private final int value;
        private final int flag;

        private SystemChannelFlag(int value) {
            this.value = value;
            this.flag = 1 << value;
        }

        public int getValue() {
            return this.value;
        }

        public int getFlag() {
            return this.flag;
        }

        public static EnumSet<SystemChannelFlag> of(int value) {
            EnumSet<SystemChannelFlag> flags = EnumSet.noneOf(SystemChannelFlag.class);
            for (SystemChannelFlag flag : SystemChannelFlag.values()) {
                long flagValue = flag.getFlag();
                if ((flagValue & (long)value) != flagValue) continue;
                flags.add(flag);
            }
            return flags;
        }
    }

    public static enum VerificationLevel {
        UNKNOWN(-1),
        NONE(0),
        LOW(1),
        MEDIUM(2),
        HIGH(3),
        VERY_HIGH(4);

        private final int value;

        private VerificationLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static VerificationLevel of(int value) {
            switch (value) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return LOW;
                }
                case 2: {
                    return MEDIUM;
                }
                case 3: {
                    return HIGH;
                }
                case 4: {
                    return VERY_HIGH;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum PremiumTier {
        UNKNOWN(-1),
        NONE(0),
        TIER_1(1),
        TIER_2(2),
        TIER_3(3);

        private final int value;

        private PremiumTier(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static PremiumTier of(int value) {
            switch (value) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return TIER_1;
                }
                case 2: {
                    return TIER_2;
                }
                case 3: {
                    return TIER_3;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum NotificationLevel {
        UNKNOWN(-1),
        ALL_MESSAGES(0),
        ONLY_MENTIONS(1);

        private final int value;

        private NotificationLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static NotificationLevel of(int value) {
            switch (value) {
                case 0: {
                    return ALL_MESSAGES;
                }
                case 1: {
                    return ONLY_MENTIONS;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum MfaLevel {
        UNKNOWN(-1),
        NONE(0),
        ELEVATED(1);

        private final int value;

        private MfaLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MfaLevel of(int value) {
            switch (value) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return ELEVATED;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum ContentFilterLevel {
        UNKNOWN(-1),
        DISABLED(0),
        MEMBERS_WITHOUT_ROLES(1),
        ALL_MEMBERS(2);

        private final int value;

        private ContentFilterLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ContentFilterLevel of(int value) {
            switch (value) {
                case 0: {
                    return DISABLED;
                }
                case 1: {
                    return MEMBERS_WITHOUT_ROLES;
                }
                case 2: {
                    return ALL_MEMBERS;
                }
            }
            return UNKNOWN;
        }
    }
}

