/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.ffmpeg;

import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffmpeg.FFmpeg;
import com.github.kokorin.jaffree.ffmpeg.FFmpegProgress;
import com.github.kokorin.jaffree.ffmpeg.FFmpegResult;
import com.github.kokorin.jaffree.ffmpeg.FFmpegResultFuture;
import com.github.kokorin.jaffree.ffmpeg.Input;
import com.github.kokorin.jaffree.ffmpeg.Output;
import com.github.kokorin.jaffree.ffmpeg.OutputListener;
import com.github.kokorin.jaffree.ffmpeg.ProgressListener;
import com.github.kokorin.jaffree.ffmpeg.UrlInput;
import com.github.kokorin.jaffree.ffmpeg.UrlOutput;
import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.discord.DiscordBot;
import com.gmail.berndivader.streamserver.ffmpeg.FFProbePacket;
import com.gmail.berndivader.streamserver.mysql.GetNextScheduled;
import com.gmail.berndivader.streamserver.mysql.UpdateCurrent;
import com.gmail.berndivader.streamserver.term.ANSI;
import com.gmail.berndivader.streamserver.youtube.BroadcastStatus;
import com.gmail.berndivader.streamserver.youtube.PrivacyStatus;
import com.gmail.berndivader.streamserver.youtube.Youtube;
import com.gmail.berndivader.streamserver.youtube.packets.EmptyPacket;
import com.gmail.berndivader.streamserver.youtube.packets.ErrorPacket;
import com.gmail.berndivader.streamserver.youtube.packets.LiveBroadcastPacket;
import com.gmail.berndivader.streamserver.youtube.packets.LiveStreamPacket;
import com.gmail.berndivader.streamserver.youtube.packets.Packet;
import com.gmail.berndivader.streamserver.youtube.packets.UnknownPacket;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

public final class BroadcastRunner
extends TimerTask {
    boolean stop;
    private static FFmpegProgress progress;
    private static FFProbePacket probePacket;
    private static String message;
    private static File playing;
    private static FFmpegResultFuture ffmpeg;
    public static AtomicInteger index;
    private static long counter;
    private static CopyOnWriteArrayList<File> files;
    private static CopyOnWriteArrayList<File> customs;
    public static BroadcastRunner instance;

    public static synchronized FFmpegProgress progress() {
        return progress;
    }

    public static synchronized void progress(FFmpegProgress progress) {
        BroadcastRunner.progress = progress;
    }

    public static synchronized FFProbePacket probePacket() {
        return probePacket;
    }

    public static synchronized void probePacket(FFProbePacket packet) {
        probePacket = packet;
    }

    public static synchronized String message() {
        return message;
    }

    public static synchronized void message(String message) {
        BroadcastRunner.message = message;
    }

    public static synchronized File playing() {
        return playing;
    }

    public static synchronized void playing(File playing) {
        BroadcastRunner.playing = playing;
    }

    public static synchronized FFmpegResultFuture ffmpeg() {
        return ffmpeg;
    }

    public static synchronized void ffmpeg(FFmpegResultFuture ffmpeg) {
        BroadcastRunner.ffmpeg = ffmpeg;
    }

    public BroadcastRunner() {
        ANSI.print("[YELLOW]Starting BroadcastRunner...");
        this.stop = false;
        BroadcastRunner.refreshFilelist();
        BroadcastRunner.shuffleFilelist();
        index.set(0);
        counter = 0L;
        BroadcastRunner.startStream();
        Helper.SCHEDULED_EXECUTOR.scheduleAtFixedRate(this, 0L, 1L, TimeUnit.SECONDS);
        ANSI.println("[GREEN]DONE![RESET]");
    }

    public void stop() throws InterruptedException {
        ANSI.print("[YELLOW]Stopping BroadcastRunner...");
        this.stop = true;
        if (!(BroadcastRunner.ffmpeg() == null || BroadcastRunner.ffmpeg().isCancelled() && BroadcastRunner.ffmpeg().isDone())) {
            ANSI.print("[YELLOW][Stop broadcasting...");
            FFmpegResult result = BroadcastRunner.stopStream();
            if (result != null) {
                ANSI.print("[GREEN]DONE!]...[RESET]");
            } else {
                ANSI.printWarn("Problem occured while stopping the BroadcastRunner.");
            }
        }
        ANSI.println("[GREEN]DONE![RESET]");
    }

    @Override
    public void run() {
        if (!this.stop) {
            ++counter;
            if (BroadcastRunner.ffmpeg() == null || BroadcastRunner.ffmpeg().isCancelled() || BroadcastRunner.ffmpeg().isDone()) {
                BroadcastRunner.startStream();
            }
            if (counter > 3599L) {
                String priv = Config.BROADCAST_DEFAULT_PRIVACY.toUpperCase();
                PrivacyStatus privacy = PrivacyStatus.isEnum(priv) ? PrivacyStatus.valueOf(priv) : PrivacyStatus.UNLISTED;
                BroadcastRunner.checkOrReInitiateLiveBroadcast(Config.BROADCAST_DEFAULT_TITLE, Config.BROADCAST_DEFAULT_DESCRIPTION, privacy);
                counter = 0L;
            }
        }
    }

    public static synchronized void checkOrReInitiateLiveBroadcast(String title, String description, PrivacyStatus privacy) {
        if (Config.DEBUG.booleanValue()) {
            ANSI.println("[BLUE]Test if broadcast is still live on Youtube...[RESET]");
        }
        try {
            Packet packet = Youtube.getLiveBroadcastWithTries(BroadcastStatus.active, 2);
            if (packet instanceof EmptyPacket) {
                ANSI.println("[ORANGE]Try to reinstall livebroadcast on Youtube...");
                packet = Youtube.getDefaultLiveStream().get(15L, TimeUnit.SECONDS);
                if (packet instanceof LiveStreamPacket) {
                    ANSI.println("[GREEN]Got livestream resource identified by STREAM_KEY...");
                    LiveStreamPacket live = (LiveStreamPacket)packet;
                    packet = Youtube.insertLiveBroadcast(title, description, privacy).get(15L, TimeUnit.SECONDS);
                    if (packet instanceof LiveBroadcastPacket) {
                        ANSI.println("[GREEN]Installed a new autostart livebroadcast resource on Youtube...");
                        LiveBroadcastPacket broadcast = (LiveBroadcastPacket)packet;
                        packet = Youtube.bindBroadcastToStream(broadcast.id, live.id).get(15L, TimeUnit.SECONDS);
                        if (packet instanceof LiveBroadcastPacket) {
                            ANSI.println("[GREEN]Merged the default livestream with the new livebroadcast together...");
                            broadcast = (LiveBroadcastPacket)packet;
                            if (Config.DEBUG.booleanValue()) {
                                ANSI.println(broadcast.source().toString());
                            }
                            ANSI.println("[BLUE]The new livestream should go live in a few seconds.[PROMPT]");
                        }
                    }
                }
                if (packet instanceof ErrorPacket) {
                    ANSI.println("[RED]FAILED!");
                    ErrorPacket error = (ErrorPacket)packet;
                    error.printSimple();
                } else if (packet instanceof EmptyPacket) {
                    ANSI.println("[RED]FAILED!");
                    ANSI.printWarn("Received EmptyPacket!");
                    if (Config.DEBUG.booleanValue()) {
                        ANSI.println(packet.source().toString());
                    }
                } else if (packet instanceof UnknownPacket) {
                    ANSI.println("[RED]FAILED!");
                    ANSI.printWarn("Unknown packet received!");
                    if (Config.DEBUG.booleanValue()) {
                        ANSI.println(packet.source().toString());
                    }
                }
            } else if (packet instanceof ErrorPacket) {
                ErrorPacket error = (ErrorPacket)packet;
                error.printSimple();
            } else if (packet instanceof LiveBroadcastPacket) {
                LiveBroadcastPacket broadcast = (LiveBroadcastPacket)packet;
                ANSI.println("Broadcast is live on Youtube.");
                if (Config.DEBUG.booleanValue()) {
                    ANSI.println(broadcast.source().toString());
                }
            }
        }
        catch (Exception e) {
            ANSI.printErr("Failed to restart live broadcast on Youtube.", e);
        }
    }

    private static synchronized void startStream() {
        GetNextScheduled scheduled = new GetNextScheduled();
        try {
            String name = scheduled.future.get(20L, TimeUnit.SECONDS);
            if (name != null) {
                BroadcastRunner.getFileByName(name.toLowerCase()).ifPresent(BroadcastRunner::createStream);
                return;
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            ANSI.printErr("Get next scheduled file failed.", e);
        }
        BroadcastRunner.createStream(BroadcastRunner.getFiles()[index.get()]);
        index.set((index.get() + 1) % BroadcastRunner.getFiles().length);
    }

    private static synchronized void createStream(File file) {
        int pos;
        String path = file.getAbsolutePath();
        BroadcastRunner.probePacket(FFProbePacket.build(file));
        String title = "";
        title = BroadcastRunner.probePacket().isSet(BroadcastRunner.probePacket().tags.title) ? BroadcastRunner.probePacket().tags.title : ((pos = file.getName().lastIndexOf(".")) > 0 ? file.getName().substring(0, pos) : file.getName());
        String info = BroadcastRunner.probePacket().tags.artist + ":" + Helper.stringFloatToTime(BroadcastRunner.probePacket().duration) + ":" + BroadcastRunner.probePacket().tags.description;
        new UpdateCurrent(title, info);
        if (Config.DISCORD_BOT_START.booleanValue() && DiscordBot.instance != null) {
            DiscordBot.instance.updateStatus(title);
        }
        ANSI.println("[BLUE]Now playing: " + BroadcastRunner.probePacket().tags.title + ":" + BroadcastRunner.probePacket().tags.artist + ":" + BroadcastRunner.probePacket().tags.date + ":" + BroadcastRunner.probePacket().tags.comment + "[RESET]");
        ANSI.prompt();
        BroadcastRunner.ffmpeg(FFmpeg.atPath().addInput((Input)UrlInput.fromUrl(path).addArgument("-re")).addOutput((Output)((UrlOutput)((UrlOutput)((UrlOutput)((UrlOutput)((UrlOutput)((UrlOutput)((UrlOutput)UrlOutput.toUrl(Config.STREAM_URL + "/" + Config.STREAM_KEY).setCodec(StreamType.VIDEO, "copy")).addArguments("-b:v", "2M")).setCodec(StreamType.AUDIO, "copy")).addArguments("-strict", "-2")).addArguments("-flags", "+global_header")).addArguments("-bsf:a", "aac_adtstoasc")).addArguments("-bufsize", "2100k")).setFormat("flv")).setOutputListener(new OutputListener(){

            @Override
            public void onOutput(String message) {
                BroadcastRunner.message(message);
            }
        }).setProgressListener(new ProgressListener(){

            @Override
            public void onProgress(FFmpegProgress progress) {
                BroadcastRunner.progress(progress);
            }
        }).setOverwriteOutput(true).executeAsync());
        if (BroadcastRunner.ffmpeg() != null && !BroadcastRunner.ffmpeg().isDone() && !BroadcastRunner.ffmpeg().isCancelled()) {
            BroadcastRunner.playing(file);
        }
    }

    public static boolean isStreaming() {
        return BroadcastRunner.ffmpeg() != null && !BroadcastRunner.ffmpeg().isCancelled() && !BroadcastRunner.ffmpeg().isDone();
    }

    public static void playFile(File file) {
        if (BroadcastRunner.isStreaming()) {
            BroadcastRunner.stopStream();
            BroadcastRunner.createStream(file);
        }
    }

    public static void playPosition(int idx) {
        index.set(idx);
        if (BroadcastRunner.isStreaming()) {
            BroadcastRunner.stopStream();
        }
    }

    public static void restart() {
        if (BroadcastRunner.isStreaming()) {
            BroadcastRunner.stopStream();
        }
        BroadcastRunner.createStream(BroadcastRunner.playing());
    }

    public static void next() {
        if (BroadcastRunner.isStreaming()) {
            BroadcastRunner.stopStream();
        }
    }

    public static void previous() {
        if (BroadcastRunner.isStreaming()) {
            index.set((index.get() - 2 + BroadcastRunner.getFiles().length) % BroadcastRunner.getFiles().length);
            BroadcastRunner.stopStream();
        }
    }

    private static FFmpegResult stopStream() {
        if (BroadcastRunner.ffmpeg() != null && !BroadcastRunner.ffmpeg().isCancelled() && !BroadcastRunner.ffmpeg().isDone()) {
            BroadcastRunner.ffmpeg().graceStop();
            try {
                return BroadcastRunner.ffmpeg().get(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                ANSI.printErr("Failed to stop broadcast task.", e);
            }
        }
        return null;
    }

    public static File[] getFiles() {
        return (File[])files.toArray(File[]::new);
    }

    public static Optional<File> getFileByName(String name) {
        File file = null;
        int pos = BroadcastRunner.getFilePosition(name);
        if (pos != -1) {
            file = files.get(pos);
        } else {
            pos = BroadcastRunner.getCustomFilePosition(name);
            if (pos != -1) {
                file = customs.get(pos);
            }
        }
        if (file != null && file.exists() && file.isFile() && file.canRead()) {
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public static int getFilePosition(String name) {
        if (!name.isEmpty()) {
            int size = files.size();
            for (int i = 0; i < size; ++i) {
                if (!files.get(i).getName().equalsIgnoreCase(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getCustomFilePosition(String name) {
        if (!name.isEmpty()) {
            int size = customs.size();
            for (int i = 0; i < size; ++i) {
                if (!customs.get(i).getName().equalsIgnoreCase(name)) continue;
                return i;
            }
        }
        return -1;
    }

    public static List<String> getFilesAsList(String r) {
        String regex = r.contains("*") ? r.replaceAll("\\*", "(.*)") : "(.*)" + r + "(.*)";
        ArrayList<String> list = new ArrayList<String>();
        Stream.concat(files.stream(), customs.stream()).map(File::getName).filter(name -> {
            try {
                return name.toLowerCase().matches(regex);
            }
            catch (Exception e) {
                if (Config.DEBUG.booleanValue()) {
                    ANSI.printErr("getFilelistAsList method failed.", e);
                }
                return false;
            }
        }).forEach(list::add);
        return list;
    }

    public static String getFilesAsString(String r) {
        AtomicInteger count = new AtomicInteger(0);
        StringBuilder playlist = new StringBuilder();
        String regex = r.contains("*") ? r.replaceAll("\\*", "(.*)") : "(.*)" + r + "(.*)";
        Stream.concat(files.stream(), customs.stream()).map(File::getName).filter(name -> {
            try {
                return name.toLowerCase().matches(regex);
            }
            catch (Exception e) {
                if (Config.DEBUG.booleanValue()) {
                    ANSI.printErr("getFilelistAsString method failed.", e);
                }
                return false;
            }
        }).forEach(name -> {
            playlist.append(name + "\n");
            count.incrementAndGet();
        });
        playlist.append("\nThere are ").append(count).append(" matches for ").append(regex);
        return playlist.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shuffleFilelist() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        CopyOnWriteArrayList<File> copyOnWriteArrayList = files;
        synchronized (copyOnWriteArrayList) {
            int size = files.size();
            for (int i1 = size - 1; i1 > 0; --i1) {
                int index = ((Random)random).nextInt(i1 + 1);
                File a = files.get(index);
                files.set(index, files.get(i1));
                files.set(i1, a);
            }
        }
    }

    private static File[] getFiles(File directory, FileFilter filter) {
        if (directory.exists()) {
            if (directory.isDirectory()) {
                return directory.listFiles(filter);
            }
            if (directory.isFile()) {
                return new File[]{directory};
            }
        }
        return new File[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshFilelist() {
        File playlistDir = new File(Config.working_dir, Config.PLAYLIST_PATH);
        File customDir = new File(Config.working_dir, Config.PLAYLIST_PATH_CUSTOM);
        FileFilter filter = pathName -> pathName.getAbsolutePath().toLowerCase().endsWith(".mp4");
        Serializable serializable = files;
        synchronized (serializable) {
            files = new CopyOnWriteArrayList<File>(Arrays.asList(BroadcastRunner.getFiles(playlistDir, filter)));
        }
        serializable = customDir;
        synchronized (serializable) {
            customs = new CopyOnWriteArrayList<File>(Arrays.asList(BroadcastRunner.getFiles(customDir, filter)));
        }
    }

    static {
        index = new AtomicInteger();
        files = new CopyOnWriteArrayList();
        customs = new CopyOnWriteArrayList();
    }
}

