/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.FollowedChannel;
import discord4j.core.object.entity.channel.BaseTopLevelGuildChannel;
import discord4j.core.object.entity.channel.TopLevelGuildMessageChannel;
import discord4j.core.spec.NewsChannelEditMono;
import discord4j.core.spec.NewsChannelEditSpec;
import discord4j.core.spec.legacy.LegacyNewsChannelEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.FollowedChannelData;
import discord4j.discordjson.json.NewsChannelFollowRequest;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

public final class NewsChannel
extends BaseTopLevelGuildChannel
implements TopLevelGuildMessageChannel {
    public NewsChannel(GatewayDiscordClient gateway, ChannelData data) {
        super(gateway, data);
    }

    @Deprecated
    public Mono<NewsChannel> edit(Consumer<? super LegacyNewsChannelEditSpec> spec) {
        return Mono.defer(() -> {
            LegacyNewsChannelEditSpec mutatedSpec = new LegacyNewsChannelEditSpec();
            spec.accept(mutatedSpec);
            return this.getClient().getRestClient().getChannelService().modifyChannel(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> EntityUtil.getChannel(this.getClient(), data)).cast(NewsChannel.class);
    }

    public NewsChannelEditMono edit() {
        return NewsChannelEditMono.of(this);
    }

    public Mono<NewsChannel> edit(NewsChannelEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getClient().getRestClient().getChannelService().modifyChannel(this.getId().asLong(), spec.asRequest(), spec.reason())).map(data -> EntityUtil.getChannel(this.getClient(), data)).cast(NewsChannel.class);
    }

    public Mono<FollowedChannel> follow(Snowflake targetChannelId) {
        return this.getClient().getRestClient().getChannelService().followNewsChannel(this.getId().asLong(), NewsChannelFollowRequest.builder().webhookChannelId(targetChannelId.asString()).build()).map(data -> new FollowedChannel(this.getClient(), (FollowedChannelData)data));
    }

    @Override
    public String toString() {
        return "NewsChannel{} " + super.toString();
    }
}

