/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ApplicationCommandData;
import discord4j.discordjson.json.gateway.ApplicationCommandUpdate;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ApplicationCommandUpdate", generator="Immutables")
public final class ImmutableApplicationCommandUpdate
implements ApplicationCommandUpdate {
    private final long guildId_value;
    private final ApplicationCommandData command;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableApplicationCommandUpdate(Id guildId, ApplicationCommandData command) {
        Id guildId$impl = guildId;
        this.command = Objects.requireNonNull(command, "command");
        this.guildId_value = guildId$impl.asLong();
        this.initShim = null;
    }

    private ImmutableApplicationCommandUpdate(ImmutableApplicationCommandUpdate original, Id guildId, ApplicationCommandData command) {
        Id guildId$impl = guildId;
        this.command = command;
        this.guildId_value = guildId$impl.asLong();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of(this.guildId_value);
    }

    @Override
    @JsonProperty(value="command")
    @JsonUnwrapped
    public ApplicationCommandData command() {
        return this.command;
    }

    public ImmutableApplicationCommandUpdate withGuildId(long value) {
        Id newValue = Id.of(value);
        return new ImmutableApplicationCommandUpdate(this, newValue, this.command);
    }

    public ImmutableApplicationCommandUpdate withGuildId(String value) {
        Id newValue = Id.of(value);
        return new ImmutableApplicationCommandUpdate(this, newValue, this.command);
    }

    public final ImmutableApplicationCommandUpdate withCommand(ApplicationCommandData value) {
        if (this.command == value) {
            return this;
        }
        ApplicationCommandData newValue = Objects.requireNonNull(value, "command");
        return new ImmutableApplicationCommandUpdate(this, this.guildId(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApplicationCommandUpdate && this.equalTo(0, (ImmutableApplicationCommandUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableApplicationCommandUpdate another) {
        return Objects.equals(this.guildId_value, another.guildId_value) && this.command.equals(another.command);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.guildId_value);
        h2 += (h2 << 5) + this.command.hashCode();
        return h2;
    }

    public String toString() {
        return "ApplicationCommandUpdate{guildId=" + Objects.toString(this.guildId_value) + ", command=" + this.command + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableApplicationCommandUpdate fromJson(Json json) {
        Builder builder = ImmutableApplicationCommandUpdate.builder();
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.command != null) {
            builder.command(json.command);
        }
        return builder.build();
    }

    public static ImmutableApplicationCommandUpdate of(Id guildId, ApplicationCommandData command) {
        return new ImmutableApplicationCommandUpdate(guildId, command);
    }

    public static ImmutableApplicationCommandUpdate copyOf(ApplicationCommandUpdate instance) {
        if (instance instanceof ImmutableApplicationCommandUpdate) {
            return (ImmutableApplicationCommandUpdate)instance;
        }
        return ImmutableApplicationCommandUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ApplicationCommandUpdate", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_COMMAND = 1L;
        private long initBits = 1L;
        private Id guildId_id = null;
        private ApplicationCommandData command;

        private Builder() {
        }

        public final Builder from(ApplicationCommandUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.guildId(instance.guildId());
            this.command(instance.command());
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of(value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of(value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        @JsonProperty(value="command")
        @JsonUnwrapped
        public final Builder command(ApplicationCommandData command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableApplicationCommandUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableApplicationCommandUpdate(null, this.guildId_build(), this.command);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("command");
            }
            return "Cannot build ApplicationCommandUpdate, some of required attributes are not set " + attributes;
        }

        private Id guildId_build() {
            return this.guildId_id;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ApplicationCommandUpdate", generator="Immutables")
    static final class Json
    implements ApplicationCommandUpdate {
        Id guildId;
        ApplicationCommandData command;

        Json() {
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="command")
        @JsonUnwrapped
        public void setCommand(ApplicationCommandData command) {
            this.command = command;
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ApplicationCommandData command() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ApplicationCommandUpdate", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ApplicationCommandUpdate, attribute initializers form cycle " + attributes;
        }
    }
}

