/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.command.ResolvedChannel;
import discord4j.core.object.command.ResolvedMember;
import discord4j.core.object.entity.Attachment;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.discordjson.json.ApplicationCommandInteractionResolvedData;
import discord4j.discordjson.json.AttachmentData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.ResolvedChannelData;
import discord4j.discordjson.json.ResolvedMemberData;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.UserData;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@Experimental
public class ApplicationCommandInteractionResolved
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final ApplicationCommandInteractionResolvedData data;
    @Nullable
    private final Long guildId;

    public ApplicationCommandInteractionResolved(GatewayDiscordClient gateway, ApplicationCommandInteractionResolvedData data, @Nullable Long guildId) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
        this.guildId = guildId;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public ApplicationCommandInteractionResolvedData getData() {
        return this.data;
    }

    public Optional<ResolvedChannel> getChannel(Snowflake channelId) {
        return this.data.channels().toOptional().map(channels -> (ResolvedChannelData)channels.get(channelId.asString())).map(data -> new ResolvedChannel(this.gateway, (ResolvedChannelData)data));
    }

    public Map<Snowflake, ResolvedChannel> getChannels() {
        return this.data.channels().toOptional().map(map -> map.entrySet().stream().map(entry -> Tuples.of(Snowflake.of((String)entry.getKey()), new ResolvedChannel(this.gateway, (ResolvedChannelData)entry.getValue()))).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2))).orElseGet(Collections::emptyMap);
    }

    public Optional<User> getUser(Snowflake userId) {
        return this.data.users().toOptional().map(users -> (UserData)users.get(userId.asString())).map(data -> new User(this.gateway, (UserData)data));
    }

    public Map<Snowflake, User> getUsers() {
        return this.data.users().toOptional().map(map -> map.entrySet().stream().map(entry -> Tuples.of(Snowflake.of((String)entry.getKey()), new User(this.gateway, (UserData)entry.getValue()))).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2))).orElseGet(Collections::emptyMap);
    }

    public Optional<ResolvedMember> getMember(Snowflake memberId) {
        return this.data.members().toOptional().map(members -> (ResolvedMemberData)members.get(memberId.asString())).map(memberData -> new ResolvedMember(this.gateway, (ResolvedMemberData)memberData, this.getUser(memberId).map(User::getUserData).orElseThrow(IllegalStateException::new), Objects.requireNonNull(this.guildId)));
    }

    public Map<Snowflake, ResolvedMember> getMembers() {
        return this.data.members().toOptional().map(map -> map.entrySet().stream().map(entry -> {
            Snowflake id = Snowflake.of((String)entry.getKey());
            return Tuples.of(id, new ResolvedMember(this.gateway, (ResolvedMemberData)entry.getValue(), this.getUser(id).map(User::getUserData).orElseThrow(IllegalStateException::new), Objects.requireNonNull(this.guildId)));
        }).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2))).orElseGet(Collections::emptyMap);
    }

    public Optional<Role> getRole(Snowflake roleId) {
        return this.data.roles().toOptional().map(roles -> (RoleData)roles.get(roleId.asString())).map(data -> new Role(this.gateway, (RoleData)data, Objects.requireNonNull(this.guildId)));
    }

    public Map<Snowflake, Role> getRoles() {
        return this.data.roles().toOptional().map(map -> map.entrySet().stream().map(entry -> Tuples.of(Snowflake.of((String)entry.getKey()), new Role(this.gateway, (RoleData)entry.getValue(), Objects.requireNonNull(this.guildId)))).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2))).orElseGet(Collections::emptyMap);
    }

    public Optional<Message> getMessage(Snowflake messageId) {
        return this.data.messages().toOptional().map(messages -> (MessageData)messages.get(messageId.asString())).map(data -> new Message(this.gateway, (MessageData)data));
    }

    public Map<Snowflake, Message> getMessages() {
        return this.data.messages().toOptional().map(map -> map.entrySet().stream().map(entry -> Tuples.of(Snowflake.of((String)entry.getKey()), new Message(this.gateway, (MessageData)entry.getValue()))).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2))).orElseGet(Collections::emptyMap);
    }

    public Optional<Attachment> getAttachment(Snowflake attachmentId) {
        return this.data.attachments().toOptional().map(attachments -> (AttachmentData)attachments.get(attachmentId.asString())).map(data -> new Attachment(this.gateway, (AttachmentData)data));
    }

    public Map<Snowflake, Attachment> getAttachments() {
        return this.data.attachments().toOptional().map(map -> map.entrySet().stream().map(entry -> Tuples.of(Snowflake.of((String)entry.getKey()), new Attachment(this.gateway, (AttachmentData)entry.getValue()))).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2))).orElseGet(Collections::emptyMap);
    }

    public String toString() {
        return "ApplicationCommandInteractionResolved{data=" + this.data + ", guildId=" + this.guildId + '}';
    }
}

