/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.spec.AutoModRuleCreateSpecGenerator;
import discord4j.discordjson.json.AutoModActionData;
import discord4j.discordjson.json.AutoModActionMetaData;
import discord4j.discordjson.json.AutoModTriggerMetaData;
import discord4j.discordjson.json.ImmutableAutoModActionData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="AutoModRuleCreateSpecGenerator", generator="Immutables")
public final class AutoModRuleCreateSpec
implements AutoModRuleCreateSpecGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final int eventType;
    private final int triggerType;
    private final AutoModTriggerMetaData triggerMetaData_value;
    private final boolean triggerMetaData_absent;
    private final List<AutoModActionData> actions;
    private final Boolean enabled_value;
    private final boolean enabled_absent;
    private final List<Snowflake> exemptRoles_value;
    private final boolean exemptRoles_absent;
    private final List<Snowflake> exemptChannels_value;
    private final boolean exemptChannels_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private AutoModRuleCreateSpec(String name, int eventType, int triggerType) {
        this.name = Objects.requireNonNull(name, "name");
        this.eventType = eventType;
        this.triggerType = triggerType;
        this.reason = null;
        Possible triggerMetaData$impl = Possible.absent();
        Possible enabled$impl = Possible.absent();
        Possible exemptRoles$impl = Possible.absent();
        Possible exemptChannels$impl = Possible.absent();
        this.triggerMetaData_value = triggerMetaData$impl.toOptional().orElse(null);
        this.triggerMetaData_absent = triggerMetaData$impl.isAbsent();
        this.enabled_value = enabled$impl.toOptional().orElse(null);
        this.enabled_absent = enabled$impl.isAbsent();
        this.exemptRoles_value = exemptRoles$impl.toOptional().orElse(null);
        this.exemptRoles_absent = exemptRoles$impl.isAbsent();
        this.exemptChannels_value = exemptChannels$impl.toOptional().orElse(null);
        this.exemptChannels_absent = exemptChannels$impl.isAbsent();
        this.actions = this.initShim.actions();
        this.initShim = null;
    }

    private AutoModRuleCreateSpec(Builder builder) {
        this.reason = builder.reason;
        this.name = builder.name;
        this.eventType = builder.eventType;
        this.triggerType = builder.triggerType;
        Possible triggerMetaData$impl = builder.triggerMetaData_build();
        Possible enabled$impl = builder.enabled_build();
        Possible exemptRoles$impl = builder.exemptRoles_build();
        Possible exemptChannels$impl = builder.exemptChannels_build();
        if (builder.actionsIsSet()) {
            this.initShim.actions(AutoModRuleCreateSpec.createUnmodifiableList(true, builder.actions));
        }
        this.triggerMetaData_value = triggerMetaData$impl.toOptional().orElse(null);
        this.triggerMetaData_absent = triggerMetaData$impl.isAbsent();
        this.enabled_value = enabled$impl.toOptional().orElse(null);
        this.enabled_absent = enabled$impl.isAbsent();
        this.exemptRoles_value = exemptRoles$impl.toOptional().orElse(null);
        this.exemptRoles_absent = exemptRoles$impl.isAbsent();
        this.exemptChannels_value = exemptChannels$impl.toOptional().orElse(null);
        this.exemptChannels_absent = exemptChannels$impl.isAbsent();
        this.actions = this.initShim.actions();
        this.initShim = null;
    }

    private AutoModRuleCreateSpec(@Nullable String reason, String name, int eventType, int triggerType, Possible<AutoModTriggerMetaData> triggerMetaData, List<AutoModActionData> actions, Possible<Boolean> enabled, Possible<List<Snowflake>> exemptRoles, Possible<List<Snowflake>> exemptChannels) {
        this.reason = reason;
        this.name = name;
        this.eventType = eventType;
        this.triggerType = triggerType;
        Possible<AutoModTriggerMetaData> triggerMetaData$impl = triggerMetaData;
        this.initShim.actions(actions);
        Possible<Boolean> enabled$impl = enabled;
        Possible<List<Snowflake>> exemptRoles$impl = exemptRoles;
        Possible<List<Snowflake>> exemptChannels$impl = exemptChannels;
        this.triggerMetaData_value = triggerMetaData$impl.toOptional().orElse(null);
        this.triggerMetaData_absent = triggerMetaData$impl.isAbsent();
        this.enabled_value = enabled$impl.toOptional().orElse(null);
        this.enabled_absent = enabled$impl.isAbsent();
        this.exemptRoles_value = exemptRoles$impl.toOptional().orElse(null);
        this.exemptRoles_absent = exemptRoles$impl.isAbsent();
        this.exemptChannels_value = exemptChannels$impl.toOptional().orElse(null);
        this.exemptChannels_absent = exemptChannels$impl.isAbsent();
        this.actions = this.initShim.actions();
        this.initShim = null;
    }

    private List<AutoModActionData> actionsInitialize() {
        return AutoModRuleCreateSpecGenerator.super.actions();
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int eventType() {
        return this.eventType;
    }

    @Override
    public int triggerType() {
        return this.triggerType;
    }

    @Override
    public Possible<AutoModTriggerMetaData> triggerMetaData() {
        return this.triggerMetaData_absent ? Possible.absent() : Possible.of(this.triggerMetaData_value);
    }

    @Override
    public List<AutoModActionData> actions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.actions() : this.actions;
    }

    @Override
    public Possible<Boolean> enabled() {
        return this.enabled_absent ? Possible.absent() : Possible.of(this.enabled_value);
    }

    @Override
    public Possible<List<Snowflake>> exemptRoles() {
        return this.exemptRoles_absent ? Possible.absent() : Possible.of(this.exemptRoles_value);
    }

    @Override
    public Possible<List<Snowflake>> exemptChannels() {
        return this.exemptChannels_absent ? Possible.absent() : Possible.of(this.exemptChannels_value);
    }

    public final AutoModRuleCreateSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new AutoModRuleCreateSpec(value, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public final AutoModRuleCreateSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new AutoModRuleCreateSpec(this.reason, newValue, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public final AutoModRuleCreateSpec withEventType(int value) {
        if (this.eventType == value) {
            return this;
        }
        return new AutoModRuleCreateSpec(this.reason, this.name, value, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public final AutoModRuleCreateSpec withTriggerType(int value) {
        if (this.triggerType == value) {
            return this;
        }
        return new AutoModRuleCreateSpec(this.reason, this.name, this.eventType, value, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleCreateSpec withTriggerMetaData(Possible<AutoModTriggerMetaData> value) {
        Possible<AutoModTriggerMetaData> newValue = Objects.requireNonNull(value);
        return new AutoModRuleCreateSpec(this.reason, this.name, this.eventType, this.triggerType, newValue, this.actions, this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleCreateSpec withTriggerMetaData(AutoModTriggerMetaData value) {
        Possible<AutoModTriggerMetaData> newValue = Possible.of(value);
        return new AutoModRuleCreateSpec(this.reason, this.name, this.eventType, this.triggerType, newValue, this.actions, this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public final AutoModRuleCreateSpec withActions(AutoModActionData ... elements) {
        List<AutoModActionData> newValue = AutoModRuleCreateSpec.createUnmodifiableList(false, AutoModRuleCreateSpec.createSafeList(Arrays.asList(elements), true, false));
        return new AutoModRuleCreateSpec(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), newValue, this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public final AutoModRuleCreateSpec withActions(Iterable<? extends AutoModActionData> elements) {
        if (this.actions == elements) {
            return this;
        }
        List<AutoModActionData> newValue = AutoModRuleCreateSpec.createUnmodifiableList(false, AutoModRuleCreateSpec.createSafeList(elements, true, false));
        return new AutoModRuleCreateSpec(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), newValue, this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleCreateSpec withEnabled(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new AutoModRuleCreateSpec(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, newValue, this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleCreateSpec withEnabled(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return new AutoModRuleCreateSpec(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, newValue, this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleCreateSpec withExemptRoles(Possible<? extends List<? extends Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return new AutoModRuleCreateSpec(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), newValue, this.exemptChannels());
    }

    public AutoModRuleCreateSpec withExemptRoles(Iterable<? extends Snowflake> elements) {
        Possible<List<Snowflake>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new AutoModRuleCreateSpec(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), newValue, this.exemptChannels());
    }

    @SafeVarargs
    public final AutoModRuleCreateSpec withExemptRoles(Snowflake ... elements) {
        Possible<List<Snowflake>> newValue = Possible.of(Arrays.asList(elements));
        return new AutoModRuleCreateSpec(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), newValue, this.exemptChannels());
    }

    public AutoModRuleCreateSpec withExemptChannels(Possible<? extends List<? extends Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return new AutoModRuleCreateSpec(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), newValue);
    }

    public AutoModRuleCreateSpec withExemptChannels(Iterable<? extends Snowflake> elements) {
        Possible<List<Snowflake>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new AutoModRuleCreateSpec(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), newValue);
    }

    @SafeVarargs
    public final AutoModRuleCreateSpec withExemptChannels(Snowflake ... elements) {
        Possible<List<Snowflake>> newValue = Possible.of(Arrays.asList(elements));
        return new AutoModRuleCreateSpec(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AutoModRuleCreateSpec && this.equalTo(0, (AutoModRuleCreateSpec)another);
    }

    private boolean equalTo(int synthetic, AutoModRuleCreateSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.eventType == another.eventType && this.triggerType == another.triggerType && this.triggerMetaData().equals(another.triggerMetaData()) && this.actions.equals(another.actions) && this.enabled().equals(another.enabled()) && Objects.equals(this.exemptRoles_value, another.exemptRoles_value) && Objects.equals(this.exemptChannels_value, another.exemptChannels_value);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.eventType;
        h2 += (h2 << 5) + this.triggerType;
        h2 += (h2 << 5) + this.triggerMetaData().hashCode();
        h2 += (h2 << 5) + this.actions.hashCode();
        h2 += (h2 << 5) + this.enabled().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.exemptRoles_value);
        h2 += (h2 << 5) + Objects.hashCode(this.exemptChannels_value);
        return h2;
    }

    public String toString() {
        return "AutoModRuleCreateSpec{reason=" + this.reason + ", name=" + this.name + ", eventType=" + this.eventType + ", triggerType=" + this.triggerType + ", triggerMetaData=" + this.triggerMetaData().toString() + ", actions=" + this.actions + ", enabled=" + this.enabled().toString() + ", exemptRoles=" + Objects.toString(this.exemptRoles_value) + ", exemptChannels=" + Objects.toString(this.exemptChannels_value) + "}";
    }

    public static AutoModRuleCreateSpec of(String name, int eventType, int triggerType) {
        return new AutoModRuleCreateSpec(name, eventType, triggerType);
    }

    static AutoModRuleCreateSpec copyOf(AutoModRuleCreateSpecGenerator instance) {
        if (instance instanceof AutoModRuleCreateSpec) {
            return (AutoModRuleCreateSpec)instance;
        }
        return AutoModRuleCreateSpec.builder().from(instance).build();
    }

    public boolean isTriggerMetaDataPresent() {
        return !this.triggerMetaData_absent;
    }

    public AutoModTriggerMetaData triggerMetaDataOrElse(AutoModTriggerMetaData defaultValue) {
        return !this.triggerMetaData_absent ? this.triggerMetaData_value : defaultValue;
    }

    public boolean isEnabledPresent() {
        return !this.enabled_absent;
    }

    public Boolean enabledOrElse(Boolean defaultValue) {
        return !this.enabled_absent ? this.enabled_value : defaultValue;
    }

    public boolean isExemptRolesPresent() {
        return !this.exemptRoles_absent;
    }

    public List<Snowflake> exemptRolesOrElse(List<Snowflake> defaultValue) {
        return !this.exemptRoles_absent ? this.exemptRoles_value : defaultValue;
    }

    public boolean isExemptChannelsPresent() {
        return !this.exemptChannels_absent;
    }

    public List<Snowflake> exemptChannelsOrElse(List<Snowflake> defaultValue) {
        return !this.exemptChannels_absent ? this.exemptChannels_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AutoModRuleCreateSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_EVENT_TYPE = 2L;
        private static final long INIT_BIT_TRIGGER_TYPE = 4L;
        private static final long OPT_BIT_ACTIONS = 1L;
        private long initBits = 7L;
        private long optBits;
        private Possible<AutoModTriggerMetaData> triggerMetaData_possible = Possible.absent();
        private Possible<Boolean> enabled_possible = Possible.absent();
        private List<Snowflake> exemptRoles_list = null;
        private List<Snowflake> exemptChannels_list = null;
        private String reason;
        private String name;
        private int eventType;
        private int triggerType;
        private List<AutoModActionData> actions = new ArrayList<AutoModActionData>();

        private Builder() {
        }

        public final Builder from(AutoModRuleCreateSpec instance) {
            return this.from((AutoModRuleCreateSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(AutoModRuleCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.eventType(instance.eventType());
            this.triggerType(instance.triggerType());
            this.triggerMetaData(instance.triggerMetaData());
            this.addAllActions(instance.actions());
            this.enabled(instance.enabled());
            this.exemptRoles(instance.exemptRoles());
            this.exemptChannels(instance.exemptChannels());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder eventType(int eventType) {
            this.eventType = eventType;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder triggerType(int triggerType) {
            this.triggerType = triggerType;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder triggerMetaData(Possible<AutoModTriggerMetaData> value) {
            this.triggerMetaData_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder triggerMetaData(AutoModTriggerMetaData value) {
            this.triggerMetaData_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAction(AutoModActionData element) {
            element = ImmutableAutoModActionData.copyOf(element);
            this.actions.add(Objects.requireNonNull(element, "actions element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addAction(int type, Possible<AutoModActionMetaData> metadata) {
            return this.addAction(ImmutableAutoModActionData.of(type, metadata));
        }

        @CanIgnoreReturnValue
        public final Builder addActions(AutoModActionData ... elements) {
            for (AutoModActionData element : elements) {
                element = ImmutableAutoModActionData.copyOf(element);
                this.actions.add(Objects.requireNonNull(element, "actions element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder actions(Iterable<? extends AutoModActionData> elements) {
            this.actions.clear();
            return this.addAllActions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllActions(Iterable<? extends AutoModActionData> elements) {
            for (AutoModActionData autoModActionData : elements) {
                ImmutableAutoModActionData immutableAutoModActionData = ImmutableAutoModActionData.copyOf(autoModActionData);
                this.actions.add(Objects.requireNonNull(immutableAutoModActionData, "actions element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder enabled(Possible<Boolean> value) {
            this.enabled_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder enabled(Boolean value) {
            this.enabled_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addExemptRole(Snowflake element) {
            this.exemptRoles_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllExemptRoles(Collection<? extends Snowflake> elements) {
            this.exemptRoles_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder exemptRoles(Possible<? extends Collection<? extends Snowflake>> elements) {
            this.exemptRoles_list = null;
            elements.toOptional().ifPresent(e -> this.exemptRoles_getOrCreate().addAll((Collection<Snowflake>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder exemptRoles(Iterable<? extends Snowflake> elements) {
            this.exemptRoles_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder exemptRoles(Snowflake ... elements) {
            this.exemptRoles_list = Arrays.asList(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addExemptChannel(Snowflake element) {
            this.exemptChannels_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllExemptChannels(Collection<? extends Snowflake> elements) {
            this.exemptChannels_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder exemptChannels(Possible<? extends Collection<? extends Snowflake>> elements) {
            this.exemptChannels_list = null;
            elements.toOptional().ifPresent(e -> this.exemptChannels_getOrCreate().addAll((Collection<Snowflake>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder exemptChannels(Iterable<? extends Snowflake> elements) {
            this.exemptChannels_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder exemptChannels(Snowflake ... elements) {
            this.exemptChannels_list = Arrays.asList(elements);
            return this;
        }

        public AutoModRuleCreateSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AutoModRuleCreateSpec(this);
        }

        private boolean actionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("eventType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("triggerType");
            }
            return "Cannot build AutoModRuleCreateSpec, some of required attributes are not set " + attributes;
        }

        private Possible<AutoModTriggerMetaData> triggerMetaData_build() {
            return this.triggerMetaData_possible;
        }

        private Possible<Boolean> enabled_build() {
            return this.enabled_possible;
        }

        private Possible<List<Snowflake>> exemptRoles_build() {
            return this.exemptRoles_list == null ? Possible.absent() : Possible.of(this.exemptRoles_list);
        }

        private List<Snowflake> exemptRoles_getOrCreate() {
            if (this.exemptRoles_list == null) {
                this.exemptRoles_list = new ArrayList<Snowflake>();
            }
            return this.exemptRoles_list;
        }

        private Possible<List<Snowflake>> exemptChannels_build() {
            return this.exemptChannels_list == null ? Possible.absent() : Possible.of(this.exemptChannels_list);
        }

        private List<Snowflake> exemptChannels_getOrCreate() {
            if (this.exemptChannels_list == null) {
                this.exemptChannels_list = new ArrayList<Snowflake>();
            }
            return this.exemptChannels_list;
        }
    }

    @Generated(from="AutoModRuleCreateSpecGenerator", generator="Immutables")
    private final class InitShim {
        private byte actionsBuildStage = 0;
        private List<AutoModActionData> actions;

        private InitShim() {
        }

        List<AutoModActionData> actions() {
            if (this.actionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.actionsBuildStage == 0) {
                this.actionsBuildStage = (byte)-1;
                this.actions = AutoModRuleCreateSpec.createUnmodifiableList(false, AutoModRuleCreateSpec.createSafeList(AutoModRuleCreateSpec.this.actionsInitialize(), true, false));
                this.actionsBuildStage = 1;
            }
            return this.actions;
        }

        void actions(List<AutoModActionData> actions) {
            this.actions = actions;
            this.actionsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.actionsBuildStage == -1) {
                attributes.add("actions");
            }
            return "Cannot build AutoModRuleCreateSpec, attribute initializers form cycle " + attributes;
        }
    }
}

