/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.EmbedCreateSpecGenerator;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.core.spec.Spec;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ForumThreadMessageParamsData;
import discord4j.discordjson.json.ImmutableForumThreadMessageParamsData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public interface ForumThreadMessageCreateSpecGenerator
extends Spec<ForumThreadMessageParamsData> {
    public Possible<String> content();

    public Possible<List<EmbedCreateSpec>> embeds();

    public Possible<List<AllowedMentions>> allowedMentions();

    public Possible<List<MessageComponent>> components();

    public Possible<List<Snowflake>> stickerIds();

    @Override
    default public ForumThreadMessageParamsData asRequest() {
        ImmutableForumThreadMessageParamsData.Builder builder = ForumThreadMessageParamsData.builder();
        return builder.content(this.content()).embeds(InternalSpecUtils.mapPossible(this.embeds(), list -> list.stream().map(EmbedCreateSpecGenerator::asRequest).collect(Collectors.toList()))).allowedMentions(InternalSpecUtils.mapPossible(this.allowedMentions(), list -> list.stream().map(AllowedMentions::toData).collect(Collectors.toList()))).components(InternalSpecUtils.mapPossible(this.components(), list -> list.stream().map(MessageComponent::getData).collect(Collectors.toList()))).stickerIds(InternalSpecUtils.mapPossible(this.stickerIds(), list -> list.stream().map(snowflake -> Id.of(snowflake.asLong())).collect(Collectors.toList()))).build();
    }
}

