/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.spec.TextChannelEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="TextChannelEditSpecGenerator", generator="Immutables")
public final class TextChannelEditSpec
implements TextChannelEditSpecGenerator {
    @Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final Integer position_value;
    private final boolean position_absent;
    private final String topic_value;
    private final boolean topic_absent;
    private final Integer rateLimitPerUser_value;
    private final boolean rateLimitPerUser_absent;
    private final Boolean nsfw_value;
    private final boolean nsfw_absent;
    private final List<PermissionOverwrite> permissionOverwrites_value;
    private final boolean permissionOverwrites_absent;
    private final Snowflake parentId_value;
    private final boolean parentId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final TextChannelEditSpec INSTANCE = TextChannelEditSpec.validate(new TextChannelEditSpec());

    private TextChannelEditSpec() {
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible position$impl = Possible.absent();
        Possible topic$impl = Possible.absent();
        Possible rateLimitPerUser$impl = Possible.absent();
        Possible nsfw$impl = Possible.absent();
        Possible permissionOverwrites$impl = Possible.absent();
        Possible parentId$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.topic_value = topic$impl.toOptional().orElse(null);
        this.topic_absent = topic$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.nsfw_value = nsfw$impl.toOptional().orElse(null);
        this.nsfw_absent = nsfw$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.initShim = null;
    }

    private TextChannelEditSpec(@Nullable String reason, Possible<String> name, Possible<Integer> position, Possible<String> topic, Possible<Integer> rateLimitPerUser, Possible<Boolean> nsfw, Possible<List<PermissionOverwrite>> permissionOverwrites, Possible<Optional<Snowflake>> parentId) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<Integer> position$impl = position;
        Possible<String> topic$impl = topic;
        Possible<Integer> rateLimitPerUser$impl = rateLimitPerUser;
        Possible<Boolean> nsfw$impl = nsfw;
        Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
        Possible parentId$impl = parentId;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.topic_value = topic$impl.toOptional().orElse(null);
        this.topic_absent = topic$impl.isAbsent();
        this.rateLimitPerUser_value = rateLimitPerUser$impl.toOptional().orElse(null);
        this.rateLimitPerUser_absent = rateLimitPerUser$impl.isAbsent();
        this.nsfw_value = nsfw$impl.toOptional().orElse(null);
        this.nsfw_absent = nsfw$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of(this.name_value);
    }

    @Override
    public Possible<Integer> position() {
        return this.position_absent ? Possible.absent() : Possible.of(this.position_value);
    }

    @Override
    public Possible<String> topic() {
        return this.topic_absent ? Possible.absent() : Possible.of(this.topic_value);
    }

    @Override
    public Possible<Integer> rateLimitPerUser() {
        return this.rateLimitPerUser_absent ? Possible.absent() : Possible.of(this.rateLimitPerUser_value);
    }

    @Override
    public Possible<Boolean> nsfw() {
        return this.nsfw_absent ? Possible.absent() : Possible.of(this.nsfw_value);
    }

    @Override
    public Possible<List<PermissionOverwrite>> permissionOverwrites() {
        return this.permissionOverwrites_absent ? Possible.absent() : Possible.of(this.permissionOverwrites_value);
    }

    @Override
    public Possible<Optional<Snowflake>> parentId() {
        return this.parentId_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.parentId_value));
    }

    public final TextChannelEditSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return TextChannelEditSpec.validate(new TextChannelEditSpec(value, this.name(), this.position(), this.topic(), this.rateLimitPerUser(), this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public TextChannelEditSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, newValue, this.position(), this.topic(), this.rateLimitPerUser(), this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public TextChannelEditSpec withName(String value) {
        Possible<String> newValue = Possible.of(value);
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, newValue, this.position(), this.topic(), this.rateLimitPerUser(), this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public TextChannelEditSpec withPosition(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name(), newValue, this.topic(), this.rateLimitPerUser(), this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public TextChannelEditSpec withPosition(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name(), newValue, this.topic(), this.rateLimitPerUser(), this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public TextChannelEditSpec withTopic(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name(), this.position(), newValue, this.rateLimitPerUser(), this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public TextChannelEditSpec withTopic(String value) {
        Possible<String> newValue = Possible.of(value);
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name(), this.position(), newValue, this.rateLimitPerUser(), this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public TextChannelEditSpec withRateLimitPerUser(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), newValue, this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public TextChannelEditSpec withRateLimitPerUser(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), newValue, this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public TextChannelEditSpec withNsfw(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), this.rateLimitPerUser(), newValue, this.permissionOverwrites(), this.parentId()));
    }

    public TextChannelEditSpec withNsfw(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), this.rateLimitPerUser(), newValue, this.permissionOverwrites(), this.parentId()));
    }

    public TextChannelEditSpec withPermissionOverwrites(Possible<? extends List<? extends PermissionOverwrite>> possible) {
        Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), this.rateLimitPerUser(), this.nsfw(), newValue, this.parentId()));
    }

    public TextChannelEditSpec withPermissionOverwrites(Iterable<? extends PermissionOverwrite> elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), this.rateLimitPerUser(), this.nsfw(), newValue, this.parentId()));
    }

    @SafeVarargs
    public final TextChannelEditSpec withPermissionOverwrites(PermissionOverwrite ... elements) {
        Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), this.rateLimitPerUser(), this.nsfw(), newValue, this.parentId()));
    }

    public TextChannelEditSpec withParentId(Possible<Optional<Snowflake>> value) {
        Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), this.rateLimitPerUser(), this.nsfw(), this.permissionOverwrites(), newValue));
    }

    @Deprecated
    public TextChannelEditSpec withParentId(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), this.rateLimitPerUser(), this.nsfw(), this.permissionOverwrites(), newValue));
    }

    public TextChannelEditSpec withParentIdOrNull(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), this.rateLimitPerUser(), this.nsfw(), this.permissionOverwrites(), newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TextChannelEditSpec && this.equalTo(0, (TextChannelEditSpec)another);
    }

    private boolean equalTo(int synthetic, TextChannelEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.position().equals(another.position()) && this.topic().equals(another.topic()) && this.rateLimitPerUser().equals(another.rateLimitPerUser()) && this.nsfw().equals(another.nsfw()) && Objects.equals(this.permissionOverwrites_value, another.permissionOverwrites_value) && this.parentId().equals(another.parentId());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name().hashCode();
        h2 += (h2 << 5) + this.position().hashCode();
        h2 += (h2 << 5) + this.topic().hashCode();
        h2 += (h2 << 5) + this.rateLimitPerUser().hashCode();
        h2 += (h2 << 5) + this.nsfw().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.permissionOverwrites_value);
        h2 += (h2 << 5) + this.parentId().hashCode();
        return h2;
    }

    public String toString() {
        return "TextChannelEditSpec{reason=" + this.reason + ", name=" + this.name().toString() + ", position=" + this.position().toString() + ", topic=" + this.topic().toString() + ", rateLimitPerUser=" + this.rateLimitPerUser().toString() + ", nsfw=" + this.nsfw().toString() + ", permissionOverwrites=" + Objects.toString(this.permissionOverwrites_value) + ", parentId=" + this.parentId().toString() + "}";
    }

    public static TextChannelEditSpec create() {
        return INSTANCE;
    }

    private static TextChannelEditSpec validate(TextChannelEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static TextChannelEditSpec copyOf(TextChannelEditSpecGenerator instance) {
        if (instance instanceof TextChannelEditSpec) {
            return (TextChannelEditSpec)instance;
        }
        return TextChannelEditSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public boolean isTopicPresent() {
        return !this.topic_absent;
    }

    public String topicOrElse(String defaultValue) {
        return !this.topic_absent ? this.topic_value : defaultValue;
    }

    public boolean isRateLimitPerUserPresent() {
        return !this.rateLimitPerUser_absent;
    }

    public Integer rateLimitPerUserOrElse(Integer defaultValue) {
        return !this.rateLimitPerUser_absent ? this.rateLimitPerUser_value : defaultValue;
    }

    public boolean isNsfwPresent() {
        return !this.nsfw_absent;
    }

    public Boolean nsfwOrElse(Boolean defaultValue) {
        return !this.nsfw_absent ? this.nsfw_value : defaultValue;
    }

    public boolean isPermissionOverwritesPresent() {
        return !this.permissionOverwrites_absent;
    }

    public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
        return !this.permissionOverwrites_absent ? this.permissionOverwrites_value : defaultValue;
    }

    public boolean isParentIdPresent() {
        return !this.parentId_absent;
    }

    public Snowflake parentIdOrElse(Snowflake defaultValue) {
        return !this.parentId_absent ? this.parentId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TextChannelEditSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build TextChannelEditSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="TextChannelEditSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<Integer> position_possible = Possible.absent();
        private Possible<String> topic_possible = Possible.absent();
        private Possible<Integer> rateLimitPerUser_possible = Possible.absent();
        private Possible<Boolean> nsfw_possible = Possible.absent();
        private List<PermissionOverwrite> permissionOverwrites_list = null;
        private Possible<Optional<Snowflake>> parentId_possible = Possible.absent();
        private String reason;

        private Builder() {
        }

        public final Builder from(TextChannelEditSpec instance) {
            return this.from((TextChannelEditSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(TextChannelEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.position(instance.position());
            this.topic(instance.topic());
            this.rateLimitPerUser(instance.rateLimitPerUser());
            this.nsfw(instance.nsfw());
            this.permissionOverwrites(instance.permissionOverwrites());
            this.parentId(instance.parentId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(String value) {
            this.name_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder position(Possible<Integer> value) {
            this.position_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder position(Integer value) {
            this.position_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder topic(Possible<String> value) {
            this.topic_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder topic(String value) {
            this.topic_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rateLimitPerUser(Possible<Integer> value) {
            this.rateLimitPerUser_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rateLimitPerUser(Integer value) {
            this.rateLimitPerUser_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder nsfw(Possible<Boolean> value) {
            this.nsfw_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder nsfw(Boolean value) {
            this.nsfw_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPermissionOverwrite(PermissionOverwrite element) {
            this.permissionOverwrites_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllPermissionOverwrites(Collection<? extends PermissionOverwrite> elements) {
            this.permissionOverwrites_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(Possible<? extends Collection<? extends PermissionOverwrite>> elements) {
            this.permissionOverwrites_list = null;
            elements.toOptional().ifPresent(e -> this.permissionOverwrites_getOrCreate().addAll((Collection<PermissionOverwrite>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(Iterable<? extends PermissionOverwrite> elements) {
            this.permissionOverwrites_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder permissionOverwrites(PermissionOverwrite ... elements) {
            this.permissionOverwrites_list = Arrays.asList(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder parentId(Possible<Optional<Snowflake>> value) {
            this.parentId_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder parentId(@Nullable Snowflake value) {
            this.parentId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder parentIdOrNull(@Nullable Snowflake value) {
            this.parentId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public TextChannelEditSpec build() {
            return TextChannelEditSpec.validate(new TextChannelEditSpec(this.reason, this.name_build(), this.position_build(), this.topic_build(), this.rateLimitPerUser_build(), this.nsfw_build(), this.permissionOverwrites_build(), this.parentId_build()));
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<Integer> position_build() {
            return this.position_possible;
        }

        private Possible<String> topic_build() {
            return this.topic_possible;
        }

        private Possible<Integer> rateLimitPerUser_build() {
            return this.rateLimitPerUser_possible;
        }

        private Possible<Boolean> nsfw_build() {
            return this.nsfw_possible;
        }

        private Possible<List<PermissionOverwrite>> permissionOverwrites_build() {
            return this.permissionOverwrites_list == null ? Possible.absent() : Possible.of(this.permissionOverwrites_list);
        }

        private List<PermissionOverwrite> permissionOverwrites_getOrCreate() {
            if (this.permissionOverwrites_list == null) {
                this.permissionOverwrites_list = new ArrayList<PermissionOverwrite>();
            }
            return this.permissionOverwrites_list;
        }

        private Possible<Optional<Snowflake>> parentId_build() {
            return this.parentId_possible;
        }
    }
}

