/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.thread;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.thread.ThreadEvent;
import discord4j.core.object.entity.ThreadMember;
import discord4j.core.object.entity.channel.ThreadChannel;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.ThreadMemberData;
import discord4j.discordjson.json.gateway.ThreadListSync;
import discord4j.gateway.ShardInfo;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ThreadListSyncEvent
extends ThreadEvent {
    private final ThreadListSync dispatch;
    private final List<ThreadChannel> syncedThreads;

    public ThreadListSyncEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, ThreadListSync dispatch) {
        super(gateway, shardInfo);
        this.dispatch = dispatch;
        this.syncedThreads = dispatch.threads().stream().map(data -> new ThreadChannel(gateway, (ChannelData)data)).collect(Collectors.toList());
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.dispatch.guildId());
    }

    public Optional<List<Snowflake>> getSyncedChannelIds() {
        return this.dispatch.channelIds().toOptional().map(list -> list.stream().map(Snowflake::of).collect(Collectors.toList()));
    }

    public List<ThreadChannel> getSyncedThreads() {
        return this.syncedThreads;
    }

    public List<ThreadMember> getThreadMembers() {
        return this.dispatch.members().stream().map(data -> new ThreadMember(this.getClient(), (ThreadMemberData)data)).collect(Collectors.toList());
    }

    public String toString() {
        return "ThreadListSyncEvent{dispatch=" + this.dispatch + ", syncedThreads=" + this.syncedThreads + '}';
    }
}

