/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.AutoModRuleCreateMonoGenerator;
import discord4j.discordjson.json.AutoModActionData;
import discord4j.discordjson.json.AutoModTriggerMetaData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="AutoModRuleCreateMonoGenerator", generator="Immutables")
public final class AutoModRuleCreateMono
extends AutoModRuleCreateMonoGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final int eventType;
    private final int triggerType;
    private final AutoModTriggerMetaData triggerMetaData_value;
    private final boolean triggerMetaData_absent;
    private final List<AutoModActionData> actions;
    private final Boolean enabled_value;
    private final boolean enabled_absent;
    private final List<Snowflake> exemptRoles_value;
    private final boolean exemptRoles_absent;
    private final List<Snowflake> exemptChannels_value;
    private final boolean exemptChannels_absent;
    private final Guild guild;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private AutoModRuleCreateMono(String name, int eventType, int triggerType, Guild guild) {
        this.name = Objects.requireNonNull(name, "name");
        this.eventType = eventType;
        this.triggerType = triggerType;
        this.guild = Objects.requireNonNull(guild, "guild");
        this.reason = null;
        Possible triggerMetaData$impl = Possible.absent();
        Possible enabled$impl = Possible.absent();
        Possible exemptRoles$impl = Possible.absent();
        Possible exemptChannels$impl = Possible.absent();
        this.triggerMetaData_value = triggerMetaData$impl.toOptional().orElse(null);
        this.triggerMetaData_absent = triggerMetaData$impl.isAbsent();
        this.enabled_value = enabled$impl.toOptional().orElse(null);
        this.enabled_absent = enabled$impl.isAbsent();
        this.exemptRoles_value = exemptRoles$impl.toOptional().orElse(null);
        this.exemptRoles_absent = exemptRoles$impl.isAbsent();
        this.exemptChannels_value = exemptChannels$impl.toOptional().orElse(null);
        this.exemptChannels_absent = exemptChannels$impl.isAbsent();
        this.actions = this.initShim.actions();
        this.initShim = null;
    }

    private AutoModRuleCreateMono(@Nullable String reason, String name, int eventType, int triggerType, Possible<AutoModTriggerMetaData> triggerMetaData, List<AutoModActionData> actions, Possible<Boolean> enabled, Possible<List<Snowflake>> exemptRoles, Possible<List<Snowflake>> exemptChannels, Guild guild) {
        this.reason = reason;
        this.name = name;
        this.eventType = eventType;
        this.triggerType = triggerType;
        Possible<AutoModTriggerMetaData> triggerMetaData$impl = triggerMetaData;
        this.initShim.actions(actions);
        Possible<Boolean> enabled$impl = enabled;
        Possible<List<Snowflake>> exemptRoles$impl = exemptRoles;
        Possible<List<Snowflake>> exemptChannels$impl = exemptChannels;
        this.guild = guild;
        this.triggerMetaData_value = triggerMetaData$impl.toOptional().orElse(null);
        this.triggerMetaData_absent = triggerMetaData$impl.isAbsent();
        this.enabled_value = enabled$impl.toOptional().orElse(null);
        this.enabled_absent = enabled$impl.isAbsent();
        this.exemptRoles_value = exemptRoles$impl.toOptional().orElse(null);
        this.exemptRoles_absent = exemptRoles$impl.isAbsent();
        this.exemptChannels_value = exemptChannels$impl.toOptional().orElse(null);
        this.exemptChannels_absent = exemptChannels$impl.isAbsent();
        this.actions = this.initShim.actions();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int eventType() {
        return this.eventType;
    }

    @Override
    public int triggerType() {
        return this.triggerType;
    }

    @Override
    public Possible<AutoModTriggerMetaData> triggerMetaData() {
        return this.triggerMetaData_absent ? Possible.absent() : Possible.of(this.triggerMetaData_value);
    }

    @Override
    public List<AutoModActionData> actions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.actions() : this.actions;
    }

    @Override
    public Possible<Boolean> enabled() {
        return this.enabled_absent ? Possible.absent() : Possible.of(this.enabled_value);
    }

    @Override
    public Possible<List<Snowflake>> exemptRoles() {
        return this.exemptRoles_absent ? Possible.absent() : Possible.of(this.exemptRoles_value);
    }

    @Override
    public Possible<List<Snowflake>> exemptChannels() {
        return this.exemptChannels_absent ? Possible.absent() : Possible.of(this.exemptChannels_value);
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final AutoModRuleCreateMono withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new AutoModRuleCreateMono(value, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), this.exemptChannels(), this.guild);
    }

    public final AutoModRuleCreateMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new AutoModRuleCreateMono(this.reason, newValue, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), this.exemptChannels(), this.guild);
    }

    public final AutoModRuleCreateMono withEventType(int value) {
        if (this.eventType == value) {
            return this;
        }
        return new AutoModRuleCreateMono(this.reason, this.name, value, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), this.exemptChannels(), this.guild);
    }

    public final AutoModRuleCreateMono withTriggerType(int value) {
        if (this.triggerType == value) {
            return this;
        }
        return new AutoModRuleCreateMono(this.reason, this.name, this.eventType, value, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), this.exemptChannels(), this.guild);
    }

    public AutoModRuleCreateMono withTriggerMetaData(Possible<AutoModTriggerMetaData> value) {
        Possible<AutoModTriggerMetaData> newValue = Objects.requireNonNull(value);
        return new AutoModRuleCreateMono(this.reason, this.name, this.eventType, this.triggerType, newValue, this.actions, this.enabled(), this.exemptRoles(), this.exemptChannels(), this.guild);
    }

    public AutoModRuleCreateMono withTriggerMetaData(AutoModTriggerMetaData value) {
        Possible<AutoModTriggerMetaData> newValue = Possible.of(value);
        return new AutoModRuleCreateMono(this.reason, this.name, this.eventType, this.triggerType, newValue, this.actions, this.enabled(), this.exemptRoles(), this.exemptChannels(), this.guild);
    }

    public final AutoModRuleCreateMono withActions(AutoModActionData ... elements) {
        List<AutoModActionData> newValue = AutoModRuleCreateMono.createUnmodifiableList(false, AutoModRuleCreateMono.createSafeList(Arrays.asList(elements), true, false));
        return new AutoModRuleCreateMono(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), newValue, this.enabled(), this.exemptRoles(), this.exemptChannels(), this.guild);
    }

    public final AutoModRuleCreateMono withActions(Iterable<? extends AutoModActionData> elements) {
        if (this.actions == elements) {
            return this;
        }
        List<AutoModActionData> newValue = AutoModRuleCreateMono.createUnmodifiableList(false, AutoModRuleCreateMono.createSafeList(elements, true, false));
        return new AutoModRuleCreateMono(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), newValue, this.enabled(), this.exemptRoles(), this.exemptChannels(), this.guild);
    }

    public AutoModRuleCreateMono withEnabled(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new AutoModRuleCreateMono(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, newValue, this.exemptRoles(), this.exemptChannels(), this.guild);
    }

    public AutoModRuleCreateMono withEnabled(Boolean value) {
        Possible<Boolean> newValue = Possible.of(value);
        return new AutoModRuleCreateMono(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, newValue, this.exemptRoles(), this.exemptChannels(), this.guild);
    }

    public AutoModRuleCreateMono withExemptRoles(Possible<? extends List<? extends Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return new AutoModRuleCreateMono(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), newValue, this.exemptChannels(), this.guild);
    }

    public AutoModRuleCreateMono withExemptRoles(Iterable<? extends Snowflake> elements) {
        Possible<List<Snowflake>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new AutoModRuleCreateMono(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), newValue, this.exemptChannels(), this.guild);
    }

    @SafeVarargs
    public final AutoModRuleCreateMono withExemptRoles(Snowflake ... elements) {
        Possible<List<Snowflake>> newValue = Possible.of(Arrays.asList(elements));
        return new AutoModRuleCreateMono(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), newValue, this.exemptChannels(), this.guild);
    }

    public AutoModRuleCreateMono withExemptChannels(Possible<? extends List<? extends Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return new AutoModRuleCreateMono(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), newValue, this.guild);
    }

    public AutoModRuleCreateMono withExemptChannels(Iterable<? extends Snowflake> elements) {
        Possible<List<Snowflake>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new AutoModRuleCreateMono(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), newValue, this.guild);
    }

    @SafeVarargs
    public final AutoModRuleCreateMono withExemptChannels(Snowflake ... elements) {
        Possible<List<Snowflake>> newValue = Possible.of(Arrays.asList(elements));
        return new AutoModRuleCreateMono(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), newValue, this.guild);
    }

    public final AutoModRuleCreateMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new AutoModRuleCreateMono(this.reason, this.name, this.eventType, this.triggerType, this.triggerMetaData(), this.actions, this.enabled(), this.exemptRoles(), this.exemptChannels(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AutoModRuleCreateMono && this.equalTo(0, (AutoModRuleCreateMono)another);
    }

    private boolean equalTo(int synthetic, AutoModRuleCreateMono another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.eventType == another.eventType && this.triggerType == another.triggerType && this.triggerMetaData().equals(another.triggerMetaData()) && this.actions.equals(another.actions) && this.enabled().equals(another.enabled()) && Objects.equals(this.exemptRoles_value, another.exemptRoles_value) && Objects.equals(this.exemptChannels_value, another.exemptChannels_value) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.eventType;
        h2 += (h2 << 5) + this.triggerType;
        h2 += (h2 << 5) + this.triggerMetaData().hashCode();
        h2 += (h2 << 5) + this.actions.hashCode();
        h2 += (h2 << 5) + this.enabled().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.exemptRoles_value);
        h2 += (h2 << 5) + Objects.hashCode(this.exemptChannels_value);
        h2 += (h2 << 5) + this.guild.hashCode();
        return h2;
    }

    @Override
    public String toString() {
        return "AutoModRuleCreateMono{reason=" + this.reason + ", name=" + this.name + ", eventType=" + this.eventType + ", triggerType=" + this.triggerType + ", triggerMetaData=" + this.triggerMetaData().toString() + ", actions=" + this.actions + ", enabled=" + this.enabled().toString() + ", exemptRoles=" + Objects.toString(this.exemptRoles_value) + ", exemptChannels=" + Objects.toString(this.exemptChannels_value) + ", guild=" + this.guild + "}";
    }

    public static AutoModRuleCreateMono of(String name, int eventType, int triggerType, Guild guild) {
        return new AutoModRuleCreateMono(name, eventType, triggerType, guild);
    }

    static AutoModRuleCreateMono copyOf(AutoModRuleCreateMonoGenerator instance) {
        if (instance instanceof AutoModRuleCreateMono) {
            return (AutoModRuleCreateMono)instance;
        }
        return AutoModRuleCreateMono.of(instance.name(), instance.eventType(), instance.triggerType(), instance.guild()).withReason(instance.reason()).withTriggerMetaData(instance.triggerMetaData()).withActions(instance.actions()).withEnabled(instance.enabled()).withExemptRoles(instance.exemptRoles()).withExemptChannels(instance.exemptChannels());
    }

    public boolean isTriggerMetaDataPresent() {
        return !this.triggerMetaData_absent;
    }

    public AutoModTriggerMetaData triggerMetaDataOrElse(AutoModTriggerMetaData defaultValue) {
        return !this.triggerMetaData_absent ? this.triggerMetaData_value : defaultValue;
    }

    public boolean isEnabledPresent() {
        return !this.enabled_absent;
    }

    public Boolean enabledOrElse(Boolean defaultValue) {
        return !this.enabled_absent ? this.enabled_value : defaultValue;
    }

    public boolean isExemptRolesPresent() {
        return !this.exemptRoles_absent;
    }

    public List<Snowflake> exemptRolesOrElse(List<Snowflake> defaultValue) {
        return !this.exemptRoles_absent ? this.exemptRoles_value : defaultValue;
    }

    public boolean isExemptChannelsPresent() {
        return !this.exemptChannels_absent;
    }

    public List<Snowflake> exemptChannelsOrElse(List<Snowflake> defaultValue) {
        return !this.exemptChannels_absent ? this.exemptChannels_value : defaultValue;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AutoModRuleCreateMonoGenerator", generator="Immutables")
    private final class InitShim {
        private byte actionsBuildStage = 0;
        private List<AutoModActionData> actions;

        private InitShim() {
        }

        List<AutoModActionData> actions() {
            if (this.actionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.actionsBuildStage == 0) {
                this.actionsBuildStage = (byte)-1;
                this.actions = AutoModRuleCreateMono.createUnmodifiableList(false, AutoModRuleCreateMono.createSafeList(AutoModRuleCreateMono.super.actions(), true, false));
                this.actionsBuildStage = 1;
            }
            return this.actions;
        }

        void actions(List<AutoModActionData> actions) {
            this.actions = actions;
            this.actionsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.actionsBuildStage == -1) {
                attributes.add("actions");
            }
            return "Cannot build AutoModRuleCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

