/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.BanData;
import discord4j.discordjson.json.ChannelCreateRequest;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.CurrentMemberModifyData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildEmojiCreateRequest;
import discord4j.discordjson.json.GuildMemberAddRequest;
import discord4j.discordjson.json.GuildMemberModifyRequest;
import discord4j.discordjson.json.GuildModifyRequest;
import discord4j.discordjson.json.GuildPreviewData;
import discord4j.discordjson.json.GuildScheduledEventCreateRequest;
import discord4j.discordjson.json.GuildScheduledEventData;
import discord4j.discordjson.json.GuildScheduledEventModifyRequest;
import discord4j.discordjson.json.GuildUpdateData;
import discord4j.discordjson.json.GuildWidgetData;
import discord4j.discordjson.json.GuildWidgetModifyRequest;
import discord4j.discordjson.json.IntegrationCreateRequest;
import discord4j.discordjson.json.IntegrationData;
import discord4j.discordjson.json.IntegrationModifyRequest;
import discord4j.discordjson.json.InviteData;
import discord4j.discordjson.json.ListThreadsData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.PositionModifyRequest;
import discord4j.discordjson.json.PruneData;
import discord4j.discordjson.json.RegionData;
import discord4j.discordjson.json.RoleCreateRequest;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.RoleModifyRequest;
import discord4j.discordjson.json.TemplateData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.WebhookData;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestEmoji;
import discord4j.rest.entity.RestMember;
import discord4j.rest.entity.RestRole;
import discord4j.rest.entity.RestScheduledEvent;
import discord4j.rest.util.PaginationUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class RestGuild {
    private final RestClient restClient;
    private final long id;

    private RestGuild(RestClient restClient, long id) {
        this.restClient = restClient;
        this.id = id;
    }

    public static RestGuild create(RestClient restClient, Snowflake id) {
        return new RestGuild(restClient, id.asLong());
    }

    static RestGuild create(RestClient restClient, long id) {
        return new RestGuild(restClient, id);
    }

    public Snowflake getId() {
        return Snowflake.of(this.id);
    }

    public Mono<GuildUpdateData> getData(@Nullable Boolean withCounts) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Optional.ofNullable(withCounts).ifPresent(value -> queryParams.put("with_counts", value));
        return this.restClient.getGuildService().getGuild(this.id, queryParams);
    }

    public Mono<GuildUpdateData> getData() {
        return this.getData(true);
    }

    public RestEmoji emoji(Snowflake emojiId) {
        return RestEmoji.create(this.restClient, this.id, emojiId.asLong());
    }

    public RestMember member(Snowflake memberId) {
        return RestMember.create(this.restClient, this.id, memberId.asLong());
    }

    public RestRole role(Snowflake roleId) {
        return RestRole.create(this.restClient, this.id, roleId.asLong());
    }

    public RestScheduledEvent scheduledEvent(Snowflake eventId) {
        return RestScheduledEvent.create(this.restClient, this.id, eventId.asLong());
    }

    public Mono<GuildUpdateData> modify(GuildModifyRequest request, @Nullable String reason) {
        return this.restClient.getGuildService().modifyGuild(this.id, request, reason);
    }

    public Mono<Void> delete() {
        return this.restClient.getGuildService().deleteGuild(this.id);
    }

    public Flux<ChannelData> getChannels() {
        return this.restClient.getGuildService().getGuildChannels(this.id);
    }

    public Mono<ChannelData> createChannel(ChannelCreateRequest request, @Nullable String reason) {
        return this.restClient.getGuildService().createGuildChannel(this.id, request, reason);
    }

    public Flux<RoleData> modifyChannelPositions(List<PositionModifyRequest> requests) {
        return this.restClient.getGuildService().modifyGuildChannelPositions(this.id, requests.toArray(new PositionModifyRequest[0]));
    }

    public Mono<MemberData> getMember(Snowflake userId) {
        return this.restClient.getGuildService().getGuildMember(this.id, userId.asLong());
    }

    public Mono<MemberData> getSelfMember() {
        return this.restClient.getSelf().map(UserData::id).map(Snowflake::of).flatMap(this::getMember);
    }

    public Flux<MemberData> getMembers() {
        Function doRequest = params -> this.restClient.getGuildService().getGuildMembers(this.id, (Map<String, Object>)params);
        return PaginationUtil.paginateAfter(doRequest, data -> Snowflake.asLong(data.user().id()), 0L, 100);
    }

    public Flux<MemberData> searchMembers(Map<String, Object> queryParams) {
        return this.restClient.getGuildService().searchGuildMembers(this.id, queryParams);
    }

    public Mono<MemberData> addMember(Snowflake userId, GuildMemberAddRequest request) {
        return this.restClient.getGuildService().addGuildMember(this.id, userId.asLong(), request);
    }

    public Mono<MemberData> modifyMember(Snowflake userId, GuildMemberModifyRequest request, @Nullable String reason) {
        return this.restClient.getGuildService().modifyGuildMember(this.id, userId.asLong(), request, reason);
    }

    public Mono<MemberData> modifyCurrentMember(CurrentMemberModifyData request) {
        return this.restClient.getGuildService().modifyCurrentMember(this.id, request);
    }

    public Mono<Void> addMemberRole(Snowflake userId, Snowflake roleId, @Nullable String reason) {
        return this.restClient.getGuildService().addGuildMemberRole(this.id, userId.asLong(), roleId.asLong(), reason);
    }

    public Mono<Void> removeMemberRole(Snowflake userId, Snowflake roleId, @Nullable String reason) {
        return this.restClient.getGuildService().removeGuildMemberRole(this.id, userId.asLong(), roleId.asLong(), reason);
    }

    public Mono<Void> removeGuildMember(Snowflake userId, @Nullable String reason) {
        return this.restClient.getGuildService().removeGuildMember(this.id, userId.asLong(), reason);
    }

    public Flux<BanData> getBans() {
        return this.restClient.getGuildService().getGuildBans(this.id);
    }

    public Mono<BanData> getBan(Snowflake userId) {
        return this.restClient.getGuildService().getGuildBan(this.id, userId.asLong());
    }

    public Mono<Void> createBan(Snowflake userId, @Nullable Integer deleteMessageDays, @Nullable String reason) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Optional.ofNullable(deleteMessageDays).ifPresent(value -> queryParams.put("delete_message_days", value));
        Optional.ofNullable(reason).ifPresent(value -> queryParams.put("reason", value));
        return this.restClient.getGuildService().createGuildBan(this.id, userId.asLong(), queryParams, reason);
    }

    public Mono<Void> removeGuildBan(Snowflake userId, @Nullable String reason) {
        return this.restClient.getGuildService().removeGuildBan(this.id, userId.asLong(), reason);
    }

    public Flux<RoleData> getRoles() {
        return this.restClient.getGuildService().getGuildRoles(this.id);
    }

    public Mono<RoleData> createRole(RoleCreateRequest request, @Nullable String reason) {
        return this.restClient.getGuildService().createGuildRole(this.id, request, reason);
    }

    public Flux<RoleData> modifyRolePositions(List<PositionModifyRequest> requests) {
        return this.restClient.getGuildService().modifyGuildRolePositions(this.id, requests.toArray(new PositionModifyRequest[0]));
    }

    public Mono<RoleData> modifyRole(Snowflake roleId, RoleModifyRequest request, @Nullable String reason) {
        return this.restClient.getGuildService().modifyGuildRole(this.id, roleId.asLong(), request, reason);
    }

    public Mono<Void> deleteRole(Snowflake roleId, @Nullable String reason) {
        return this.restClient.getGuildService().deleteGuildRole(this.id, roleId.asLong(), reason);
    }

    public Mono<PruneData> getPruneCount(@Nullable Integer days) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Optional.ofNullable(days).ifPresent(value -> queryParams.put("days", value));
        return this.restClient.getGuildService().getGuildPruneCount(this.id, queryParams);
    }

    public Mono<PruneData> beginGuildPrune(@Nullable Integer days, @Nullable Boolean computePruneCount, @Nullable String reason) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Optional.ofNullable(days).ifPresent(value -> queryParams.put("days", value));
        Optional.ofNullable(computePruneCount).ifPresent(value -> queryParams.put("compute_prune_count", value));
        return this.restClient.getGuildService().beginGuildPrune(this.id, queryParams, reason);
    }

    public Flux<RegionData> getRegions() {
        return this.restClient.getGuildService().getGuildVoiceRegions(this.id);
    }

    public Flux<InviteData> getInvites() {
        return this.restClient.getGuildService().getGuildInvites(this.id);
    }

    public Flux<IntegrationData> getIntegrations() {
        return this.restClient.getGuildService().getGuildIntegrations(this.id);
    }

    public Mono<Void> createIntegration(IntegrationCreateRequest request) {
        return this.restClient.getGuildService().createGuildIntegration(this.id, request);
    }

    public Mono<Void> modifyIntegration(Snowflake integrationId, IntegrationModifyRequest request) {
        return this.restClient.getGuildService().modifyGuildIntegration(this.id, integrationId.asLong(), request);
    }

    public Mono<Void> deleteIntegration(Snowflake integrationId) {
        return this.restClient.getGuildService().deleteGuildIntegration(this.id, integrationId.asLong());
    }

    public Mono<Void> syncIntegration(Snowflake integrationId) {
        return this.restClient.getGuildService().syncGuildIntegration(this.id, integrationId.asLong());
    }

    public Mono<GuildWidgetData> getWidget() {
        return this.restClient.getGuildService().getGuildWidget(this.id);
    }

    public Mono<GuildWidgetData> modifyWidget(GuildWidgetModifyRequest request) {
        return this.restClient.getGuildService().modifyGuildWidget(this.id, request);
    }

    public Flux<EmojiData> getEmojis() {
        return this.restClient.getEmojiService().getGuildEmojis(this.id);
    }

    public Mono<EmojiData> createEmoji(GuildEmojiCreateRequest request, @Nullable String reason) {
        return this.restClient.getEmojiService().createGuildEmoji(this.id, request, reason);
    }

    public Flux<WebhookData> getWebhooks() {
        return this.restClient.getWebhookService().getGuildWebhooks(this.id);
    }

    public Mono<GuildPreviewData> getPreview() {
        return this.restClient.getGuildService().getGuildPreview(this.id);
    }

    public Flux<TemplateData> getTemplates() {
        return this.restClient.getTemplateService().getTemplates(this.id);
    }

    public Mono<ListThreadsData> getActiveThreads() {
        return this.restClient.getGuildService().listActiveGuildThreads(this.id);
    }

    public Mono<GuildScheduledEventData> getScheduledEvent(Snowflake eventId, @Nullable Boolean withUserCount) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Optional.ofNullable(withUserCount).ifPresent(value -> queryParams.put("with_user_count", value));
        return this.restClient.getGuildService().getScheduledEvent(this.id, eventId.asLong(), queryParams);
    }

    public Flux<GuildScheduledEventData> getScheduledEvents(@Nullable Boolean withUserCount) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        Optional.ofNullable(withUserCount).ifPresent(value -> queryParams.put("with_user_count", value));
        return this.restClient.getGuildService().getScheduledEvents(this.id, queryParams);
    }

    public Mono<GuildScheduledEventData> createScheduledEvent(GuildScheduledEventCreateRequest request) {
        return this.restClient.getGuildService().createScheduledEvent(this.id, request);
    }

    public Mono<GuildScheduledEventData> modifyScheduledEvent(Snowflake eventId, GuildScheduledEventModifyRequest request, @Nullable String reason) {
        return this.restClient.getGuildService().modifyScheduledEvent(this.id, eventId.asLong(), request, reason);
    }

    public Mono<Void> deleteScheduledEvent(Snowflake eventId, @Nullable String reason) {
        return this.restClient.getGuildService().deleteScheduledEvent(this.id, eventId.asLong(), reason);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestGuild restGuild = (RestGuild)o;
        return this.id == restGuild.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

