/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.mysql;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.mysql.DatabaseConnection;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class VerifyOAuth2
implements Callable<Boolean> {
    private static final String SQL = "SELECT `state` FROM `oauth2` WHERE `code` LIKE ?;";
    private static final String DELETE = "DELETE FROM `oauth2` WHERE code LIKE ?;";
    private final String code;
    private final String uuid;
    public Future<Boolean> future;

    public VerifyOAuth2(String code, String uuid) {
        this.code = code;
        this.uuid = uuid;
        this.future = Helper.EXECUTOR.submit(this);
    }

    @Override
    public Boolean call() {
        String state = "";
        try (Connection connection = DatabaseConnection.getNewConnection();
             PreparedStatement statement = connection.prepareStatement(SQL, 1004, 1007);){
            statement.setString(1, this.code);
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                state = result.getString("state");
                PreparedStatement delete = connection.prepareStatement(DELETE, 1004, 1007);
                try {
                    delete.setString(1, this.code);
                    delete.executeUpdate();
                }
                finally {
                    if (delete == null) continue;
                    delete.close();
                }
            }
        }
        catch (SQLException e) {
            ANSI.printErr("OAuth2 verification failed.", e);
            return false;
        }
        return state.equals(this.uuid);
    }
}

