/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.youtube.packets;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.term.ANSI;
import com.gmail.berndivader.streamserver.youtube.packets.Packet;
import com.google.gson.JsonParser;
import java.util.List;

public class ErrorPacket
extends Packet {
    private static final String JSON_ERROR = "{\"code\":-1,\"message\":\"%s\",\"errors\":[{\"message\":\"%s\",\"domain\":\"global\",\"%s\":\"badRequest\"}],\"status\":\"%s\"}";
    public int code;
    public String message;
    public List<Error> errors;
    public String status;

    @Override
    public String toString() {
        return Helper.GSON.toJson(this);
    }

    public void printSimple() {
        ANSI.printWarn("Youtube error code: " + this.code + ", Message: " + this.message);
        if (Config.DEBUG.booleanValue()) {
            ANSI.println(this.source.toString());
        }
    }

    public void printDetails() {
        this.printSimple();
        this.errors.forEach(e -> ANSI.printWarn(e.reason + " - " + e.domain + " - " + e.message));
    }

    public static ErrorPacket buildError(String message, String reason, String status) {
        return (ErrorPacket)Packet.build(JsonParser.parseString(String.format(JSON_ERROR, message, message, reason, status)).getAsJsonObject(), ErrorPacket.class);
    }

    public class Error {
        public String message;
        public String domain;
        public String reason;
        public String locationType;
        public String location;
    }
}

