/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.ThreadMember;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.BaseChannel;
import discord4j.core.object.entity.channel.GuildMessageChannel;
import discord4j.core.object.entity.channel.TopLevelGuildMessageChannel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.ThreadChannelEditMono;
import discord4j.core.spec.ThreadChannelEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.ThreadMetadata;
import discord4j.rest.util.PermissionSet;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Experimental
public final class ThreadChannel
extends BaseChannel
implements GuildMessageChannel {
    public ThreadChannel(GatewayDiscordClient gateway, ChannelData data) {
        super(gateway, data);
    }

    public Snowflake getStarterId() {
        return this.getData().ownerId().toOptional().map(Snowflake::of).orElseThrow(IllegalStateException::new);
    }

    public int getRateLimitPerUser() {
        return this.getData().rateLimitPerUser().toOptional().orElse(0);
    }

    public Mono<User> getStarter() {
        return this.getClient().getUserById(this.getStarterId());
    }

    public Mono<User> getStarter(EntityRetrievalStrategy retrievalStrategy) {
        return this.getClient().withRetrievalStrategy(retrievalStrategy).getUserById(this.getStarterId());
    }

    public Optional<Snowflake> getParentId() {
        return this.getData().parentId().toOptional().flatMap(Function.identity()).map(Snowflake::of);
    }

    public Mono<TopLevelGuildMessageChannel> getParent() {
        return Mono.justOrEmpty(this.getParentId()).flatMap(this.getClient()::getChannelById).cast(TopLevelGuildMessageChannel.class);
    }

    public Mono<TopLevelGuildMessageChannel> getParent(EntityRetrievalStrategy retrievalStrategy) {
        return Mono.justOrEmpty(this.getParentId()).flatMap(this.getClient().withRetrievalStrategy(retrievalStrategy)::getChannelById).cast(TopLevelGuildMessageChannel.class);
    }

    public Mono<ThreadMember> getMember(Snowflake userId) {
        return this.getClient().getThreadMemberById(this.getId(), userId);
    }

    public Mono<ThreadMember> getMember(Snowflake userId, EntityRetrievalStrategy retrievalStrategy) {
        return this.getClient().withRetrievalStrategy(retrievalStrategy).getThreadMemberById(this.getId(), userId);
    }

    public Flux<ThreadMember> getThreadMembers() {
        return this.getClient().getThreadMembers(this.getId());
    }

    public Flux<ThreadMember> getThreadMembers(EntityRetrievalStrategy retrievalStrategy) {
        return this.getClient().withRetrievalStrategy(retrievalStrategy).getThreadMembers(this.getId());
    }

    public int getApproximateMessageCount() {
        return this.getData().messageCount().toOptional().orElseThrow(IllegalStateException::new);
    }

    public int getApproximateMemberCount() {
        return this.getData().memberCount().toOptional().orElseThrow(IllegalStateException::new);
    }

    public boolean isArchived() {
        return this.getMetadata().archived();
    }

    public Instant getArchiveTimestamp() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)this.getMetadata().archiveTimestamp(), Instant::from);
    }

    public AutoArchiveDuration getAutoArchiveDuration() {
        return AutoArchiveDuration.of(this.getMetadata().autoArchiveDuration());
    }

    public boolean isLocked() {
        return this.getMetadata().locked().toOptional().orElse(false);
    }

    public boolean isPrivate() {
        return Type.of(this.getData().type()) == Type.GUILD_PRIVATE_THREAD;
    }

    private ThreadMetadata getMetadata() {
        return this.getData().threadMetadata().toOptional().orElseThrow(IllegalStateException::new);
    }

    @Override
    public Mono<PermissionSet> getEffectivePermissions(Snowflake memberId) {
        return this.getParent().flatMap(parent -> parent.getEffectivePermissions(memberId));
    }

    @Override
    public Mono<PermissionSet> getEffectivePermissions(Member member) {
        return this.getParent().flatMap(parent -> parent.getEffectivePermissions(member));
    }

    public Mono<Void> join() {
        return this.getClient().getRestClient().getChannelService().joinThread(this.getId().asLong());
    }

    public Mono<Void> leave() {
        return this.getClient().getRestClient().getChannelService().leaveThread(this.getId().asLong());
    }

    public Mono<Void> addMember(User user) {
        return this.getClient().getRestClient().getChannelService().addThreadMember(this.getId().asLong(), user.getId().asLong());
    }

    public Mono<Void> removeMember(User user) {
        return this.getClient().getRestClient().getChannelService().removeThreadMember(this.getId().asLong(), user.getId().asLong());
    }

    public ThreadChannelEditMono edit() {
        return ThreadChannelEditMono.of(this);
    }

    public Mono<ThreadChannel> edit(ThreadChannelEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getClient().getRestClient().getChannelService().modifyThread(this.getId().asLong(), spec.asRequest(), spec.reason())).map(data -> EntityUtil.getChannel(this.getClient(), data)).cast(ThreadChannel.class);
    }

    @Override
    public String toString() {
        return "ThreadChannel{} " + super.toString();
    }

    public static enum AutoArchiveDuration {
        UNKNOWN(-1),
        DURATION1(60),
        DURATION2(1440),
        DURATION3(4320),
        DURATION4(10080);

        private final int value;

        private AutoArchiveDuration(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public Duration asDuration() {
            return Duration.ofMinutes(this.value);
        }

        public static AutoArchiveDuration of(int value) {
            switch (value) {
                case 60: {
                    return DURATION1;
                }
                case 1440: {
                    return DURATION2;
                }
                case 4320: {
                    return DURATION3;
                }
                case 10080: {
                    return DURATION4;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum Type {
        UNKNOWN(-1),
        GUILD_NEWS_THREAD(10),
        GUILD_PUBLIC_THREAD(11),
        GUILD_PRIVATE_THREAD(12);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 10: {
                    return GUILD_NEWS_THREAD;
                }
                case 11: {
                    return GUILD_PUBLIC_THREAD;
                }
                case 12: {
                    return GUILD_PRIVATE_THREAD;
                }
            }
            return UNKNOWN;
        }
    }
}

