/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.ForumThreadMessageCreateSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="ForumThreadMessageCreateSpecGenerator", generator="Immutables")
public final class ForumThreadMessageCreateSpec
implements ForumThreadMessageCreateSpecGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final List<EmbedCreateSpec> embeds_value;
    private final boolean embeds_absent;
    private final List<AllowedMentions> allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<MessageComponent> components_value;
    private final boolean components_absent;
    private final List<Snowflake> stickerIds_value;
    private final boolean stickerIds_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ForumThreadMessageCreateSpec(Possible<String> content, Possible<List<EmbedCreateSpec>> embeds, Possible<List<AllowedMentions>> allowedMentions, Possible<List<MessageComponent>> components, Possible<List<Snowflake>> stickerIds) {
        Possible<String> content$impl = content;
        Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
        Possible<List<AllowedMentions>> allowedMentions$impl = allowedMentions;
        Possible<List<MessageComponent>> components$impl = components;
        Possible<List<Snowflake>> stickerIds$impl = stickerIds;
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.stickerIds_value = stickerIds$impl.toOptional().orElse(null);
        this.stickerIds_absent = stickerIds$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<String> content() {
        return this.content_absent ? Possible.absent() : Possible.of(this.content_value);
    }

    @Override
    public Possible<List<EmbedCreateSpec>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(this.embeds_value);
    }

    @Override
    public Possible<List<AllowedMentions>> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of(this.allowedMentions_value);
    }

    @Override
    public Possible<List<MessageComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    @Override
    public Possible<List<Snowflake>> stickerIds() {
        return this.stickerIds_absent ? Possible.absent() : Possible.of(this.stickerIds_value);
    }

    public ForumThreadMessageCreateSpec withContent(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ForumThreadMessageCreateSpec(newValue, this.embeds(), this.allowedMentions(), this.components(), this.stickerIds());
    }

    public ForumThreadMessageCreateSpec withContent(String value) {
        Possible<String> newValue = Possible.of(value);
        return new ForumThreadMessageCreateSpec(newValue, this.embeds(), this.allowedMentions(), this.components(), this.stickerIds());
    }

    public ForumThreadMessageCreateSpec withEmbeds(Possible<? extends List<? extends EmbedCreateSpec>> possible) {
        Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
        return new ForumThreadMessageCreateSpec(this.content(), newValue, this.allowedMentions(), this.components(), this.stickerIds());
    }

    public ForumThreadMessageCreateSpec withEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
        Possible<List<EmbedCreateSpec>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ForumThreadMessageCreateSpec(this.content(), newValue, this.allowedMentions(), this.components(), this.stickerIds());
    }

    @SafeVarargs
    public final ForumThreadMessageCreateSpec withEmbeds(EmbedCreateSpec ... elements) {
        Possible<List<EmbedCreateSpec>> newValue = Possible.of(Arrays.asList(elements));
        return new ForumThreadMessageCreateSpec(this.content(), newValue, this.allowedMentions(), this.components(), this.stickerIds());
    }

    public ForumThreadMessageCreateSpec withAllowedMentions(Possible<? extends List<? extends AllowedMentions>> possible) {
        Possible<List<AllowedMentions>> newValue = Objects.requireNonNull(possible);
        return new ForumThreadMessageCreateSpec(this.content(), this.embeds(), newValue, this.components(), this.stickerIds());
    }

    public ForumThreadMessageCreateSpec withAllowedMentions(Iterable<? extends AllowedMentions> elements) {
        Possible<List<AllowedMentions>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ForumThreadMessageCreateSpec(this.content(), this.embeds(), newValue, this.components(), this.stickerIds());
    }

    @SafeVarargs
    public final ForumThreadMessageCreateSpec withAllowedMentions(AllowedMentions ... elements) {
        Possible<List<AllowedMentions>> newValue = Possible.of(Arrays.asList(elements));
        return new ForumThreadMessageCreateSpec(this.content(), this.embeds(), newValue, this.components(), this.stickerIds());
    }

    public ForumThreadMessageCreateSpec withComponents(Possible<? extends List<? extends MessageComponent>> possible) {
        Possible<List<MessageComponent>> newValue = Objects.requireNonNull(possible);
        return new ForumThreadMessageCreateSpec(this.content(), this.embeds(), this.allowedMentions(), newValue, this.stickerIds());
    }

    public ForumThreadMessageCreateSpec withComponents(Iterable<? extends MessageComponent> elements) {
        Possible<List<MessageComponent>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ForumThreadMessageCreateSpec(this.content(), this.embeds(), this.allowedMentions(), newValue, this.stickerIds());
    }

    @SafeVarargs
    public final ForumThreadMessageCreateSpec withComponents(MessageComponent ... elements) {
        Possible<List<MessageComponent>> newValue = Possible.of(Arrays.asList(elements));
        return new ForumThreadMessageCreateSpec(this.content(), this.embeds(), this.allowedMentions(), newValue, this.stickerIds());
    }

    public ForumThreadMessageCreateSpec withStickerIds(Possible<? extends List<? extends Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return new ForumThreadMessageCreateSpec(this.content(), this.embeds(), this.allowedMentions(), this.components(), newValue);
    }

    public ForumThreadMessageCreateSpec withStickerIds(Iterable<? extends Snowflake> elements) {
        Possible<List<Snowflake>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ForumThreadMessageCreateSpec(this.content(), this.embeds(), this.allowedMentions(), this.components(), newValue);
    }

    @SafeVarargs
    public final ForumThreadMessageCreateSpec withStickerIds(Snowflake ... elements) {
        Possible<List<Snowflake>> newValue = Possible.of(Arrays.asList(elements));
        return new ForumThreadMessageCreateSpec(this.content(), this.embeds(), this.allowedMentions(), this.components(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ForumThreadMessageCreateSpec && this.equalTo(0, (ForumThreadMessageCreateSpec)another);
    }

    private boolean equalTo(int synthetic, ForumThreadMessageCreateSpec another) {
        return this.content().equals(another.content()) && Objects.equals(this.embeds_value, another.embeds_value) && Objects.equals(this.allowedMentions_value, another.allowedMentions_value) && Objects.equals(this.components_value, another.components_value) && Objects.equals(this.stickerIds_value, another.stickerIds_value);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.content().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.embeds_value);
        h2 += (h2 << 5) + Objects.hashCode(this.allowedMentions_value);
        h2 += (h2 << 5) + Objects.hashCode(this.components_value);
        h2 += (h2 << 5) + Objects.hashCode(this.stickerIds_value);
        return h2;
    }

    public String toString() {
        return "ForumThreadMessageCreateSpec{content=" + this.content().toString() + ", embeds=" + Objects.toString(this.embeds_value) + ", allowedMentions=" + Objects.toString(this.allowedMentions_value) + ", components=" + Objects.toString(this.components_value) + ", stickerIds=" + Objects.toString(this.stickerIds_value) + "}";
    }

    public static ForumThreadMessageCreateSpec copyOf(ForumThreadMessageCreateSpecGenerator instance) {
        if (instance instanceof ForumThreadMessageCreateSpec) {
            return (ForumThreadMessageCreateSpec)instance;
        }
        return ForumThreadMessageCreateSpec.builder().from(instance).build();
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public List<AllowedMentions> allowedMentionsOrElse(List<AllowedMentions> defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<MessageComponent> componentsOrElse(List<MessageComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public boolean isStickerIdsPresent() {
        return !this.stickerIds_absent;
    }

    public List<Snowflake> stickerIdsOrElse(List<Snowflake> defaultValue) {
        return !this.stickerIds_absent ? this.stickerIds_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ForumThreadMessageCreateSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ForumThreadMessageCreateSpec, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="ForumThreadMessageCreateSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<String> content_possible = Possible.absent();
        private List<EmbedCreateSpec> embeds_list = null;
        private List<AllowedMentions> allowedMentions_list = null;
        private List<MessageComponent> components_list = null;
        private List<Snowflake> stickerIds_list = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ForumThreadMessageCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.content());
            this.embeds(instance.embeds());
            this.allowedMentions(instance.allowedMentions());
            this.components(instance.components());
            this.stickerIds(instance.stickerIds());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder content(Possible<String> value) {
            this.content_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder content(String value) {
            this.content_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addEmbed(EmbedCreateSpec element) {
            this.embeds_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllEmbeds(Collection<? extends EmbedCreateSpec> elements) {
            this.embeds_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(Possible<? extends Collection<? extends EmbedCreateSpec>> elements) {
            this.embeds_list = null;
            elements.toOptional().ifPresent(e -> this.embeds_getOrCreate().addAll((Collection<EmbedCreateSpec>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(Iterable<? extends EmbedCreateSpec> elements) {
            this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder embeds(EmbedCreateSpec ... elements) {
            this.embeds_list = Arrays.asList(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllowedMention(AllowedMentions element) {
            this.allowedMentions_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllAllowedMentions(Collection<? extends AllowedMentions> elements) {
            this.allowedMentions_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentions(Possible<? extends Collection<? extends AllowedMentions>> elements) {
            this.allowedMentions_list = null;
            elements.toOptional().ifPresent(e -> this.allowedMentions_getOrCreate().addAll((Collection<AllowedMentions>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentions(Iterable<? extends AllowedMentions> elements) {
            this.allowedMentions_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder allowedMentions(AllowedMentions ... elements) {
            this.allowedMentions_list = Arrays.asList(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addComponent(MessageComponent element) {
            this.components_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllComponents(Collection<? extends MessageComponent> elements) {
            this.components_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Possible<? extends Collection<? extends MessageComponent>> elements) {
            this.components_list = null;
            elements.toOptional().ifPresent(e -> this.components_getOrCreate().addAll((Collection<MessageComponent>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Iterable<? extends MessageComponent> elements) {
            this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder components(MessageComponent ... elements) {
            this.components_list = Arrays.asList(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addStickerId(Snowflake element) {
            this.stickerIds_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllStickerIds(Collection<? extends Snowflake> elements) {
            this.stickerIds_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder stickerIds(Possible<? extends Collection<? extends Snowflake>> elements) {
            this.stickerIds_list = null;
            elements.toOptional().ifPresent(e -> this.stickerIds_getOrCreate().addAll((Collection<Snowflake>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder stickerIds(Iterable<? extends Snowflake> elements) {
            this.stickerIds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder stickerIds(Snowflake ... elements) {
            this.stickerIds_list = Arrays.asList(elements);
            return this;
        }

        public ForumThreadMessageCreateSpec build() {
            return new ForumThreadMessageCreateSpec(this.content_build(), this.embeds_build(), this.allowedMentions_build(), this.components_build(), this.stickerIds_build());
        }

        private Possible<String> content_build() {
            return this.content_possible;
        }

        private Possible<List<EmbedCreateSpec>> embeds_build() {
            return this.embeds_list == null ? Possible.absent() : Possible.of(this.embeds_list);
        }

        private List<EmbedCreateSpec> embeds_getOrCreate() {
            if (this.embeds_list == null) {
                this.embeds_list = new ArrayList<EmbedCreateSpec>();
            }
            return this.embeds_list;
        }

        private Possible<List<AllowedMentions>> allowedMentions_build() {
            return this.allowedMentions_list == null ? Possible.absent() : Possible.of(this.allowedMentions_list);
        }

        private List<AllowedMentions> allowedMentions_getOrCreate() {
            if (this.allowedMentions_list == null) {
                this.allowedMentions_list = new ArrayList<AllowedMentions>();
            }
            return this.allowedMentions_list;
        }

        private Possible<List<MessageComponent>> components_build() {
            return this.components_list == null ? Possible.absent() : Possible.of(this.components_list);
        }

        private List<MessageComponent> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<MessageComponent>();
            }
            return this.components_list;
        }

        private Possible<List<Snowflake>> stickerIds_build() {
            return this.stickerIds_list == null ? Possible.absent() : Possible.of(this.stickerIds_list);
        }

        private List<Snowflake> stickerIds_getOrCreate() {
            if (this.stickerIds_list == null) {
                this.stickerIds_list = new ArrayList<Snowflake>();
            }
            return this.stickerIds_list;
        }
    }
}

