/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.PositionModifyRequest;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.RoleModifyRequest;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestGuild;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class RestRole {
    private final RestClient restClient;
    private final long guildId;
    private final long id;

    private RestRole(RestClient restClient, long guildId, long id) {
        this.restClient = restClient;
        this.guildId = guildId;
        this.id = id;
    }

    public static RestRole create(RestClient restClient, Snowflake guildId, Snowflake id) {
        return new RestRole(restClient, guildId.asLong(), id.asLong());
    }

    static RestRole create(RestClient restClient, long guildId, long id) {
        return new RestRole(restClient, guildId, id);
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.guildId);
    }

    public Snowflake getId() {
        return Snowflake.of(this.id);
    }

    public RestGuild guild() {
        return RestGuild.create(this.restClient, this.guildId);
    }

    public Mono<RoleData> edit(RoleModifyRequest request, @Nullable String reason) {
        return this.restClient.getGuildService().modifyGuildRole(this.guildId, this.id, request, reason);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.restClient.getGuildService().deleteGuildRole(this.guildId, this.id, reason);
    }

    public Flux<RoleData> changePosition(int position) {
        PositionModifyRequest[] requests = new PositionModifyRequest[]{PositionModifyRequest.builder().id(Snowflake.asString(this.id)).position(position).build()};
        return this.restClient.getGuildService().modifyGuildRolePositions(this.guildId, requests);
    }

    public Mono<RoleData> getData() {
        return this.restClient.getGuildService().getGuildRoles(this.guildId).filter(response -> Snowflake.asLong(response.id()) == this.id).singleOrEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestRole restRole = (RestRole)o;
        return this.guildId == restRole.guildId && this.id == restRole.id;
    }

    public int hashCode() {
        return Objects.hash(this.guildId, this.id);
    }
}

