/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec.legacy;

import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.spec.legacy.LegacyAuditSpec;
import discord4j.discordjson.json.ChannelModifyRequest;
import discord4j.discordjson.json.ImmutableChannelModifyRequest;
import discord4j.discordjson.possible.Possible;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class LegacyNewsChannelEditSpec
implements LegacyAuditSpec<ChannelModifyRequest> {
    private final ImmutableChannelModifyRequest.Builder requestBuilder = ChannelModifyRequest.builder();
    @Nullable
    private String reason;

    public LegacyNewsChannelEditSpec setName(String name) {
        this.requestBuilder.name(name);
        return this;
    }

    public LegacyNewsChannelEditSpec setPosition(int position) {
        this.requestBuilder.position(position);
        return this;
    }

    public LegacyNewsChannelEditSpec setTopic(String topic) {
        this.requestBuilder.topic(topic);
        return this;
    }

    public LegacyNewsChannelEditSpec setNsfw(boolean nsfw) {
        this.requestBuilder.nsfw(nsfw);
        return this;
    }

    public LegacyNewsChannelEditSpec setPermissionOverwrites(Set<? extends PermissionOverwrite> permissionOverwrites) {
        List raw = permissionOverwrites.stream().map(PermissionOverwrite::getData).collect(Collectors.toList());
        this.requestBuilder.permissionOverwrites(raw);
        return this;
    }

    public LegacyNewsChannelEditSpec setParentId(@Nullable Snowflake parentId) {
        this.requestBuilder.parentId(Possible.of(Optional.ofNullable(parentId).map(Snowflake::asString)));
        return this;
    }

    public LegacyNewsChannelEditSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public ChannelModifyRequest asRequest() {
        return this.requestBuilder.build();
    }
}

