/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildPreviewData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="GuildPreviewData", generator="Immutables")
public final class ImmutableGuildPreviewData
implements GuildPreviewData {
    private final long id_value;
    private final String name;
    private final String icon;
    private final String splash;
    private final String discoverySplash;
    private final List<EmojiData> emojis;
    private final List<String> features;
    private final int approximateMemberCount;
    private final int approximatePresenceCount;
    private final String description;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGuildPreviewData(Id id, String name, Optional<String> icon, Optional<String> splash, Optional<String> discoverySplash, Iterable<? extends EmojiData> emojis, Iterable<String> features, int approximateMemberCount, int approximatePresenceCount, Optional<String> description) {
        Id id$impl = id;
        this.name = Objects.requireNonNull(name, "name");
        this.icon = icon.orElse(null);
        this.splash = splash.orElse(null);
        this.discoverySplash = discoverySplash.orElse(null);
        this.emojis = ImmutableGuildPreviewData.createUnmodifiableList(false, ImmutableGuildPreviewData.createSafeList(emojis, true, false));
        this.features = ImmutableGuildPreviewData.createUnmodifiableList(false, ImmutableGuildPreviewData.createSafeList(features, true, false));
        this.approximateMemberCount = approximateMemberCount;
        this.approximatePresenceCount = approximatePresenceCount;
        this.description = description.orElse(null);
        this.id_value = id$impl.asLong();
        this.initShim = null;
    }

    private ImmutableGuildPreviewData(ImmutableGuildPreviewData original, Id id, String name, String icon, String splash, String discoverySplash, List<EmojiData> emojis, List<String> features, int approximateMemberCount, int approximatePresenceCount, String description) {
        Id id$impl = id;
        this.name = name;
        this.icon = icon;
        this.splash = splash;
        this.discoverySplash = discoverySplash;
        this.emojis = emojis;
        this.features = features;
        this.approximateMemberCount = approximateMemberCount;
        this.approximatePresenceCount = approximatePresenceCount;
        this.description = description;
        this.id_value = id$impl.asLong();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of(this.id_value);
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="icon")
    public Optional<String> icon() {
        return Optional.ofNullable(this.icon);
    }

    @Override
    @JsonProperty(value="splash")
    public Optional<String> splash() {
        return Optional.ofNullable(this.splash);
    }

    @Override
    @JsonProperty(value="discovery_splash")
    public Optional<String> discoverySplash() {
        return Optional.ofNullable(this.discoverySplash);
    }

    @Override
    @JsonProperty(value="emojis")
    public List<EmojiData> emojis() {
        return this.emojis;
    }

    @Override
    @JsonProperty(value="features")
    public List<String> features() {
        return this.features;
    }

    @Override
    @JsonProperty(value="approximate_member_count")
    public int approximateMemberCount() {
        return this.approximateMemberCount;
    }

    @Override
    @JsonProperty(value="approximate_presence_count")
    public int approximatePresenceCount() {
        return this.approximatePresenceCount;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public ImmutableGuildPreviewData withId(long value) {
        Id newValue = Id.of(value);
        return new ImmutableGuildPreviewData(this, newValue, this.name, this.icon, this.splash, this.discoverySplash, this.emojis, this.features, this.approximateMemberCount, this.approximatePresenceCount, this.description);
    }

    public ImmutableGuildPreviewData withId(String value) {
        Id newValue = Id.of(value);
        return new ImmutableGuildPreviewData(this, newValue, this.name, this.icon, this.splash, this.discoverySplash, this.emojis, this.features, this.approximateMemberCount, this.approximatePresenceCount, this.description);
    }

    public final ImmutableGuildPreviewData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildPreviewData(this, this.id(), newValue, this.icon, this.splash, this.discoverySplash, this.emojis, this.features, this.approximateMemberCount, this.approximatePresenceCount, this.description);
    }

    public final ImmutableGuildPreviewData withIcon(String value) {
        String newValue = Objects.requireNonNull(value, "icon");
        if (Objects.equals(this.icon, newValue)) {
            return this;
        }
        return new ImmutableGuildPreviewData(this, this.id(), this.name, newValue, this.splash, this.discoverySplash, this.emojis, this.features, this.approximateMemberCount, this.approximatePresenceCount, this.description);
    }

    public final ImmutableGuildPreviewData withIcon(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.icon, value)) {
            return this;
        }
        return new ImmutableGuildPreviewData(this, this.id(), this.name, value, this.splash, this.discoverySplash, this.emojis, this.features, this.approximateMemberCount, this.approximatePresenceCount, this.description);
    }

    public final ImmutableGuildPreviewData withSplash(String value) {
        String newValue = Objects.requireNonNull(value, "splash");
        if (Objects.equals(this.splash, newValue)) {
            return this;
        }
        return new ImmutableGuildPreviewData(this, this.id(), this.name, this.icon, newValue, this.discoverySplash, this.emojis, this.features, this.approximateMemberCount, this.approximatePresenceCount, this.description);
    }

    public final ImmutableGuildPreviewData withSplash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.splash, value)) {
            return this;
        }
        return new ImmutableGuildPreviewData(this, this.id(), this.name, this.icon, value, this.discoverySplash, this.emojis, this.features, this.approximateMemberCount, this.approximatePresenceCount, this.description);
    }

    public final ImmutableGuildPreviewData withDiscoverySplash(String value) {
        String newValue = Objects.requireNonNull(value, "discoverySplash");
        if (Objects.equals(this.discoverySplash, newValue)) {
            return this;
        }
        return new ImmutableGuildPreviewData(this, this.id(), this.name, this.icon, this.splash, newValue, this.emojis, this.features, this.approximateMemberCount, this.approximatePresenceCount, this.description);
    }

    public final ImmutableGuildPreviewData withDiscoverySplash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.discoverySplash, value)) {
            return this;
        }
        return new ImmutableGuildPreviewData(this, this.id(), this.name, this.icon, this.splash, value, this.emojis, this.features, this.approximateMemberCount, this.approximatePresenceCount, this.description);
    }

    public final ImmutableGuildPreviewData withEmojis(EmojiData ... elements) {
        List<EmojiData> newValue = ImmutableGuildPreviewData.createUnmodifiableList(false, ImmutableGuildPreviewData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGuildPreviewData(this, this.id(), this.name, this.icon, this.splash, this.discoverySplash, newValue, this.features, this.approximateMemberCount, this.approximatePresenceCount, this.description);
    }

    public final ImmutableGuildPreviewData withEmojis(Iterable<? extends EmojiData> elements) {
        if (this.emojis == elements) {
            return this;
        }
        List<EmojiData> newValue = ImmutableGuildPreviewData.createUnmodifiableList(false, ImmutableGuildPreviewData.createSafeList(elements, true, false));
        return new ImmutableGuildPreviewData(this, this.id(), this.name, this.icon, this.splash, this.discoverySplash, newValue, this.features, this.approximateMemberCount, this.approximatePresenceCount, this.description);
    }

    public final ImmutableGuildPreviewData withFeatures(String ... elements) {
        List<String> newValue = ImmutableGuildPreviewData.createUnmodifiableList(false, ImmutableGuildPreviewData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGuildPreviewData(this, this.id(), this.name, this.icon, this.splash, this.discoverySplash, this.emojis, newValue, this.approximateMemberCount, this.approximatePresenceCount, this.description);
    }

    public final ImmutableGuildPreviewData withFeatures(Iterable<String> elements) {
        if (this.features == elements) {
            return this;
        }
        List<String> newValue = ImmutableGuildPreviewData.createUnmodifiableList(false, ImmutableGuildPreviewData.createSafeList(elements, true, false));
        return new ImmutableGuildPreviewData(this, this.id(), this.name, this.icon, this.splash, this.discoverySplash, this.emojis, newValue, this.approximateMemberCount, this.approximatePresenceCount, this.description);
    }

    public final ImmutableGuildPreviewData withApproximateMemberCount(int value) {
        if (this.approximateMemberCount == value) {
            return this;
        }
        return new ImmutableGuildPreviewData(this, this.id(), this.name, this.icon, this.splash, this.discoverySplash, this.emojis, this.features, value, this.approximatePresenceCount, this.description);
    }

    public final ImmutableGuildPreviewData withApproximatePresenceCount(int value) {
        if (this.approximatePresenceCount == value) {
            return this;
        }
        return new ImmutableGuildPreviewData(this, this.id(), this.name, this.icon, this.splash, this.discoverySplash, this.emojis, this.features, this.approximateMemberCount, value, this.description);
    }

    public final ImmutableGuildPreviewData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableGuildPreviewData(this, this.id(), this.name, this.icon, this.splash, this.discoverySplash, this.emojis, this.features, this.approximateMemberCount, this.approximatePresenceCount, newValue);
    }

    public final ImmutableGuildPreviewData withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableGuildPreviewData(this, this.id(), this.name, this.icon, this.splash, this.discoverySplash, this.emojis, this.features, this.approximateMemberCount, this.approximatePresenceCount, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildPreviewData && this.equalTo(0, (ImmutableGuildPreviewData)another);
    }

    private boolean equalTo(int synthetic, ImmutableGuildPreviewData another) {
        return Objects.equals(this.id_value, another.id_value) && this.name.equals(another.name) && Objects.equals(this.icon, another.icon) && Objects.equals(this.splash, another.splash) && Objects.equals(this.discoverySplash, another.discoverySplash) && this.emojis.equals(another.emojis) && this.features.equals(another.features) && this.approximateMemberCount == another.approximateMemberCount && this.approximatePresenceCount == another.approximatePresenceCount && Objects.equals(this.description, another.description);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.id_value);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.icon);
        h2 += (h2 << 5) + Objects.hashCode(this.splash);
        h2 += (h2 << 5) + Objects.hashCode(this.discoverySplash);
        h2 += (h2 << 5) + this.emojis.hashCode();
        h2 += (h2 << 5) + this.features.hashCode();
        h2 += (h2 << 5) + this.approximateMemberCount;
        h2 += (h2 << 5) + this.approximatePresenceCount;
        h2 += (h2 << 5) + Objects.hashCode(this.description);
        return h2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GuildPreviewData{");
        builder.append("id=").append(Objects.toString(this.id_value));
        builder.append(", ");
        builder.append("name=").append(this.name);
        if (this.icon != null) {
            builder.append(", ");
            builder.append("icon=").append(this.icon);
        }
        if (this.splash != null) {
            builder.append(", ");
            builder.append("splash=").append(this.splash);
        }
        if (this.discoverySplash != null) {
            builder.append(", ");
            builder.append("discoverySplash=").append(this.discoverySplash);
        }
        builder.append(", ");
        builder.append("emojis=").append(this.emojis);
        builder.append(", ");
        builder.append("features=").append(this.features);
        builder.append(", ");
        builder.append("approximateMemberCount=").append(this.approximateMemberCount);
        builder.append(", ");
        builder.append("approximatePresenceCount=").append(this.approximatePresenceCount);
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildPreviewData fromJson(Json json) {
        Builder builder = ImmutableGuildPreviewData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.icon != null) {
            builder.icon(json.icon);
        }
        if (json.splash != null) {
            builder.splash(json.splash);
        }
        if (json.discoverySplash != null) {
            builder.discoverySplash(json.discoverySplash);
        }
        if (json.emojis != null) {
            builder.addAllEmojis(json.emojis);
        }
        if (json.features != null) {
            builder.addAllFeatures(json.features);
        }
        if (json.approximateMemberCountIsSet) {
            builder.approximateMemberCount(json.approximateMemberCount);
        }
        if (json.approximatePresenceCountIsSet) {
            builder.approximatePresenceCount(json.approximatePresenceCount);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        return builder.build();
    }

    public static ImmutableGuildPreviewData of(Id id, String name, Optional<String> icon, Optional<String> splash, Optional<String> discoverySplash, List<EmojiData> emojis, List<String> features, int approximateMemberCount, int approximatePresenceCount, Optional<String> description) {
        return ImmutableGuildPreviewData.of(id, name, icon, splash, discoverySplash, emojis, features, approximateMemberCount, approximatePresenceCount, description);
    }

    public static ImmutableGuildPreviewData of(Id id, String name, Optional<String> icon, Optional<String> splash, Optional<String> discoverySplash, Iterable<? extends EmojiData> emojis, Iterable<String> features, int approximateMemberCount, int approximatePresenceCount, Optional<String> description) {
        return new ImmutableGuildPreviewData(id, name, icon, splash, discoverySplash, emojis, features, approximateMemberCount, approximatePresenceCount, description);
    }

    public static ImmutableGuildPreviewData copyOf(GuildPreviewData instance) {
        if (instance instanceof ImmutableGuildPreviewData) {
            return (ImmutableGuildPreviewData)instance;
        }
        return ImmutableGuildPreviewData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GuildPreviewData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_APPROXIMATE_MEMBER_COUNT = 2L;
        private static final long INIT_BIT_APPROXIMATE_PRESENCE_COUNT = 4L;
        private long initBits = 7L;
        private Id id_id = null;
        private String name;
        private String icon;
        private String splash;
        private String discoverySplash;
        private List<EmojiData> emojis = new ArrayList<EmojiData>();
        private List<String> features = new ArrayList<String>();
        private int approximateMemberCount;
        private int approximatePresenceCount;
        private String description;

        private Builder() {
        }

        public final Builder from(GuildPreviewData instance) {
            Optional<String> discoverySplashOptional;
            Optional<String> splashOptional;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.name(instance.name());
            Optional<String> iconOptional = instance.icon();
            if (iconOptional.isPresent()) {
                this.icon(iconOptional);
            }
            if ((splashOptional = instance.splash()).isPresent()) {
                this.splash(splashOptional);
            }
            if ((discoverySplashOptional = instance.discoverySplash()).isPresent()) {
                this.discoverySplash(discoverySplashOptional);
            }
            this.addAllEmojis(instance.emojis());
            this.addAllFeatures(instance.features());
            this.approximateMemberCount(instance.approximateMemberCount());
            this.approximatePresenceCount(instance.approximatePresenceCount());
            Optional<String> descriptionOptional = instance.description();
            if (descriptionOptional.isPresent()) {
                this.description(descriptionOptional);
            }
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of(value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of(value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder icon(String icon) {
            this.icon = Objects.requireNonNull(icon, "icon");
            return this;
        }

        @JsonProperty(value="icon")
        public final Builder icon(Optional<String> icon) {
            this.icon = icon.orElse(null);
            return this;
        }

        public final Builder splash(String splash) {
            this.splash = Objects.requireNonNull(splash, "splash");
            return this;
        }

        @JsonProperty(value="splash")
        public final Builder splash(Optional<String> splash) {
            this.splash = splash.orElse(null);
            return this;
        }

        public final Builder discoverySplash(String discoverySplash) {
            this.discoverySplash = Objects.requireNonNull(discoverySplash, "discoverySplash");
            return this;
        }

        @JsonProperty(value="discovery_splash")
        public final Builder discoverySplash(Optional<String> discoverySplash) {
            this.discoverySplash = discoverySplash.orElse(null);
            return this;
        }

        public final Builder addEmoji(EmojiData element) {
            this.emojis.add(Objects.requireNonNull(element, "emojis element"));
            return this;
        }

        public final Builder addEmojis(EmojiData ... elements) {
            for (EmojiData element : elements) {
                this.emojis.add(Objects.requireNonNull(element, "emojis element"));
            }
            return this;
        }

        @JsonProperty(value="emojis")
        public final Builder emojis(Iterable<? extends EmojiData> elements) {
            this.emojis.clear();
            return this.addAllEmojis(elements);
        }

        public final Builder addAllEmojis(Iterable<? extends EmojiData> elements) {
            for (EmojiData emojiData : elements) {
                this.emojis.add(Objects.requireNonNull(emojiData, "emojis element"));
            }
            return this;
        }

        public final Builder addFeature(String element) {
            this.features.add(Objects.requireNonNull(element, "features element"));
            return this;
        }

        public final Builder addFeatures(String ... elements) {
            for (String element : elements) {
                this.features.add(Objects.requireNonNull(element, "features element"));
            }
            return this;
        }

        @JsonProperty(value="features")
        public final Builder features(Iterable<String> elements) {
            this.features.clear();
            return this.addAllFeatures(elements);
        }

        public final Builder addAllFeatures(Iterable<String> elements) {
            for (String element : elements) {
                this.features.add(Objects.requireNonNull(element, "features element"));
            }
            return this;
        }

        @JsonProperty(value="approximate_member_count")
        public final Builder approximateMemberCount(int approximateMemberCount) {
            this.approximateMemberCount = approximateMemberCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="approximate_presence_count")
        public final Builder approximatePresenceCount(int approximatePresenceCount) {
            this.approximatePresenceCount = approximatePresenceCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        public ImmutableGuildPreviewData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGuildPreviewData(null, this.id_build(), this.name, this.icon, this.splash, this.discoverySplash, ImmutableGuildPreviewData.createUnmodifiableList(true, this.emojis), ImmutableGuildPreviewData.createUnmodifiableList(true, this.features), this.approximateMemberCount, this.approximatePresenceCount, this.description);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("approximateMemberCount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("approximatePresenceCount");
            }
            return "Cannot build GuildPreviewData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GuildPreviewData", generator="Immutables")
    static final class Json
    implements GuildPreviewData {
        Id id;
        String name;
        Optional<String> icon = Optional.empty();
        Optional<String> splash = Optional.empty();
        Optional<String> discoverySplash = Optional.empty();
        List<EmojiData> emojis = Collections.emptyList();
        List<String> features = Collections.emptyList();
        int approximateMemberCount;
        boolean approximateMemberCountIsSet;
        int approximatePresenceCount;
        boolean approximatePresenceCountIsSet;
        Optional<String> description = Optional.empty();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="icon")
        public void setIcon(Optional<String> icon) {
            this.icon = icon;
        }

        @JsonProperty(value="splash")
        public void setSplash(Optional<String> splash) {
            this.splash = splash;
        }

        @JsonProperty(value="discovery_splash")
        public void setDiscoverySplash(Optional<String> discoverySplash) {
            this.discoverySplash = discoverySplash;
        }

        @JsonProperty(value="emojis")
        public void setEmojis(List<EmojiData> emojis) {
            this.emojis = emojis;
        }

        @JsonProperty(value="features")
        public void setFeatures(List<String> features) {
            this.features = features;
        }

        @JsonProperty(value="approximate_member_count")
        public void setApproximateMemberCount(int approximateMemberCount) {
            this.approximateMemberCount = approximateMemberCount;
            this.approximateMemberCountIsSet = true;
        }

        @JsonProperty(value="approximate_presence_count")
        public void setApproximatePresenceCount(int approximatePresenceCount) {
            this.approximatePresenceCount = approximatePresenceCount;
            this.approximatePresenceCountIsSet = true;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> icon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> splash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> discoverySplash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<EmojiData> emojis() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> features() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int approximateMemberCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int approximatePresenceCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="GuildPreviewData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildPreviewData, attribute initializers form cycle " + attributes;
        }
    }
}

