/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway;

import discord4j.common.ReactorResources;
import java.util.function.Supplier;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.client.HttpClient;

public class GatewayReactorResources
extends ReactorResources {
    public static final Supplier<Scheduler> DEFAULT_PAYLOAD_SENDER_SCHEDULER = () -> Schedulers.newSingle("d4j-gateway", true);
    private final Scheduler payloadSenderScheduler;

    public GatewayReactorResources(ReactorResources parent) {
        super(parent.getHttpClient(), parent.getTimerTaskScheduler(), parent.getBlockingTaskScheduler());
        this.payloadSenderScheduler = DEFAULT_PAYLOAD_SENDER_SCHEDULER.get();
    }

    public GatewayReactorResources(ReactorResources parent, Scheduler payloadSenderScheduler) {
        super(parent.getHttpClient(), parent.getTimerTaskScheduler(), parent.getBlockingTaskScheduler());
        this.payloadSenderScheduler = payloadSenderScheduler;
    }

    public GatewayReactorResources(HttpClient httpClient, Scheduler timerTaskScheduler, Scheduler blockingTaskScheduler, Scheduler payloadSenderScheduler) {
        super(httpClient, timerTaskScheduler, blockingTaskScheduler);
        this.payloadSenderScheduler = payloadSenderScheduler;
    }

    protected GatewayReactorResources(Builder builder) {
        super(builder);
        this.payloadSenderScheduler = builder.payloadSenderScheduler == null ? DEFAULT_PAYLOAD_SENDER_SCHEDULER.get() : builder.payloadSenderScheduler;
    }

    public static GatewayReactorResources create() {
        return new GatewayReactorResources(new ReactorResources());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ReactorResources reactorResources) {
        return GatewayReactorResources.builder().httpClient(reactorResources.getHttpClient()).timerTaskScheduler(reactorResources.getTimerTaskScheduler()).blockingTaskScheduler(reactorResources.getBlockingTaskScheduler());
    }

    public Builder mutate() {
        return new Builder().httpClient(this.getHttpClient()).timerTaskScheduler(this.getTimerTaskScheduler()).blockingTaskScheduler(this.getBlockingTaskScheduler()).payloadSenderScheduler(this.getPayloadSenderScheduler());
    }

    public Scheduler getPayloadSenderScheduler() {
        return this.payloadSenderScheduler;
    }

    public static class Builder
    extends ReactorResources.Builder {
        private Scheduler payloadSenderScheduler;

        protected Builder() {
        }

        public Builder payloadSenderScheduler(Scheduler payloadSenderScheduler) {
            this.payloadSenderScheduler = payloadSenderScheduler;
            return this;
        }

        @Override
        public Builder httpClient(HttpClient httpClient) {
            super.httpClient(httpClient);
            return this;
        }

        @Override
        public Builder timerTaskScheduler(Scheduler timerTaskScheduler) {
            super.timerTaskScheduler(timerTaskScheduler);
            return this;
        }

        @Override
        public Builder blockingTaskScheduler(Scheduler blockingTaskScheduler) {
            super.blockingTaskScheduler(blockingTaskScheduler);
            return this;
        }

        @Override
        public GatewayReactorResources build() {
            return new GatewayReactorResources(this);
        }
    }
}

