/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.console.command.commands;

import com.github.kokorin.jaffree.ffmpeg.FFmpegProgress;
import com.gmail.berndivader.streamserver.annotation.ConsoleCommand;
import com.gmail.berndivader.streamserver.console.ConsoleRunner;
import com.gmail.berndivader.streamserver.console.command.Command;
import com.gmail.berndivader.streamserver.ffmpeg.BroadcastRunner;
import java.util.concurrent.TimeUnit;

@ConsoleCommand(name="p")
public class ProgressInfo
extends Command {
    @Override
    public boolean execute(String[] args) {
        if (BroadcastRunner.isStreaming()) {
            FFmpegProgress progress = BroadcastRunner.currentProgress;
            if (progress != null) {
                ConsoleRunner.println("===Progress information===");
                long duration = progress.getTime(TimeUnit.SECONDS);
                block23: for (int i1 = 0; i1 < args.length; ++i1) {
                    String option;
                    switch (option = args[i1]) {
                        case "time": {
                            ConsoleRunner.println("Playtime:" + duration / 60L + ":" + duration % 60L);
                            continue block23;
                        }
                        case "frames": 
                        case "frame": {
                            ConsoleRunner.println("Frames: " + progress.getFrame());
                            continue block23;
                        }
                        case "bitrate": 
                        case "bits": {
                            ConsoleRunner.println("Bitrate: " + progress.getBitrate());
                            continue block23;
                        }
                        case "quality": 
                        case "q": {
                            ConsoleRunner.println("Quality: " + progress.getQ());
                            continue block23;
                        }
                        case "fps": {
                            ConsoleRunner.println("FPS: " + progress.getFps());
                            continue block23;
                        }
                        case "drops": {
                            ConsoleRunner.println("Drops: " + progress.getDrop());
                            continue block23;
                        }
                        case "size": {
                            ConsoleRunner.println("Size: " + progress.getSize());
                            continue block23;
                        }
                        case "speed": {
                            ConsoleRunner.println("Speed: " + progress.getSpeed());
                            continue block23;
                        }
                        default: {
                            ConsoleRunner.println("Playtime:" + duration / 60L + ":" + duration % 60L);
                            ConsoleRunner.println("Frames: " + progress.getFrame());
                            ConsoleRunner.println("Bitrate: " + progress.getBitrate());
                            ConsoleRunner.println("Quality: " + progress.getQ());
                            ConsoleRunner.println("FPS: " + progress.getFps());
                            ConsoleRunner.println("Drops: " + progress.getDrop());
                            ConsoleRunner.println("Size: " + progress.getSize());
                            ConsoleRunner.println("Speed: " + progress.getSpeed());
                        }
                    }
                }
            } else {
                ConsoleRunner.println("No progress available atm.");
            }
        } else {
            ConsoleRunner.println("Currently no stream is running.");
        }
        return true;
    }
}

