/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common;

import java.time.Duration;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.scheduler.Scheduler;

public class ResettableInterval {
    private final Scheduler scheduler;
    private final Disposable.Swap task;
    private final EmitterProcessor<Long> backing = EmitterProcessor.create(false);
    private final FluxSink<Long> backingSink = this.backing.sink(FluxSink.OverflowStrategy.LATEST);

    public ResettableInterval(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.task = Disposables.swap();
    }

    public void start(Duration delay, Duration period) {
        this.task.update(Flux.interval(delay, period, this.scheduler).subscribe(this.backingSink::next));
    }

    public void stop() {
        if (this.task.get() != null) {
            ((Disposable)this.task.get()).dispose();
        }
    }

    public Flux<Long> ticks() {
        return this.backing;
    }
}

