/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.dispatch;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.dispatch.DispatchContext;
import discord4j.core.event.domain.lifecycle.ConnectEvent;
import discord4j.core.event.domain.lifecycle.DisconnectEvent;
import discord4j.core.event.domain.lifecycle.GatewayLifecycleEvent;
import discord4j.core.event.domain.lifecycle.ReadyEvent;
import discord4j.core.event.domain.lifecycle.ReconnectEvent;
import discord4j.core.event.domain.lifecycle.ReconnectFailEvent;
import discord4j.core.event.domain.lifecycle.ReconnectStartEvent;
import discord4j.core.event.domain.lifecycle.ResumeEvent;
import discord4j.core.object.entity.User;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.gateway.Ready;
import discord4j.discordjson.json.gateway.Resumed;
import discord4j.gateway.retry.ClosingStateChange;
import discord4j.gateway.retry.GatewayStateChange;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class LifecycleDispatchHandlers {
    LifecycleDispatchHandlers() {
    }

    static Mono<ReadyEvent> ready(DispatchContext<Ready> context) {
        GatewayDiscordClient gateway = context.getGateway();
        Ready dispatch = context.getDispatch();
        UserData userData = dispatch.user();
        long userId = Snowflake.asLong(userData.id());
        User self = new User(gateway, userData);
        Set<ReadyEvent.Guild> guilds = dispatch.guilds().stream().map(g -> new ReadyEvent.Guild(Snowflake.asLong(g.id()), g.unavailable().get() == false)).collect(Collectors.toSet());
        Mono<Void> saveUser = context.getStateHolder().getUserStore().save(userId, userData);
        return saveUser.thenReturn(new ReadyEvent(gateway, context.getShardInfo(), dispatch, self, guilds));
    }

    static Mono<ResumeEvent> resumed(DispatchContext<Resumed> context) {
        return Mono.just(new ResumeEvent(context.getGateway(), context.getShardInfo(), context.getDispatch().trace()));
    }

    static Mono<? extends GatewayLifecycleEvent> gatewayStateChanged(DispatchContext<GatewayStateChange> context) {
        GatewayDiscordClient gateway = context.getGateway();
        GatewayStateChange dispatch = context.getDispatch();
        switch (dispatch.getState()) {
            case CONNECTED: {
                return Mono.just(new ConnectEvent(gateway, context.getShardInfo()));
            }
            case RETRY_STARTED: 
            case RETRY_RESUME_STARTED: {
                return Mono.just(new ReconnectStartEvent(gateway, context.getShardInfo()));
            }
            case RETRY_FAILED: {
                return Mono.just(new ReconnectFailEvent(gateway, context.getShardInfo(), dispatch.getCurrentAttempt()));
            }
            case RETRY_SUCCEEDED: {
                return Mono.just(new ReconnectEvent(gateway, context.getShardInfo(), dispatch.getCurrentAttempt()));
            }
            case DISCONNECTED: 
            case DISCONNECTED_RESUME: {
                ClosingStateChange c = (ClosingStateChange)context.getDispatch();
                return Mono.just(new DisconnectEvent(gateway, context.getShardInfo(), c.getStatus(), c.getBehavior().getCause()));
            }
        }
        return Mono.empty();
    }
}

