/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.message;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.message.MessageEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.gateway.ShardInfo;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class MessageCreateEvent
extends MessageEvent {
    private final Message message;
    @Nullable
    private final Long guildId;
    @Nullable
    private final Member member;

    public MessageCreateEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, Message message, @Nullable Long guildId, @Nullable Member member) {
        super(gateway, shardInfo);
        this.message = message;
        this.guildId = guildId;
        this.member = member;
    }

    public Message getMessage() {
        return this.message;
    }

    public Optional<Snowflake> getGuildId() {
        return Optional.ofNullable(this.guildId).map(Snowflake::of);
    }

    public Mono<Guild> getGuild() {
        return Mono.justOrEmpty(this.getGuildId()).flatMap(this.getClient()::getGuildById);
    }

    public Optional<Member> getMember() {
        return Optional.ofNullable(this.member);
    }

    public String toString() {
        return "MessageCreateEvent{message=" + this.message + ", guildId=" + this.guildId + ", member=" + this.member + '}';
    }
}

