/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.command.ApplicationCommandOptionChoice;
import discord4j.discordjson.json.ApplicationCommandOptionChoiceData;
import discord4j.discordjson.json.ApplicationCommandOptionData;
import discord4j.rest.util.ApplicationCommandOptionType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Experimental
public class ApplicationCommandOption
implements DiscordObject {
    public static final int MAX_NAME_LENGTH = 32;
    public static final int MAX_DESCRIPTION_LENGTH = 100;
    private final GatewayDiscordClient gateway;
    private final ApplicationCommandOptionData data;

    public ApplicationCommandOption(GatewayDiscordClient gateway, ApplicationCommandOptionData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public ApplicationCommandOptionType getType() {
        return ApplicationCommandOptionType.of(this.data.type());
    }

    public String getName() {
        return this.data.name();
    }

    public String getDescription() {
        return this.data.description();
    }

    public boolean isRequired() {
        return this.data.required().toOptional().orElse(false);
    }

    public List<ApplicationCommandOptionChoice> getChoices() {
        return this.data.choices().toOptional().orElse(Collections.emptyList()).stream().map(data -> new ApplicationCommandOptionChoice(this.gateway, (ApplicationCommandOptionChoiceData)data)).collect(Collectors.toList());
    }

    public Optional<ApplicationCommandOptionChoice> getChoice(String name) {
        return this.getChoices().stream().filter(choice -> choice.getName().equals(name)).findFirst();
    }

    public List<ApplicationCommandOption> getOptions() {
        return this.data.options().toOptional().orElse(Collections.emptyList()).stream().map(data -> new ApplicationCommandOption(this.gateway, (ApplicationCommandOptionData)data)).collect(Collectors.toList());
    }

    public Optional<ApplicationCommandOption> getOption(String name) {
        return this.getOptions().stream().filter(option -> option.getName().equals(name)).findFirst();
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }
}

